/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.platform;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.artofsolving.jodconverter.office.OfficeException;
import org.exoplatform.ecm.connector.platform.DocumentRenderer;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Path(value="/contents/populate/")
public class PopulateConnector
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)PopulateConnector.class.getName());
    protected static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    protected static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    protected static final String WORKSPACE_NAME = "collaboration";
    private static final String SOURCE_DATA_FOLDER_PATH = "/contents";
    private static final String DICTIONARY_FILE = "dictionary.txt";
    private static final String[] SOURCE_FILES1 = new String[]{"content.doc application/msword", "content.pdf application/pdf", "content.ppt application/ppt", "content.xls application/xls"};
    private static final String[] SOURCE_FILES2 = new String[]{"image.jpg image/jpeg", "image.jpeg image/jpeg", "image.gif image/gif", "image.png image/png"};
    private static final String IMPORTED_DOCUMENTS_FOLDER = "importedDocuments";
    private static final int MAX_NORMAL_DATA_RATE = 300;
    private static final int DEFAULT_DOCUMENT_SIZE = 1;
    private RepositoryService repoService_;
    private CmsService cmsService_;
    private WCMPublicationService publicationService_;
    private DataDistributionManager dataDistributionManager_;
    private TaxonomyService taxonomyService_;
    private JodConverterService jodConverter_;

    public PopulateConnector(RepositoryService repositoryService, CmsService cmsService, WCMPublicationService publicationService, DataDistributionManager dataDistributionManager, TaxonomyService taxonomyService, JodConverterService jodConverter) {
        this.repoService_ = repositoryService;
        this.cmsService_ = cmsService;
        this.publicationService_ = publicationService;
        this.dataDistributionManager_ = dataDistributionManager;
        this.taxonomyService_ = taxonomyService;
        this.jodConverter_ = jodConverter;
    }

    private Response initializeLoadData(boolean isPublishDoc, boolean isGenerateNewData, int size) {
        SessionProvider sessionProvider = null;
        try {
            String mimeType;
            String importedFileName;
            sessionProvider = WCMCoreUtils.getUserSessionProvider();
            Session session = sessionProvider.getSession(WORKSPACE_NAME, this.repoService_.getCurrentRepository());
            if (session.getRootNode().hasNode(IMPORTED_DOCUMENTS_FOLDER)) {
                ((TrashService)WCMCoreUtils.getService(TrashService.class)).moveToTrash(session.getRootNode().getNode(IMPORTED_DOCUMENTS_FOLDER), sessionProvider);
                session.save();
            }
            Node importedFolderNode = session.getRootNode().addNode(IMPORTED_DOCUMENTS_FOLDER);
            importedFolderNode.addMixin("exo:hiddenable");
            session.save();
            ArrayList<String> generatedFiles = new ArrayList<String>(Arrays.asList(SOURCE_FILES1));
            ArrayList<String> initializedFiles = new ArrayList<String>(Arrays.asList(SOURCE_FILES2));
            if (!isGenerateNewData) {
                generatedFiles.clear();
                initializedFiles.addAll(Arrays.asList(SOURCE_FILES1));
            }
            for (String importedFile : initializedFiles) {
                importedFileName = importedFile.split(" ")[0];
                mimeType = importedFile.split(" ")[1];
                if (session.itemExists(importedFolderNode.getPath() + "/" + importedFileName)) continue;
                InputStream inputStream = this.getClass().getResourceAsStream("/contents/" + importedFileName);
                String fileNodeName = this.cmsService_.storeNode("nt:file", importedFolderNode, this.getInputProperties(importedFileName, inputStream, mimeType), true);
                if (!isPublishDoc) continue;
                this.publicationService_.updateLifecyleOnChangeContent((Node)session.getItem(fileNodeName), "acme", "root", "published");
            }
            for (String importedFile : generatedFiles) {
                importedFileName = importedFile.split(" ")[0];
                mimeType = importedFile.split(" ")[1];
                if (session.itemExists(importedFolderNode.getPath() + "/" + importedFileName)) continue;
                String fileNodeName = this.generateFile(importedFolderNode, importedFileName, size, mimeType);
                if (!isPublishDoc) continue;
                this.publicationService_.updateLifecyleOnChangeContent((Node)session.getItem(fileNodeName), "acme", "root", "published");
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return Response.serverError().build();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateFile(Node parentNode, String fileName, int size, String mimeType) throws Exception {
        block14: {
            fileExtension = fileName.substring(fileName.indexOf(46) + 1);
            br = null;
            br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/contents/dictionary.txt")));
            line = null;
            dictionary = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                for (String word : line.split("[ .,;]")) {
                    dictionary.add(word);
                }
            }
            br.close();
            size = size == 0 ? 1 : size;
            content = new StringBuilder("Lorem ");
            sentenceLength = (int)(Math.random() * 20.0) + 5;
            while (content.length() < size * 1024) {
                content.append((String)dictionary.get((int)(Math.random() * (double)dictionary.size())));
                if (--sentenceLength == 0) {
                    content.append(". ");
                    sentenceLength = (int)(Math.random() * 20.0) + 5;
                    continue;
                }
                content.append(' ');
            }
            content.append('.');
            tempFile = null;
            if (fileExtension.equalsIgnoreCase("doc")) {
                tempFile = File.createTempFile("content_temp", fileExtension);
                input = new BufferedInputStream(new ByteArrayInputStream(content.toString().getBytes()));
                out = new BufferedOutputStream(new FileOutputStream(tempFile));
                in = File.createTempFile("content_tmp", null);
                this.read(input, new BufferedOutputStream(new FileOutputStream(in)));
                try {
                    success = this.jodConverter_.convert(in, tempFile, fileExtension);
                    if (success) ** GOTO lbl63
                    tempFile.delete();
                }
                catch (OfficeException connection) {
                    tempFile.delete();
                    if (!PopulateConnector.LOG.isErrorEnabled()) ** GOTO lbl63
                    PopulateConnector.LOG.error((Object)"Exception when using Office Service");
                }
                finally {
                    in.delete();
                    out.flush();
                    out.close();
                }
            } else {
                try {
                    documentRender = new DocumentRenderer();
                    success = documentRender.createDocument(content.toString(), fileName, fileExtension);
                    if (success) {
                        tempFile = new File(fileName);
                    }
                }
                catch (Exception ex) {
                    if (!PopulateConnector.LOG.isErrorEnabled()) break block14;
                    PopulateConnector.LOG.error((Object)"Exception when creating document");
                }
            }
        }
        inputStream = new FileInputStream(tempFile);
        fileNodeName = this.cmsService_.storeNode("nt:file", parentNode, this.getInputProperties(fileName, inputStream, mimeType), true);
        return fileNodeName;
    }

    private void read(InputStream is, OutputStream os) throws Exception {
        int bufferLength = 1024;
        int readLength = 0;
        while (readLength > -1) {
            byte[] chunk = new byte[bufferLength];
            readLength = is.read(chunk);
            if (readLength <= 0) continue;
            os.write(chunk, 0, readLength);
        }
        os.flush();
        os.close();
    }

    @GET
    @Path(value="/initialLoad")
    public Response initialLoad(@QueryParam(value="isPublishDoc") boolean isPublishDoc) {
        return this.initializeLoadData(isPublishDoc, false, 0);
    }

    @GET
    @Path(value="/storage")
    public Response storage(@QueryParam(value="name") String name, @QueryParam(value="docType") String docType, @QueryParam(value="from") int from, @QueryParam(value="to") int to, @QueryParam(value="workspace") String workspace, @QueryParam(value="folderPath") String folderPath, @QueryParam(value="categories") String categories, @QueryParam(value="size") Integer size) {
        SessionProvider sessionProvider = null;
        try {
            if (!folderPath.startsWith("/")) {
                folderPath = "/" + folderPath;
            }
            sessionProvider = WCMCoreUtils.getUserSessionProvider();
            Session sourceSession = sessionProvider.getSession(WORKSPACE_NAME, this.repoService_.getCurrentRepository());
            Session session = sessionProvider.getSession(workspace, this.repoService_.getCurrentRepository());
            this.initializeLoadData(true, true, size == null ? 0 : size);
            Node sourceNode = this.getSourceNode(sourceSession, IMPORTED_DOCUMENTS_FOLDER, docType);
            Node targetFolder = this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.NONE).getOrCreateDataNode(session.getRootNode(), folderPath);
            if (to - from < 300) {
                for (int i = from; i <= to; ++i) {
                    Node newNode;
                    String storedNodePath = folderPath + "/" + name + i + '.' + docType;
                    if (!session.itemExists(storedNodePath)) {
                        session.getWorkspace().copy(WORKSPACE_NAME, sourceNode.getPath(), storedNodePath);
                        newNode = (Node)session.getItem(storedNodePath);
                        newNode.setProperty("exo:title", name + i + '.' + docType);
                        session.save();
                    }
                    newNode = (Node)session.getItem(storedNodePath);
                    this.addTaxonomy(newNode, categories);
                }
            } else {
                DataDistributionType dataDistributionType = this.dataDistributionManager_.getDataDistributionType(DataDistributionMode.OPTIMIZED);
                Node parentFolder = null;
                for (int i = from; i <= to; ++i) {
                    Node newNode;
                    String storedNodePath;
                    if (i == from || i % 100 == 0) {
                        parentFolder = dataDistributionType.getOrCreateDataNode(targetFolder, name + i);
                    }
                    if (!session.itemExists(storedNodePath = parentFolder.getPath() + "/" + name + i + '.' + docType)) {
                        session.getWorkspace().copy(WORKSPACE_NAME, sourceNode.getPath(), storedNodePath);
                        newNode = (Node)session.getItem(storedNodePath);
                        newNode.setProperty("exo:title", name + i + '.' + docType);
                        session.save();
                    }
                    newNode = (Node)session.getItem(storedNodePath);
                    this.addTaxonomy(newNode, categories);
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Data Injector for ECMS finished successfully!....");
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Data Injector for ECMS failed!....");
            }
            return Response.serverError().build();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private Node getSourceNode(Session session, String folderPath, String docType) throws Exception {
        Node folderNode = session.getRootNode().getNode(folderPath);
        NodeIterator iter = folderNode.getNodes();
        while (iter.hasNext()) {
            Node childNode = iter.nextNode();
            String nodeName = childNode.getName();
            int index = nodeName.indexOf(".");
            if (index <= -1 || docType == null || !docType.equals(nodeName.substring(index + 1))) continue;
            return childNode;
        }
        return null;
    }

    private void addTaxonomy(Node node, String categoryList) throws Exception {
        if (categoryList == null) {
            return;
        }
        for (String category : categoryList.split(",")) {
            try {
                ArrayList<String> arrayCategoryPath = new ArrayList<String>();
                for (String categoryPart : category.split("/")) {
                    if (categoryPart.trim().length() <= 0) continue;
                    arrayCategoryPath.add(categoryPart.trim());
                }
                if (arrayCategoryPath.size() == 1) {
                    this.taxonomyService_.addCategory(node, (String)arrayCategoryPath.get(0), "");
                    continue;
                }
                StringBuffer categoryPath = new StringBuffer("/");
                for (int i = 1; i < arrayCategoryPath.size(); ++i) {
                    categoryPath.append((String)arrayCategoryPath.get(i)).append("/");
                }
                this.taxonomyService_.addCategory(node, (String)arrayCategoryPath.get(0), categoryPath.toString());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e);
            }
        }
    }

    private Map<String, JcrInputProperty> getInputProperties(String name, InputStream inputStream, String mimeType) {
        HashMap<String, JcrInputProperty> inputProperties = new HashMap<String, JcrInputProperty>();
        JcrInputProperty nodeInput = new JcrInputProperty();
        nodeInput.setJcrPath("/node");
        nodeInput.setValue((Object)name);
        nodeInput.setMixintype("mix:i18n,mix:votable,mix:commentable");
        nodeInput.setType(1);
        inputProperties.put("/node", nodeInput);
        JcrInputProperty jcrContent = new JcrInputProperty();
        jcrContent.setJcrPath("/node/jcr:content");
        jcrContent.setValue((Object)"");
        jcrContent.setMixintype("dc:elementSet");
        jcrContent.setNodetype("nt:resource");
        jcrContent.setType(1);
        inputProperties.put("/node/jcr:content", jcrContent);
        JcrInputProperty jcrData = new JcrInputProperty();
        jcrData.setJcrPath("/node/jcr:content/jcr:data");
        jcrData.setValue((Object)inputStream);
        inputProperties.put("/node/jcr:content/jcr:data", jcrData);
        JcrInputProperty jcrMimeType = new JcrInputProperty();
        jcrMimeType.setJcrPath("/node/jcr:content/jcr:mimeType");
        jcrMimeType.setValue((Object)mimeType);
        inputProperties.put("/node/jcr:content/jcr:mimeType", jcrMimeType);
        JcrInputProperty jcrLastModified = new JcrInputProperty();
        jcrLastModified.setJcrPath("/node/jcr:content/jcr:lastModified");
        jcrLastModified.setValue((Object)new GregorianCalendar());
        inputProperties.put("/node/jcr:content/jcr:lastModified", jcrLastModified);
        JcrInputProperty jcrEncoding = new JcrInputProperty();
        jcrEncoding.setJcrPath("/node/jcr:content/jcr:encoding");
        jcrEncoding.setValue((Object)"UTF-8");
        inputProperties.put("/node/jcr:content/jcr:encoding", jcrEncoding);
        return inputProperties;
    }
}

