/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.platform;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.pdfbox.PDFToImage;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextBox;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.sl.usermodel.Slide;

public class DocumentRenderer {
    public boolean createDocument(String content, String fileName, String fileExtension) {
        try {
            if (fileExtension.equalsIgnoreCase("xls")) {
                return this.createExcelDocument(content, fileName);
            }
            if (fileExtension.equalsIgnoreCase("ppt")) {
                return this.createPowerPointDocument(content, fileName);
            }
            if (fileExtension.equalsIgnoreCase("pdf")) {
                return this.createPDFDocument(content, fileName);
            }
            if (fileExtension.equalsIgnoreCase("jpg") || fileExtension.equalsIgnoreCase("jpeg") || fileExtension.equalsIgnoreCase("png")) {
                return this.createImageDocument(content, fileName);
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean createExcelDocument(String content, String fileName) {
        try {
            HSSFWorkbook hwb = new HSSFWorkbook();
            HSSFSheet sheet = hwb.createSheet("new sheet");
            String[] strs = this.splitByNumber(content, 500);
            for (int i = 0; i < strs.length; ++i) {
                HSSFRow rowhead = sheet.createRow((int)((short)i));
                rowhead.createCell((short)0).setCellValue(strs[i]);
            }
            FileOutputStream fileOut = new FileOutputStream(fileName);
            hwb.write((OutputStream)fileOut);
            fileOut.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean createPowerPointDocument(String content, String fileName) {
        try {
            HSLFSlideShow ppt = new HSLFSlideShow();
            Slide s1 = ppt.createSlide();
            HSLFTextBox txt = new HSLFTextBox();
            txt.setText(content);
            s1.addShape((Shape)txt);
            FileOutputStream out = new FileOutputStream(fileName);
            ppt.write((OutputStream)out);
            out.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean createPDFDocument(String content, String fileName) {
        try {
            FileOutputStream file = new FileOutputStream(new File(fileName));
            Document document = new Document();
            PdfWriter.getInstance((Document)document, (OutputStream)file);
            document.open();
            document.add((Element)new Paragraph(content));
            document.add((Element)new Paragraph(new Date().toString()));
            document.close();
            ((OutputStream)file).close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean createImageDocument(String content, String fileName) {
        try {
            String fileExtension = fileName.substring(fileName.indexOf(46) + 1);
            FileOutputStream file = new FileOutputStream(new File("temp.pdf"));
            Document document = new Document();
            PdfWriter.getInstance((Document)document, (OutputStream)file);
            document.open();
            document.add((Element)new Paragraph(content));
            document.add((Element)new Paragraph(new Date().toString()));
            document.close();
            ((OutputStream)file).close();
            String[] args_1 = new String[]{"-outputPrefix", fileName.substring(0, fileName.indexOf(".")), "-imageType", fileExtension, "temp.pdf"};
            PDFToImage.main((String[])args_1);
            new File("temp.pdf").delete();
            return true;
        }
        catch (Exception ex) {
            new File("temp.pdf").delete();
            return false;
        }
    }

    public void read(InputStream is, OutputStream os) throws Exception {
        int bufferLength = 1024;
        int readLength = 0;
        while (readLength > -1) {
            byte[] chunk = new byte[bufferLength];
            readLength = is.read(chunk);
            if (readLength <= 0) continue;
            os.write(chunk, 0, readLength);
        }
        os.flush();
        os.close();
    }

    private String[] splitByNumber(String s, int size) {
        if (s == null || size <= 0) {
            return null;
        }
        int chunks = s.length() / size + (s.length() % size > 0 ? 1 : 0);
        String[] arr = new String[chunks];
        int i = 0;
        int j = 0;
        int l = s.length();
        while (i < l) {
            arr[j] = s.substring(i, Math.min(l, i + size));
            i += size;
            ++j;
        }
        return arr;
    }
}

