/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.common.Duration;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.common.Function;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.common.Functions;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.common.Timestamp;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats.Aggregation;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats.AggregationData;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats.AutoValue_ViewData;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats.AutoValue_ViewData_AggregationWindowData_CumulativeData;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats.AutoValue_ViewData_AggregationWindowData_IntervalData;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats.Measure;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats.View;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.tags.TagValue;

@Immutable
public abstract class ViewData {
    ViewData() {
    }

    public abstract View getView();

    public abstract Map<List<TagValue>, AggregationData> getAggregationMap();

    @Deprecated
    public abstract AggregationWindowData getWindowData();

    public abstract Timestamp getStart();

    public abstract Timestamp getEnd();

    @Deprecated
    public static ViewData create(final View view, Map<? extends List<TagValue>, ? extends AggregationData> map, AggregationWindowData windowData) {
        ViewData.checkWindow(view.getWindow(), windowData);
        final HashMap deepCopy = new HashMap();
        for (Map.Entry<? extends List<TagValue>, ? extends AggregationData> entry : map.entrySet()) {
            ViewData.checkAggregation(view.getAggregation(), entry.getValue(), view.getMeasure());
            deepCopy.put(Collections.unmodifiableList(new ArrayList(entry.getKey())), entry.getValue());
        }
        return windowData.match(new Function<AggregationWindowData.CumulativeData, ViewData>(){

            @Override
            public ViewData apply(AggregationWindowData.CumulativeData arg) {
                return ViewData.createInternal(view, Collections.unmodifiableMap(deepCopy), arg, arg.getStart(), arg.getEnd());
            }
        }, new Function<AggregationWindowData.IntervalData, ViewData>(){

            @Override
            public ViewData apply(AggregationWindowData.IntervalData arg) {
                Duration duration = ((View.AggregationWindow.Interval)view.getWindow()).getDuration();
                return ViewData.createInternal(view, Collections.unmodifiableMap(deepCopy), arg, arg.getEnd().addDuration(Duration.create(-duration.getSeconds(), -duration.getNanos())), arg.getEnd());
            }
        }, Functions.throwAssertionError());
    }

    public static ViewData create(View view, Map<? extends List<TagValue>, ? extends AggregationData> map, Timestamp start, Timestamp end) {
        HashMap deepCopy = new HashMap();
        for (Map.Entry<? extends List<TagValue>, ? extends AggregationData> entry : map.entrySet()) {
            ViewData.checkAggregation(view.getAggregation(), entry.getValue(), view.getMeasure());
            deepCopy.put(Collections.unmodifiableList(new ArrayList(entry.getKey())), entry.getValue());
        }
        return ViewData.createInternal(view, Collections.unmodifiableMap(deepCopy), AggregationWindowData.CumulativeData.create(start, end), start, end);
    }

    private static ViewData createInternal(View view, Map<List<TagValue>, AggregationData> aggregationMap, AggregationWindowData window, Timestamp start, Timestamp end) {
        Map<List<TagValue>, AggregationData> map = aggregationMap;
        return new AutoValue_ViewData(view, map, window, start, end);
    }

    private static void checkWindow(View.AggregationWindow window, final AggregationWindowData windowData) {
        window.match(new Function<View.AggregationWindow.Cumulative, Void>(){

            @Override
            public Void apply(View.AggregationWindow.Cumulative arg) {
                ViewData.throwIfWindowMismatch(windowData instanceof AggregationWindowData.CumulativeData, arg, windowData);
                return null;
            }
        }, new Function<View.AggregationWindow.Interval, Void>(){

            @Override
            public Void apply(View.AggregationWindow.Interval arg) {
                ViewData.throwIfWindowMismatch(windowData instanceof AggregationWindowData.IntervalData, arg, windowData);
                return null;
            }
        }, Functions.throwAssertionError());
    }

    private static void throwIfWindowMismatch(boolean isValid, View.AggregationWindow window, AggregationWindowData windowData) {
        if (!isValid) {
            throw new IllegalArgumentException(ViewData.createErrorMessageForWindow(window, windowData));
        }
    }

    private static String createErrorMessageForWindow(View.AggregationWindow window, AggregationWindowData windowData) {
        return "AggregationWindow and AggregationWindowData types mismatch. AggregationWindow: " + window.getClass().getSimpleName() + " AggregationWindowData: " + windowData.getClass().getSimpleName();
    }

    private static void checkAggregation(final Aggregation aggregation, final AggregationData aggregationData, final Measure measure) {
        aggregation.match(new Function<Aggregation.Sum, Void>(){

            @Override
            public Void apply(Aggregation.Sum arg) {
                measure.match(new Function<Measure.MeasureDouble, Void>(){

                    @Override
                    public Void apply(Measure.MeasureDouble arg) {
                        ViewData.throwIfAggregationMismatch(aggregationData instanceof AggregationData.SumDataDouble, aggregation, aggregationData);
                        return null;
                    }
                }, new Function<Measure.MeasureLong, Void>(){

                    @Override
                    public Void apply(Measure.MeasureLong arg) {
                        ViewData.throwIfAggregationMismatch(aggregationData instanceof AggregationData.SumDataLong, aggregation, aggregationData);
                        return null;
                    }
                }, Functions.throwAssertionError());
                return null;
            }
        }, new Function<Aggregation.Count, Void>(){

            @Override
            public Void apply(Aggregation.Count arg) {
                ViewData.throwIfAggregationMismatch(aggregationData instanceof AggregationData.CountData, aggregation, aggregationData);
                return null;
            }
        }, new Function<Aggregation.Distribution, Void>(){

            @Override
            public Void apply(Aggregation.Distribution arg) {
                ViewData.throwIfAggregationMismatch(aggregationData instanceof AggregationData.DistributionData, aggregation, aggregationData);
                return null;
            }
        }, new Function<Aggregation.LastValue, Void>(){

            @Override
            public Void apply(Aggregation.LastValue arg) {
                measure.match(new Function<Measure.MeasureDouble, Void>(){

                    @Override
                    public Void apply(Measure.MeasureDouble arg) {
                        ViewData.throwIfAggregationMismatch(aggregationData instanceof AggregationData.LastValueDataDouble, aggregation, aggregationData);
                        return null;
                    }
                }, new Function<Measure.MeasureLong, Void>(){

                    @Override
                    public Void apply(Measure.MeasureLong arg) {
                        ViewData.throwIfAggregationMismatch(aggregationData instanceof AggregationData.LastValueDataLong, aggregation, aggregationData);
                        return null;
                    }
                }, Functions.throwAssertionError());
                return null;
            }
        }, new Function<Aggregation, Void>(){

            @Override
            public Void apply(Aggregation arg) {
                if (arg instanceof Aggregation.Mean) {
                    ViewData.throwIfAggregationMismatch(aggregationData instanceof AggregationData.MeanData, aggregation, aggregationData);
                    return null;
                }
                throw new AssertionError();
            }
        });
    }

    private static void throwIfAggregationMismatch(boolean isValid, Aggregation aggregation, AggregationData aggregationData) {
        if (!isValid) {
            throw new IllegalArgumentException(ViewData.createErrorMessageForAggregation(aggregation, aggregationData));
        }
    }

    private static String createErrorMessageForAggregation(Aggregation aggregation, AggregationData aggregationData) {
        return "Aggregation and AggregationData types mismatch. Aggregation: " + aggregation.getClass().getSimpleName() + " AggregationData: " + aggregationData.getClass().getSimpleName();
    }

    @Deprecated
    @Immutable
    public static abstract class AggregationWindowData {
        private AggregationWindowData() {
        }

        public abstract <T> T match(Function<? super CumulativeData, T> var1, Function<? super IntervalData, T> var2, Function<? super AggregationWindowData, T> var3);

        @Deprecated
        @Immutable
        public static abstract class IntervalData
        extends AggregationWindowData {
            IntervalData() {
            }

            public abstract Timestamp getEnd();

            @Override
            public final <T> T match(Function<? super CumulativeData, T> p0, Function<? super IntervalData, T> p1, Function<? super AggregationWindowData, T> defaultFunction) {
                return p1.apply(this);
            }

            public static IntervalData create(Timestamp end) {
                return new AutoValue_ViewData_AggregationWindowData_IntervalData(end);
            }
        }

        @Deprecated
        @Immutable
        public static abstract class CumulativeData
        extends AggregationWindowData {
            CumulativeData() {
            }

            public abstract Timestamp getStart();

            public abstract Timestamp getEnd();

            @Override
            public final <T> T match(Function<? super CumulativeData, T> p0, Function<? super IntervalData, T> p1, Function<? super AggregationWindowData, T> defaultFunction) {
                return p0.apply(this);
            }

            public static CumulativeData create(Timestamp start, Timestamp end) {
                if (start.compareTo(end) > 0) {
                    throw new IllegalArgumentException("Start time is later than end time.");
                }
                return new AutoValue_ViewData_AggregationWindowData_CumulativeData(start, end);
            }
        }
    }
}

