/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.googleapis;

import java.io.IOException;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.EmptyContent;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.HttpExecuteInterceptor;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.HttpRequest;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.HttpRequestInitializer;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.UrlEncodedContent;

public final class MethodOverride
implements HttpExecuteInterceptor,
HttpRequestInitializer {
    public static final String HEADER = "X-HTTP-Method-Override";
    static final int MAX_URL_LENGTH = 2048;
    private final boolean overrideAllMethods;

    public MethodOverride() {
        this(false);
    }

    MethodOverride(boolean overrideAllMethods) {
        this.overrideAllMethods = overrideAllMethods;
    }

    @Override
    public void initialize(HttpRequest request) {
        request.setInterceptor(this);
    }

    @Override
    public void intercept(HttpRequest request) throws IOException {
        if (this.overrideThisMethod(request)) {
            String requestMethod = request.getRequestMethod();
            request.setRequestMethod("POST");
            request.getHeaders().set(HEADER, requestMethod);
            if (requestMethod.equals("GET")) {
                request.setContent(new UrlEncodedContent(request.getUrl().clone()));
                request.getUrl().clear();
            } else if (request.getContent() == null) {
                request.setContent(new EmptyContent());
            }
        }
    }

    private boolean overrideThisMethod(HttpRequest request) throws IOException {
        String requestMethod = request.getRequestMethod();
        if (requestMethod.equals("POST")) {
            return false;
        }
        if (requestMethod.equals("GET") ? request.getUrl().build().length() > 2048 : this.overrideAllMethods) {
            return true;
        }
        return !request.getTransport().supportsMethod(requestMethod);
    }

    public static final class Builder {
        private boolean overrideAllMethods;

        public MethodOverride build() {
            return new MethodOverride(this.overrideAllMethods);
        }

        public boolean getOverrideAllMethods() {
            return this.overrideAllMethods;
        }

        public Builder setOverrideAllMethods(boolean overrideAllMethods) {
            this.overrideAllMethods = overrideAllMethods;
            return this;
        }
    }
}

