/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.Participant;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IParticipantCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IParticipantCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ParticipantCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ParticipantCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ParticipantCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ParticipantRequestBuilder;

public class ParticipantCollectionRequest
extends BaseCollectionRequest<ParticipantCollectionResponse, IParticipantCollectionPage>
implements IParticipantCollectionRequest {
    public ParticipantCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ParticipantCollectionResponse.class, IParticipantCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IParticipantCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ParticipantCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IParticipantCollectionPage get() throws ClientException {
        ParticipantCollectionResponse response = (ParticipantCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Participant newParticipant, ICallback<Participant> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ParticipantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newParticipant, callback);
    }

    @Override
    public Participant post(Participant newParticipant) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ParticipantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newParticipant);
    }

    @Override
    public IParticipantCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IParticipantCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IParticipantCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IParticipantCollectionPage buildFromResponse(ParticipantCollectionResponse response) {
        ParticipantCollectionRequestBuilder builder = response.nextLink != null ? new ParticipantCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ParticipantCollectionPage page = new ParticipantCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

