/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.UserActivity;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IUserActivityCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IUserActivityCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.UserActivityCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.UserActivityCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.UserActivityCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.UserActivityRequestBuilder;

public class UserActivityCollectionRequest
extends BaseCollectionRequest<UserActivityCollectionResponse, IUserActivityCollectionPage>
implements IUserActivityCollectionRequest {
    public UserActivityCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserActivityCollectionResponse.class, IUserActivityCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IUserActivityCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(UserActivityCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserActivityCollectionPage get() throws ClientException {
        UserActivityCollectionResponse response = (UserActivityCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(UserActivity newUserActivity, ICallback<UserActivity> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new UserActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newUserActivity, callback);
    }

    @Override
    public UserActivity post(UserActivity newUserActivity) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UserActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newUserActivity);
    }

    @Override
    public IUserActivityCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IUserActivityCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUserActivityCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IUserActivityCollectionPage buildFromResponse(UserActivityCollectionResponse response) {
        UserActivityCollectionRequestBuilder builder = response.nextLink != null ? new UserActivityCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UserActivityCollectionPage page = new UserActivityCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

