/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DeviceManagementPartner;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceManagementPartnerCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceManagementPartnerCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceManagementPartnerCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DeviceManagementPartnerRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDeviceManagementPartnerCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDeviceManagementPartnerCollectionRequest;

public class DeviceManagementPartnerCollectionRequest
extends BaseCollectionRequest<DeviceManagementPartnerCollectionResponse, IDeviceManagementPartnerCollectionPage>
implements IDeviceManagementPartnerCollectionRequest {
    public DeviceManagementPartnerCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceManagementPartnerCollectionResponse.class, IDeviceManagementPartnerCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceManagementPartnerCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceManagementPartnerCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceManagementPartnerCollectionPage get() throws ClientException {
        DeviceManagementPartnerCollectionResponse response = (DeviceManagementPartnerCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceManagementPartner newDeviceManagementPartner, ICallback<DeviceManagementPartner> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceManagementPartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceManagementPartner, callback);
    }

    @Override
    public DeviceManagementPartner post(DeviceManagementPartner newDeviceManagementPartner) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceManagementPartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceManagementPartner);
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IDeviceManagementPartnerCollectionPage buildFromResponse(DeviceManagementPartnerCollectionResponse response) {
        DeviceManagementPartnerCollectionRequestBuilder builder = response.nextLink != null ? new DeviceManagementPartnerCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceManagementPartnerCollectionPage page = new DeviceManagementPartnerCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

