/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control;

import java.io.Writer;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.security.csrf.CSRFTokenUtil;
import org.exoplatform.webui.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/UIPreferencesForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AdvanceActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={BackActionListener.class})})
public class UIPreferencesForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_ENABLESTRUCTURE = "enableStructure";
    public static final String FIELD_SHOWSIDEBAR = "showSideBar";
    public static final String FIELD_SHOWNONDOCUMENT = "showNonDocument";
    public static final String FIELD_SHOWREFDOCUMENTS = "showRefDocuments";
    public static final String FIELD_SHOW_HIDDEN_NODE = "showHiddenNode";
    public static final String FIELD_SHOW_ITEMS_BY_USER = "showItemsByUserInTimeline";
    public static final String FIELD_ENABLE_DRAG_AND_DROP = "enableDragAndDrop";
    public static final String FIELD_SHORTBY = "sortBy";
    public static final String FIELD_ORDERBY = "order";
    public static final String FIELD_PROPERTY = "property";
    public static final String NODES_PER_PAGE = "nodesPerPage";
    public static final String FIELD_QUERY_TYPE = "queryType";
    private boolean advancePreferences = false;

    public UIPreferencesForm() throws Exception {
        String XPathQuery;
        String SQLQuery;
        String descendingOrder;
        String ascendingOrder;
        String sortByModifiedDate;
        String sortByCreatedDate;
        String sortByNodeType;
        String sortByNodeName;
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            sortByNodeName = res.getString("UIPreferencesForm.label.Alphabetic");
            sortByNodeType = res.getString("UIPreferencesForm.label.Type");
            sortByCreatedDate = res.getString("UIPreferencesForm.label.CreatedDate");
            sortByModifiedDate = res.getString("UIPreferencesForm.label.ModifiedDate");
            ascendingOrder = res.getString("UIPreferencesForm.label.Ascending");
            descendingOrder = res.getString("UIPreferencesForm.label.Descending");
            SQLQuery = res.getString("UIPreferencesForm.label.SQL");
            XPathQuery = res.getString("UIPreferencesForm.label.XPATH");
        }
        catch (Exception e) {
            sortByNodeName = "Alphabetic";
            sortByNodeType = "Type";
            sortByCreatedDate = "CreatedDate";
            sortByModifiedDate = "ModifiedDate";
            ascendingOrder = "Ascending";
            descendingOrder = "Descending";
            SQLQuery = "SQL";
            XPathQuery = "XPATH";
        }
        ArrayList<SelectItemOption> sortOptions = new ArrayList<SelectItemOption>();
        sortOptions.add(new SelectItemOption(sortByNodeName, (Object)"Alphabetic"));
        sortOptions.add(new SelectItemOption(sortByNodeType, (Object)"Type"));
        sortOptions.add(new SelectItemOption(sortByCreatedDate, (Object)"CreatedDate"));
        sortOptions.add(new SelectItemOption(sortByModifiedDate, (Object)"ModifiedDate"));
        ArrayList<SelectItemOption> orderOption = new ArrayList<SelectItemOption>();
        orderOption.add(new SelectItemOption(ascendingOrder, (Object)"Ascending"));
        orderOption.add(new SelectItemOption(descendingOrder, (Object)"Descending"));
        ArrayList<SelectItemOption> nodesPerPagesOptions = new ArrayList<SelectItemOption>();
        nodesPerPagesOptions.add(new SelectItemOption("5", (Object)"5"));
        nodesPerPagesOptions.add(new SelectItemOption("10", (Object)"10"));
        nodesPerPagesOptions.add(new SelectItemOption("15", (Object)"15"));
        nodesPerPagesOptions.add(new SelectItemOption("20", (Object)"20"));
        nodesPerPagesOptions.add(new SelectItemOption("30", (Object)"30"));
        nodesPerPagesOptions.add(new SelectItemOption("40", (Object)"40"));
        nodesPerPagesOptions.add(new SelectItemOption("50", (Object)"50"));
        ArrayList<SelectItemOption> queryOption = new ArrayList<SelectItemOption>();
        queryOption.add(new SelectItemOption(SQLQuery, (Object)"SQL"));
        queryOption.add(new SelectItemOption(XPathQuery, (Object)"XPATH"));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_ENABLESTRUCTURE, FIELD_ENABLESTRUCTURE, null));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_SHOWSIDEBAR, FIELD_SHOWSIDEBAR, null));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_SHOWNONDOCUMENT, FIELD_SHOWNONDOCUMENT, null));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_SHOWREFDOCUMENTS, FIELD_SHOWREFDOCUMENTS, null));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_SHOW_HIDDEN_NODE, FIELD_SHOW_HIDDEN_NODE, null));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_SHOW_ITEMS_BY_USER, FIELD_SHOW_ITEMS_BY_USER, null));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_ENABLE_DRAG_AND_DROP, FIELD_ENABLE_DRAG_AND_DROP, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_QUERY_TYPE, FIELD_QUERY_TYPE, queryOption));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_SHORTBY, FIELD_SHORTBY, sortOptions));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_ORDERBY, FIELD_ORDERBY, orderOption));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(NODES_PER_PAGE, NODES_PER_PAGE, nodesPerPagesOptions));
    }

    public boolean isAdvancePreferences() {
        return this.advancePreferences;
    }

    public void setAdvancePreferences(boolean adPreferences) {
        this.advancePreferences = adPreferences;
    }

    public void begin() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String b = context.getURLBuilder().createURL((Object)this, null, null);
        Writer writer = context.getWriter();
        writer.append("<form class=\"").append(this.getId()).append("\" id=\"").append(this.getId()).append("\" action=\"").append(b).append('\"');
        if (this.getSubmitAction() != null) {
            writer.append(" onsubmit=\"").append(this.getSubmitAction()).append("\"");
        }
        if (this.isMultipart()) {
            writer.append(" enctype=\"multipart/form-data\"");
        }
        writer.append(" method=\"post\">");
        writer.append("<div><input type=\"hidden\" name=\"").append("formOp").append("\" value=\"\"/>");
        writer.append("<input type=\"hidden\" name=\"").append("portal:csrf").append("\" value=\"");
        writer.append(CSRFTokenUtil.getToken((HttpServletRequest)Util.getRequest()));
        writer.append("\"/></div>");
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public void update(Preference pref) {
        this.getUICheckBoxInput(FIELD_ENABLESTRUCTURE).setChecked(pref.isJcrEnable());
        UICheckBoxInput showSideBar = this.getUICheckBoxInput(FIELD_SHOWSIDEBAR);
        showSideBar.setChecked(pref.isShowSideBar());
        showSideBar.setDisabled(!((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).isShowSideBar());
        this.getUICheckBoxInput(FIELD_SHOWNONDOCUMENT).setChecked(pref.isShowNonDocumentType());
        this.getUICheckBoxInput(FIELD_SHOWREFDOCUMENTS).setChecked(pref.isShowPreferenceDocuments());
        this.getUICheckBoxInput(FIELD_SHOW_HIDDEN_NODE).setChecked(pref.isShowHiddenNode());
        this.getUICheckBoxInput(FIELD_SHOW_ITEMS_BY_USER).setChecked(pref.isShowItemsByUser());
        this.getUICheckBoxInput(FIELD_ENABLE_DRAG_AND_DROP).setChecked(pref.isEnableDragAndDrop());
        this.getUIFormSelectBox(FIELD_SHORTBY).setValue(pref.getSortType());
        this.getUIFormSelectBox(FIELD_ORDERBY).setValue(pref.getOrder());
        this.getUIFormSelectBox(NODES_PER_PAGE).setValue(Integer.toString(pref.getNodesPerPage()));
        this.getUIFormSelectBox(FIELD_QUERY_TYPE).setValue(pref.getQueryType());
    }

    private Cookie createNewCookie(String cookieName, String cookieValue) {
        String userId = org.exoplatform.portal.webui.util.Util.getPortalRequestContext().getRemoteUser();
        cookieName = cookieName + userId;
        return new Cookie(cookieName, cookieValue);
    }

    private void savePreferenceInCookies() {
        HttpServletResponse response = org.exoplatform.portal.webui.util.Util.getPortalRequestContext().getResponse();
        if (this.getUICheckBoxInput(FIELD_ENABLESTRUCTURE).isChecked()) {
            response.addCookie(this.createNewCookie(FIELD_ENABLESTRUCTURE, "true"));
        } else {
            response.addCookie(this.createNewCookie(FIELD_ENABLESTRUCTURE, "false"));
        }
        if (this.getUICheckBoxInput(FIELD_SHOWSIDEBAR).isChecked()) {
            response.addCookie(this.createNewCookie(FIELD_SHOWSIDEBAR, "true"));
        } else {
            response.addCookie(this.createNewCookie(FIELD_SHOWSIDEBAR, "false"));
        }
        if (this.getUICheckBoxInput(FIELD_SHOWNONDOCUMENT).isChecked()) {
            response.addCookie(this.createNewCookie("showNonDocumentType", "true"));
        } else {
            response.addCookie(this.createNewCookie("showNonDocumentType", "false"));
        }
        if (this.getUICheckBoxInput(FIELD_SHOWREFDOCUMENTS).isChecked()) {
            response.addCookie(this.createNewCookie(FIELD_SHOWREFDOCUMENTS, "true"));
        } else {
            response.addCookie(this.createNewCookie(FIELD_SHOWREFDOCUMENTS, "false"));
        }
        if (this.getUICheckBoxInput(FIELD_SHOW_HIDDEN_NODE).isChecked()) {
            response.addCookie(this.createNewCookie("isShowHiddenNode", "true"));
        } else {
            response.addCookie(this.createNewCookie("isShowHiddenNode", "false"));
        }
        if (this.getUICheckBoxInput(FIELD_ENABLE_DRAG_AND_DROP).isChecked()) {
            response.addCookie(this.createNewCookie("EnableDragAndDrop", "true"));
        } else {
            response.addCookie(this.createNewCookie("EnableDragAndDrop", "false"));
        }
        response.addCookie(this.createNewCookie("preferenceQueryType", (String)this.getUIFormSelectBox(FIELD_QUERY_TYPE).getValue()));
        response.addCookie(this.createNewCookie("preferenceSortBy", (String)this.getUIFormSelectBox(FIELD_SHORTBY).getValue()));
        response.addCookie(this.createNewCookie("preferenceOrderBy", (String)this.getUIFormSelectBox(FIELD_ORDERBY).getValue()));
        response.addCookie(this.createNewCookie("nbPerPage", (String)this.getUIFormSelectBox(NODES_PER_PAGE).getValue()));
    }

    public static class AdvanceActionListener
    extends EventListener<UIPreferencesForm> {
        public void execute(Event<UIPreferencesForm> event) throws Exception {
            UIPreferencesForm uiPreferencesForm = (UIPreferencesForm)((Object)event.getSource());
            if (uiPreferencesForm.isAdvancePreferences()) {
                uiPreferencesForm.setAdvancePreferences(false);
            } else {
                uiPreferencesForm.setAdvancePreferences(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPreferencesForm.getParent());
        }
    }

    public static class BackActionListener
    extends EventListener<UIPreferencesForm> {
        public void execute(Event<UIPreferencesForm> event) throws Exception {
            UIPreferencesForm uiForm = (UIPreferencesForm)((Object)event.getSource());
            UIJCRExplorerPortlet explorerPorltet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)explorerPorltet.findFirstComponentOfType(UIJCRExplorer.class);
            ((UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class)).cancelPopupAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UIPreferencesForm> {
        public void execute(Event<UIPreferencesForm> event) throws Exception {
            UIPreferencesForm uiForm = (UIPreferencesForm)((Object)event.getSource());
            UIJCRExplorerPortlet explorerPorltet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)explorerPorltet.findFirstComponentOfType(UIJCRExplorer.class);
            Preference pref = uiExplorer.getPreference();
            pref.setJcrEnable(uiForm.getUICheckBoxInput(UIPreferencesForm.FIELD_ENABLESTRUCTURE).isChecked());
            pref.setShowSideBar(uiForm.getUICheckBoxInput(UIPreferencesForm.FIELD_SHOWSIDEBAR).isChecked());
            pref.setShowNonDocumentType(uiForm.getUICheckBoxInput(UIPreferencesForm.FIELD_SHOWNONDOCUMENT).isChecked());
            pref.setShowPreferenceDocuments(uiForm.getUICheckBoxInput(UIPreferencesForm.FIELD_SHOWREFDOCUMENTS).isChecked());
            pref.setShowHiddenNode(uiForm.getUICheckBoxInput(UIPreferencesForm.FIELD_SHOW_HIDDEN_NODE).isChecked());
            if (pref.isShowHiddenNode()) {
                uiExplorer.getAllItemFilterMap().add("Hidden");
            } else {
                uiExplorer.getAllItemFilterMap().remove("Hidden");
            }
            pref.setEnableDragAndDrop(uiForm.getUICheckBoxInput(UIPreferencesForm.FIELD_ENABLE_DRAG_AND_DROP).isChecked());
            pref.setSortType((String)uiForm.getUIFormSelectBox(UIPreferencesForm.FIELD_SHORTBY).getValue());
            pref.setQueryType((String)uiForm.getUIFormSelectBox(UIPreferencesForm.FIELD_QUERY_TYPE).getValue());
            pref.setOrder((String)uiForm.getUIFormSelectBox(UIPreferencesForm.FIELD_ORDERBY).getValue());
            pref.setNodesPerPage(Integer.parseInt((String)uiForm.getUIFormSelectBox(UIPreferencesForm.NODES_PER_PAGE).getValue()));
            uiForm.savePreferenceInCookies();
            uiExplorer.setPreferencesSaved(true);
            uiExplorer.refreshExplorer();
            explorerPorltet.setRenderedChild(UIJCRExplorer.class);
            uiExplorer.updateAjax(event);
        }
    }
}

