/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UICompareExactlyForm;
import org.exoplatform.ecm.webui.component.explorer.search.UIConstraintsForm;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchContainer;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.impl.util.XPathUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/search/UISimpleSearch.gtmpl", events={@EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={MoreConstraintsActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveConstraintActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={CompareExactlyActionListener.class}), @EventConfig(listeners={AddMetadataTypeActionListener.class}), @EventConfig(listeners={AddNodeTypeActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class})})
public class UISimpleSearch
extends UIForm {
    public static final String CONSTRAINTS_FORM = "ConstraintsForm";
    public static final String INPUT_SEARCH = "input";
    public static final String CONSTRAINTS = "constraints";
    public static final String NODE_PATH = "nodePath";
    public static final String FIRST_OPERATOR = "firstOperator";
    public static final String OR = "or";
    public static final String AND = "and";
    private static final Log LOG = ExoLogger.getLogger((String)UISimpleSearch.class.getName());
    private List<String> constraints_;
    private List<String> virtualConstraints_;
    private List<String> categoryPathList;
    private static final String ROOT_XPATH_QUERY = "//*";
    private static final String XPATH_QUERY = "/jcr:root$0//*";
    private static final String ROOT_SQL_QUERY = "SELECT * FROM nt:base WHERE jcr:path LIKE '/%' ";
    private static final String NT_RESOURCE_EXCLUDE = "AND ( not jcr:primaryType like 'nt:resource') ";
    private static final String LINK_REQUIREMENT = "AND ( (jcr:primaryType like 'exo:symlink' or jcr:primaryType like 'exo:taxonomyLink') ";
    private static final String SQL_QUERY = "SELECT * FROM nt:base WHERE jcr:path LIKE '$0/%' ";
    private String _OR;
    private String _AND;

    public List<String> getCategoryPathList() {
        return this.categoryPathList;
    }

    public void setCategoryPathList(List<String> categoryPathListItem) {
        this.categoryPathList = categoryPathListItem;
    }

    public UISimpleSearch() throws Exception {
        ArrayList<SelectItemOption> operators;
        block2: {
            this.constraints_ = new ArrayList<String>();
            this.virtualConstraints_ = new ArrayList<String>();
            this.categoryPathList = new ArrayList<String>();
            this._OR = "Or";
            this._AND = "And";
            this.addUIFormInput((UIFormInput)new UIFormInputInfo(NODE_PATH, NODE_PATH, null));
            this.addUIFormInput((UIFormInput)new UIFormStringInput(INPUT_SEARCH, INPUT_SEARCH, null));
            operators = new ArrayList<SelectItemOption>();
            RequestContext context = RequestContext.getCurrentInstance();
            try {
                ResourceBundle res = context.getApplicationResourceBundle();
                this._AND = res.getString("UIConstraintForm.label.and");
                this._OR = res.getString("UIConstraintForm.label.or");
            }
            catch (MissingResourceException e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)("Can not get resource bundle for UISimpleSearch label: " + e.getMessage()));
            }
        }
        operators.add(new SelectItemOption(this._AND, (Object)AND));
        operators.add(new SelectItemOption(this._OR, (Object)OR));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIRST_OPERATOR, FIRST_OPERATOR, operators));
        UIFormInputSetWithAction uiInputAct = new UIFormInputSetWithAction("moreConstraints");
        uiInputAct.addUIFormInput((UIFormInput)new UIFormInputInfo(CONSTRAINTS, CONSTRAINTS, null));
        this.addUIComponentInput((UIComponent)uiInputAct);
        UIConstraintsForm uiConstraintsForm = new UIConstraintsForm(CONSTRAINTS_FORM);
        uiConstraintsForm.setRendered(false);
        this.addChild((UIComponent)uiConstraintsForm);
        this.setActions(new String[]{"MoreConstraints", "Search", "Save", "Cancel"});
    }

    public List<String> getConstraints() {
        return this.constraints_;
    }

    public void updateAdvanceConstraint(String constraint, String operator, String virtualDateQuery) {
        if (constraint.length() > 0) {
            if (this.constraints_.size() == 0) {
                this.constraints_.add("(" + constraint + " )");
                if (virtualDateQuery != null) {
                    this.virtualConstraints_.add("(" + virtualDateQuery + " )");
                } else {
                    this.virtualConstraints_.add("(" + constraint + " )");
                }
            } else {
                this.constraints_.add(" " + operator.toLowerCase() + " (" + constraint + " ) ");
                if (virtualDateQuery != null) {
                    this.virtualConstraints_.add(" " + operator.toLowerCase() + " (" + virtualDateQuery + " ) ");
                } else {
                    this.virtualConstraints_.add(" " + operator.toLowerCase() + " (" + constraint + " ) ");
                }
            }
        }
        UIFormInputSetWithAction inputInfor = (UIFormInputSetWithAction)this.getChildById("moreConstraints");
        inputInfor.setIsDeleteOnly(true);
        inputInfor.setListInfoField(CONSTRAINTS, this.virtualConstraints_);
        String[] actionInfor = new String[]{"RemoveConstraint"};
        inputInfor.setActionInfo(CONSTRAINTS, actionInfor);
    }

    private String getQueryStatement() throws Exception {
        String escapedText;
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        StringBuilder statement = new StringBuilder(1024);
        String text = (String)this.getUIStringInput(INPUT_SEARCH).getValue();
        String string = escapedText = text == null ? null : Utils.escapeIllegalCharacterInQuery((String)text);
        if (text != null && this.constraints_.size() == 0) {
            if ("/".equals(currentNode.getPath())) {
                statement.append(ROOT_XPATH_QUERY);
            } else {
                statement.append(StringUtils.replace((String)XPATH_QUERY, (String)"$0", (String)currentNode.getPath()));
            }
            statement.append("[(jcr:contains(.,'").append(escapedText).append("'))]");
        } else if (this.constraints_.size() > 0) {
            if (text == null) {
                if ("/".equals(currentNode.getPath())) {
                    statement.append(ROOT_XPATH_QUERY).append("[(");
                } else {
                    statement.append(StringUtils.replace((String)XPATH_QUERY, (String)"$0", (String)currentNode.getPath())).append("[(");
                }
            } else {
                String operator = (String)this.getUIFormSelectBox(FIRST_OPERATOR).getValue();
                if ("/".equals(currentNode.getPath())) {
                    statement.append(ROOT_XPATH_QUERY);
                } else {
                    statement.append(StringUtils.replace((String)XPATH_QUERY, (String)"$0", (String)currentNode.getPath()));
                }
                statement.append("[(jcr:contains(.,'").append(escapedText.replaceAll("'", "''")).append("')) ").append(operator).append(" (");
            }
            for (String constraint : this.constraints_) {
                if (constraint.contains("exo:category")) continue;
                statement.append(constraint);
            }
            statement.append(")]");
        }
        return statement.toString();
    }

    private String getSQLStatement() throws Exception {
        String escapedText;
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        StringBuilder statement = new StringBuilder(1024);
        String text = (String)this.getUIStringInput(INPUT_SEARCH).getValue();
        String string = escapedText = text == null ? null : Utils.escapeIllegalCharacterInQuery((String)text);
        if (text != null && this.constraints_.size() == 0) {
            if ("/".equals(currentNode.getPath())) {
                statement.append(ROOT_SQL_QUERY);
            } else {
                statement.append(StringUtils.replace((String)SQL_QUERY, (String)"$0", (String)currentNode.getPath()));
            }
            statement.append(NT_RESOURCE_EXCLUDE);
            statement.append(LINK_REQUIREMENT).append(" OR ( CONTAINS(*,'").append(escapedText).append("') ) )");
        } else if (this.constraints_.size() > 0) {
            String constraintsStatement;
            StringBuilder tmpStatement = new StringBuilder();
            String operator = (String)this.getUIFormSelectBox(FIRST_OPERATOR).getValue();
            for (String constraint : this.constraints_) {
                if (constraint.contains("exo:category")) continue;
                tmpStatement.append(constraint);
            }
            String str = tmpStatement.toString().trim();
            if (str.toLowerCase().startsWith(OR)) {
                str = str.substring(OR.length());
            }
            if (str.toLowerCase().startsWith(AND)) {
                str = str.substring(AND.length());
            }
            String string2 = constraintsStatement = str.length() == 0 ? str : operator + " ( " + str + " ) ";
            if (text == null) {
                if ("/".equals(currentNode.getPath())) {
                    statement.append(ROOT_SQL_QUERY);
                } else {
                    statement.append(StringUtils.replace((String)SQL_QUERY, (String)"$0", (String)currentNode.getPath()));
                }
                statement.append(NT_RESOURCE_EXCLUDE);
                if (constraintsStatement.length() > 0) {
                    statement.append(constraintsStatement);
                }
            } else {
                if ("/".equals(currentNode.getPath())) {
                    statement.append(ROOT_SQL_QUERY);
                } else {
                    statement.append(StringUtils.replace((String)SQL_QUERY, (String)"$0", (String)currentNode.getPath()));
                }
                statement.append(NT_RESOURCE_EXCLUDE);
                statement.append(LINK_REQUIREMENT).append("OR ( CONTAINS(*,'").append(escapedText.replaceAll("'", "''")).append("') ");
                if (constraintsStatement.length() > 0) {
                    statement.append(constraintsStatement);
                }
                statement.append(" ) )");
            }
        }
        return statement.toString();
    }

    public static class AddCategoryActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UISearchContainer uiSearchContainer = (UISearchContainer)((UISimpleSearch)((Object)event.getSource())).getAncestorOfType(UISearchContainer.class);
            uiSearchContainer.initCategoryPopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSearchContainer);
        }
    }

    public static class CompareExactlyActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UIConstraintsForm uiConstraintForm = (UIConstraintsForm)((UISimpleSearch)((Object)event.getSource())).getChild(UIConstraintsForm.class);
            String property = (String)uiConstraintForm.getUIStringInput("property1").getValue();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiConstraintForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiConstraintForm.getAncestorOfType(UIApplication.class);
            if (property == null || property.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.properties-null", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiConstraintForm);
                return;
            }
            String currentPath = uiExplorer.getCurrentNode().getPath();
            StringBuffer statement = new StringBuffer("select * from nt:base where ");
            if (!currentPath.equals("/")) {
                statement.append("jcr:path like '").append(currentPath).append("/%' AND ");
            }
            property = XPathUtils.escapeIllegalXPathName((String)property);
            statement.append(property).append(" is not null");
            QueryManager queryManager = uiExplorer.getTargetSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(statement.toString(), "sql");
            QueryResult result = query.execute();
            if (result == null || result.getNodes().getSize() == 0L) {
                uiApp.addMessage(new ApplicationMessage("UICompareExactlyForm.msg.not-result-found", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiConstraintForm);
                return;
            }
            UISearchContainer uiContainer = (UISearchContainer)uiConstraintForm.getAncestorOfType(UISearchContainer.class);
            UICompareExactlyForm uiCompareExactlyForm = (UICompareExactlyForm)uiContainer.createUIComponent(UICompareExactlyForm.class, null, null);
            UIPopupContainer uiPopup = (UIPopupContainer)uiContainer.getChild(UIPopupContainer.class);
            ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId("ExactlyFormPopup");
            ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setShowMask(true);
            uiCompareExactlyForm.init(property, result);
            uiPopup.activate((UIComponent)uiCompareExactlyForm, 600, 500);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class AddNodeTypeActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UISearchContainer uiContainer = (UISearchContainer)((UISimpleSearch)((Object)event.getSource())).getAncestorOfType(UISearchContainer.class);
            uiContainer.initNodeTypePopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class AddMetadataTypeActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UISearchContainer uiContainer = (UISearchContainer)((UISimpleSearch)((Object)event.getSource())).getAncestorOfType(UISearchContainer.class);
            String type = event.getRequestContext().getRequestParameter("objectId");
            String popupId = "property1";
            if (type.equals("1")) {
                popupId = "property2";
            } else if (type.equals("2")) {
                popupId = "property3";
            }
            uiContainer.initMetadataPopup(popupId);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class AddActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            String value;
            String property;
            UIConstraintsForm uiForm = (UIConstraintsForm)((UISimpleSearch)((Object)event.getSource())).getChild(UIConstraintsForm.class);
            boolean isExactly = uiForm.getUICheckBoxInput("exactlyPro").isChecked();
            boolean isContain = uiForm.getUICheckBoxInput("containPro").isChecked();
            boolean isNotContain = uiForm.getUICheckBoxInput("notContainPro").isChecked();
            boolean isDateTime = uiForm.getUICheckBoxInput("datePro").isChecked();
            boolean isNodeType = uiForm.getUICheckBoxInput("nodetypePro").isChecked();
            boolean isCategory = uiForm.getUICheckBoxInput("categoryPro").isChecked();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (!(isExactly || isContain || isNotContain || isDateTime || isNodeType || isCategory)) {
                uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.must-choose-one", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                return;
            }
            if (isExactly) {
                property = (String)uiForm.getUIStringInput("property1").getValue();
                if (property == null || property.length() < 1) {
                    uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.properties-required", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    return;
                }
                value = (String)uiForm.getUIStringInput("containExactly").getValue();
                if (value == null || value.trim().length() < 0) {
                    uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.exactly-require", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    return;
                }
                uiForm.addConstraint(0);
            }
            if (isContain) {
                property = (String)uiForm.getUIStringInput("property2").getValue();
                if (property == null || property.length() < 1) {
                    uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.properties-required", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    return;
                }
                value = (String)uiForm.getUIStringInput("contain").getValue();
                if (value == null || value.trim().length() < 0) {
                    uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.value-required", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    return;
                }
                uiForm.addConstraint(1);
            }
            if (isNotContain) {
                property = (String)uiForm.getUIStringInput("property3").getValue();
                if (property == null || property.length() < 1) {
                    uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.properties-required", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    return;
                }
                value = (String)uiForm.getUIStringInput("notContain").getValue();
                if (value == null || value.trim().length() < 0) {
                    uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.value-required", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    return;
                }
                uiForm.addConstraint(2);
            }
            if (isDateTime) {
                Calendar afDate;
                String fromDate = (String)uiForm.getUIFormDateTimeInput("startTime").getValue();
                String toDate = (String)uiForm.getUIFormDateTimeInput("endTime").getValue();
                if (fromDate == null || fromDate.trim().length() == 0) {
                    uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.fromDate-required", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    return;
                }
                Calendar bfDate = uiForm.getUIFormDateTimeInput("startTime").getCalendar();
                if (toDate != null && toDate.trim().length() > 0 && bfDate.compareTo(afDate = uiForm.getUIFormDateTimeInput("endTime").getCalendar()) == 1) {
                    uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.date-invalid", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    return;
                }
                uiForm.addConstraint(3);
            }
            if (isNodeType) {
                property = (String)uiForm.getUIStringInput("docType").getValue();
                if (property == null || property.length() < 1) {
                    uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.properties-required", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    return;
                }
                uiForm.addConstraint(4);
            }
            if (isCategory) {
                String category = (String)uiForm.getUIStringInput("categoryType").getValue();
                if (category == null || category.length() < 1) {
                    uiApp.addMessage(new ApplicationMessage("UIConstraintsForm.msg.properties-required", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    return;
                }
                uiForm.addConstraint(5);
            }
            uiForm.resetConstraintForm();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class MoreConstraintsActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UISimpleSearch uiSimpleSearch = (UISimpleSearch)((Object)event.getSource());
            UIConstraintsForm uiConstraintsForm = (UIConstraintsForm)uiSimpleSearch.getChild(UIConstraintsForm.class);
            if (uiConstraintsForm.isRendered()) {
                uiConstraintsForm.setRendered(false);
            } else {
                uiConstraintsForm.setRendered(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSimpleSearch);
        }
    }

    public static class SearchActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UISimpleSearch uiSimpleSearch = (UISimpleSearch)((Object)event.getSource());
            String text = (String)uiSimpleSearch.getUIStringInput(UISimpleSearch.INPUT_SEARCH).getValue();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSimpleSearch.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            UIECMSearch uiECMSearch = (UIECMSearch)uiSimpleSearch.getAncestorOfType(UIECMSearch.class);
            UISearchResult uiSearchResult = (UISearchResult)uiECMSearch.getChild(UISearchResult.class);
            UIApplication uiApp = (UIApplication)uiSimpleSearch.getAncestorOfType(UIApplication.class);
            if (text == null && uiSimpleSearch.constraints_.size() == 0) {
                uiApp.addMessage(new ApplicationMessage("UISimpleSearch.msg.value-null", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSimpleSearch);
                return;
            }
            uiSearchResult.setCategoryPathList(uiSimpleSearch.getCategoryPathList());
            Preference pref = uiExplorer.getPreference();
            String queryType = pref.getQueryType();
            String statement = queryType.equals("XPATH") ? uiSimpleSearch.getQueryStatement() + " order by @exo:dateCreated descending" : uiSimpleSearch.getSQLStatement() + " order by exo:dateCreated DESC";
            long startTime = System.currentTimeMillis();
            try {
                uiSearchResult.setQuery(statement, currentNode.getSession().getWorkspace().getName(), queryType.equals("XPATH") ? "xpath" : "sql", IdentityConstants.SYSTEM.equals(currentNode.getSession().getUserID()), text);
                uiSearchResult.updateGrid();
            }
            catch (RepositoryException reEx) {
                uiApp.addMessage(new ApplicationMessage("UISimpleSearch.msg.inputSearch-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSimpleSearch);
                return;
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)e);
                }
                uiApp.addMessage(new ApplicationMessage("UISimpleSearch.msg.query-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSimpleSearch);
                return;
            }
            long time = System.currentTimeMillis() - startTime;
            uiSearchResult.setSearchTime(time);
            uiECMSearch.setSelectedTab(uiSearchResult.getId());
            uiSimpleSearch.getUIFormInputInfo(UISimpleSearch.NODE_PATH).setValue((Object)currentNode.getPath());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiECMSearch);
        }
    }

    public static class RemoveConstraintActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UISimpleSearch uiSimpleSearch = (UISimpleSearch)((Object)event.getSource());
            int intIndex = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiSimpleSearch.constraints_.remove(intIndex);
            uiSimpleSearch.virtualConstraints_.remove(intIndex);
            if (uiSimpleSearch.categoryPathList.size() > intIndex) {
                uiSimpleSearch.categoryPathList.remove(intIndex);
            }
            if (uiSimpleSearch.constraints_.size() > 0 && intIndex == 0) {
                String newFirstConstraint = null;
                String newFirstVirtualConstraint = null;
                if (((String)uiSimpleSearch.constraints_.get(0)).trim().startsWith(UISimpleSearch.OR)) {
                    newFirstConstraint = ((String)uiSimpleSearch.constraints_.get(0)).substring(3, ((String)uiSimpleSearch.constraints_.get(0)).length());
                    newFirstVirtualConstraint = ((String)uiSimpleSearch.virtualConstraints_.get(0)).substring(3, ((String)uiSimpleSearch.virtualConstraints_.get(0)).length());
                    uiSimpleSearch.constraints_.set(0, newFirstConstraint);
                    uiSimpleSearch.virtualConstraints_.set(0, newFirstVirtualConstraint);
                } else if (((String)uiSimpleSearch.constraints_.get(0)).trim().startsWith(UISimpleSearch.AND)) {
                    newFirstConstraint = ((String)uiSimpleSearch.constraints_.get(0)).substring(4, ((String)uiSimpleSearch.constraints_.get(0)).length());
                    newFirstVirtualConstraint = ((String)uiSimpleSearch.virtualConstraints_.get(0)).substring(4, ((String)uiSimpleSearch.virtualConstraints_.get(0)).length());
                    uiSimpleSearch.constraints_.set(0, newFirstConstraint);
                    uiSimpleSearch.virtualConstraints_.set(0, newFirstVirtualConstraint);
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSimpleSearch.getParent());
        }
    }

    public static class CancelActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            ((UIJCRExplorer)((UISimpleSearch)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class)).cancelAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UISimpleSearch uiSimpleSearch = (UISimpleSearch)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiSimpleSearch.getAncestorOfType(UIApplication.class);
            String text = (String)uiSimpleSearch.getUIStringInput(UISimpleSearch.INPUT_SEARCH).getValue();
            if (text == null && uiSimpleSearch.constraints_.size() == 0) {
                uiApp.addMessage(new ApplicationMessage("UISimpleSearch.msg.value-save-null", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSimpleSearch);
                return;
            }
            UISearchContainer uiSearchContainer = (UISearchContainer)uiSimpleSearch.getParent();
            uiSearchContainer.initSaveQueryPopup(uiSimpleSearch.getQueryStatement(), true, "xpath");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSearchContainer);
        }
    }
}

