/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.watch.impl;

import groovy.text.GStringTemplateEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.portlet.PortletRequest;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.NotificationCompletionService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.watch.WatchDocumentService;
import org.exoplatform.services.cms.watch.impl.MessageConfig;
import org.exoplatform.services.cms.watch.impl.WatchDocumentServiceImpl;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.observation.EventImpl;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

public class EmailNotifyListener
implements EventListener {
    private NodeLocation observedNode_;
    private NotificationCompletionService notificationCompletionService;
    public static final String EMAIL_WATCHERS_PROP = "exo:emailWatcher";
    private static final String SITE_EXPLORER = "siteExplorer";
    private static final String PATH_PARAM = "path";
    private static final String USER_ID = "${userId}";
    private static final Log LOG = ExoLogger.getLogger((String)EmailNotifyListener.class.getName());
    private static final String EXO_LANGUAGE_PROPERTY = "exo:language";
    private static final String JCR_DATA_PROPERTY = "jcr:content/jcr:data";
    private static final String DC_SOURCE_PROPERTY = "jcr:content/dc:source";
    private static final String DC_DESCRIPTION_PROPERTY = "jcr:content/dc:description";
    private static final String DC_TITLE_PROPERTY = "jcr:content/dc:title";
    private static final String DC_CREATOR_PROPERTY = "jcr:content/dc:creator";

    public EmailNotifyListener(Node oNode) {
        this.observedNode_ = NodeLocation.getNodeLocationByNode(oNode);
        this.notificationCompletionService = (NotificationCompletionService)CommonsUtils.getService(NotificationCompletionService.class);
    }

    public void onEvent(EventIterator arg0) {
        List entities = ((EntityCollection)arg0).getList();
        final MailService mailService = WCMCoreUtils.getService(MailService.class);
        WatchDocumentServiceImpl watchService = (WatchDocumentServiceImpl)WCMCoreUtils.getService(WatchDocumentService.class);
        MessageConfig messageConfig = watchService.getMessageConfig();
        Callable<Boolean> task = null;
        for (EventImpl entity : entities) {
            if (!entity.getPath().contains(EXO_LANGUAGE_PROPERTY) && !entity.getPath().contains(JCR_DATA_PROPERTY) && !entity.getPath().contains(DC_SOURCE_PROPERTY) && !entity.getPath().contains(DC_DESCRIPTION_PROPERTY) && !entity.getPath().contains(DC_TITLE_PROPERTY) && !entity.getPath().contains(DC_CREATOR_PROPERTY)) continue;
            List<String> emailList = this.getEmailList(NodeLocation.getNodeByLocation(this.observedNode_));
            for (String receiver : emailList) {
                try {
                    final Message message = this.createMessage(receiver, messageConfig);
                    task = new Callable<Boolean>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Boolean call() throws Exception {
                            PortalContainer container = PortalContainer.getInstance();
                            ExoContainerContext.setCurrentContainer((ExoContainer)container);
                            RequestLifeCycle.begin((ExoContainer)container);
                            try {
                                mailService.sendMessage(message);
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Failed to send a message", (Throwable)e);
                                Boolean bl = false;
                                return bl;
                            }
                            finally {
                                RequestLifeCycle.end();
                            }
                            return true;
                        }
                    };
                    this.notificationCompletionService.addTask((Callable)task);
                }
                catch (Exception e) {
                    LOG.error((Object)("Unexpected error while sending notification email to " + receiver));
                }
            }
        }
    }

    private Message createMessage(String receiver, MessageConfig messageConfig) throws Exception {
        String companyName = NotificationPluginUtils.getBrandingPortalName();
        Message message = new Message();
        message.setFrom(companyName + "<" + MailUtils.getSenderEmail() + ">");
        message.setTo(receiver);
        message.setSubject(messageConfig.getSubject());
        GStringTemplateEngine engine = new GStringTemplateEngine();
        HashMap<String, String> binding = new HashMap<String, String>();
        Query query = new Query();
        query.setEmail(receiver);
        binding.put("user_name", ((User[])WCMCoreUtils.getService(OrganizationService.class).getUserHandler().findUsersByQuery(query).load(0, 1))[0].getFullName());
        Node node = NodeLocation.getNodeByLocation(this.observedNode_);
        binding.put("doc_title", Utils.getTitle(node));
        binding.put("doc_name", node.getName());
        binding.put("doc_url", this.getViewableLink());
        message.setBody(engine.createTemplate(messageConfig.getContent()).make(binding).toString());
        message.setMimeType(messageConfig.getMimeType());
        return message;
    }

    private String getViewableLink() throws Exception {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        NodeURL nodeURL = (NodeURL)pContext.createURL(NodeURL.TYPE);
        String nodePath = NodeLocation.getNodeByLocation(this.observedNode_).getPath();
        ManageDriveService manageDriveService = WCMCoreUtils.getService(ManageDriveService.class);
        List<DriveData> driveList = manageDriveService.getDriveByUserRoles(pContext.getRemoteUser(), this.getMemberships());
        DriveData drive = this.getDrive(driveList, WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName(), nodePath);
        String driverName = drive.getName();
        String nodePathInDrive = "/".equals(drive.getHomePath()) ? nodePath : nodePath.substring(drive.getHomePath().length());
        UserNode siteExNode = this.getUserNodeByURI(SITE_EXPLORER);
        nodeURL.setNode(siteExNode);
        nodeURL.setQueryParameterValue(PATH_PARAM, "/" + driverName + nodePathInDrive);
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        return baseURI + nodeURL.toString();
    }

    private DriveData getDrive(List<DriveData> lstDrive, String workspace, String nodePath) throws RepositoryException {
        NodeHierarchyCreator nhc = WCMCoreUtils.getService(NodeHierarchyCreator.class);
        String userName = ConversationState.getCurrent().getIdentity().getUserId();
        String userNodePath = null;
        try {
            userNodePath = nhc.getUserNode(WCMCoreUtils.getSystemSessionProvider(), userName).getPath();
        }
        catch (Exception e) {
            userNodePath = null;
        }
        DriveData driveData = null;
        for (DriveData drive : lstDrive) {
            String driveHomePath = drive.getHomePath();
            int idx = driveHomePath.indexOf(USER_ID);
            if (idx >= 0 && userNodePath != null) {
                driveHomePath = userNodePath + driveHomePath.substring(idx + USER_ID.length());
            }
            if (!workspace.equals(drive.getWorkspace()) || !nodePath.startsWith(driveHomePath)) continue;
            driveData = drive;
            break;
        }
        return driveData;
    }

    private UserNode getUserNodeByURI(String uri) {
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        List allNavs = userPortal.getNavigations();
        for (UserNavigation nav : allNavs) {
            UserNode userNode;
            if (!nav.getKey().getType().equals((Object)SiteType.GROUP) || (userNode = userPortal.resolvePath(nav, null, uri)) == null) continue;
            return userNode;
        }
        return null;
    }

    public List<String> getMemberships() {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection<MembershipEntry> memberships = this.getUserMembershipsFromIdentityRegistry(userId);
        if (memberships != null) {
            for (MembershipEntry membership : memberships) {
                String role = membership.getMembershipType() + ":" + membership.getGroup();
                userMemberships.add(role);
            }
        }
        return userMemberships;
    }

    private Collection<MembershipEntry> getUserMembershipsFromIdentityRegistry(String authenticatedUser) {
        IdentityRegistry identityRegistry = WCMCoreUtils.getService(IdentityRegistry.class);
        Identity currentUserIdentity = identityRegistry.getIdentity(authenticatedUser);
        return currentUserIdentity.getMemberships();
    }

    private List<String> getEmailList(Node observedNode) {
        ArrayList<String> emailList;
        block4: {
            emailList = new ArrayList<String>();
            OrganizationService orgService = WCMCoreUtils.getService(OrganizationService.class);
            try {
                if (observedNode.hasProperty(EMAIL_WATCHERS_PROP)) {
                    Value[] watcherNames;
                    for (Value value : watcherNames = observedNode.getProperty(EMAIL_WATCHERS_PROP).getValues()) {
                        String userName = value.getString();
                        User user = orgService.getUserHandler().findUserByName(userName);
                        if (user == null) continue;
                        emailList.add(user.getEmail());
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        return emailList;
    }
}

