/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.ElasticSearchServiceConnector;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.search.base.EcmsSearchResult;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PageElasticUnifiedSearchServiceConnector
extends ElasticSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(PageElasticUnifiedSearchServiceConnector.class);

    public PageElasticUnifiedSearchServiceConnector(InitParams initParams, ElasticSearchingClient client) {
        super(initParams, client);
    }

    protected String getSourceFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("name");
        fields.add("pageTitle");
        fields.add("descriptions");
        fields.add("seo");
        fields.add("url");
        fields.add("siteName");
        fields.add("siteType");
        fields.add("pageRef");
        ArrayList<String> sourceFields = new ArrayList<String>();
        for (String sourceField : fields) {
            sourceFields.add("\"" + sourceField + "\"");
        }
        return StringUtils.join(sourceFields, (String)",");
    }

    protected String getSitesFilter(Collection<String> sitesCollection) {
        return null;
    }

    protected Collection<SearchResult> buildResult(String jsonResponse, SearchContext context) {
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        String lang = context.getParamValue(SearchContext.RouterParams.LANG.create());
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            String descriptions;
            JSONObject hitSource = (JSONObject)((JSONObject)jsonHit).get((Object)"_source");
            String title = this.getTitleFromJsonResult(hitSource);
            String url = this.getUrlFromJsonResult(hitSource, context);
            Long lastUpdatedDate = (Long)hitSource.get((Object)"lastUpdatedDate");
            if (lastUpdatedDate == null) {
                lastUpdatedDate = new Date().getTime();
            }
            Double score = (Double)((JSONObject)jsonHit).get((Object)"_score");
            String detail = "";
            if (hitSource.containsKey((Object)"descriptions") && StringUtils.isNotEmpty((String)(descriptions = (String)hitSource.get((Object)"descriptions")))) {
                try {
                    Map desc = (Map)parser.parse(descriptions);
                    if (desc.containsKey(lang)) {
                        detail = (String)desc.get(lang);
                    }
                }
                catch (ParseException ex) {
                    LOG.error((Object)ex);
                }
            }
            EcmsSearchResult result = new EcmsSearchResult(url, url, title, "", detail, "/eXoSkin/skin/images/system/unified-search/page.png", lastUpdatedDate, score.longValue(), "FileDefault", "");
            results.add(result);
        }
        return results;
    }

    protected String getUrlFromJsonResult(JSONObject hitSource, SearchContext context) {
        String uri = (String)hitSource.get((Object)"url");
        String handler = WCMCoreUtils.getPortalName();
        String siteType = (String)hitSource.get((Object)"siteType");
        String siteName = (String)hitSource.get((Object)"siteName");
        String url = "#";
        try {
            url = "/" + handler + context.handler(handler).lang("").siteType(siteType).siteName(siteName).path(uri).renderLink();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
        return url;
    }
}

