/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.dlp;

import javax.jcr.Node;
import org.exoplatform.commons.dlp.connector.DlpServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class FileDlpConnector
extends DlpServiceConnector {
    private static final Log LOGGER = ExoLogger.getExoLogger(FileDlpConnector.class);
    public static final String TYPE = "file";
    private static final String COLLABORATION_WS = "collaboration";
    private static final String DLP_KEYWORDS_PARAM = "dlp.keywords";
    private TrashService trashService;
    private RepositoryService repositoryService;
    private String dlpKeywords;

    public FileDlpConnector(InitParams initParams, TrashService trashService, RepositoryService repositoryService) {
        super(initParams);
        ValueParam dlpKeywordsParam = initParams.getValueParam(DLP_KEYWORDS_PARAM);
        this.dlpKeywords = dlpKeywordsParam.getValue();
        this.trashService = trashService;
        this.repositoryService = repositoryService;
    }

    public boolean processItem(String entityId) {
        if (!this.isIndexedByEs()) {
            return false;
        }
        if (this.matchKeyword()) {
            this.treatItem(entityId);
        }
        return true;
    }

    private boolean isIndexedByEs() {
        return true;
    }

    private boolean matchKeyword() {
        return this.dlpKeywords != null && !this.dlpKeywords.isEmpty();
    }

    private void treatItem(String entityId) {
        ExtendedSession session = null;
        try {
            long startTime = System.currentTimeMillis();
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            Node node = session.getNodeByIdentifier(entityId);
            if (!this.trashService.isInTrash(node)) {
                String fileName = node.getName();
                this.trashService.moveToTrash(node, WCMCoreUtils.getSystemSessionProvider());
                long endTime = System.currentTimeMillis();
                long totalTime = endTime - startTime;
                LOGGER.info("service={} operation={} parameters=\"fileName:{}\" status=ok duration_ms={}", new Object[]{"dlp", "dlpPositiveDetection", fileName, totalTime});
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while treating file dlp connector item", (Throwable)e);
        }
    }
}

