/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ChunkedUploadResponseHandler;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.HttpMethod;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.IHttpRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.IGraphServiceClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ChunkedUploadResult;

public class ChunkedUploadRequest {
    private static final String CONTENT_RANGE_HEADER_NAME = "Content-Range";
    private static final String CONTENT_RANGE_FORMAT = "bytes %1$d-%2$d/%3$d";
    private static final int RETRY_DELAY = 2000;
    private final byte[] data;
    private final BaseRequest baseRequest;
    private final int maxRetry;
    private int retryCount;

    public ChunkedUploadRequest(String requestUrl, IGraphServiceClient client, List<? extends Option> options, byte[] chunk, int chunkSize, int maxRetry, long beginIndex, long totalLength) {
        this.data = new byte[chunkSize];
        System.arraycopy(chunk, 0, this.data, 0, chunkSize);
        this.retryCount = 0;
        this.maxRetry = maxRetry;
        this.baseRequest = new BaseRequest(requestUrl, client, options, ChunkedUploadResult.class){};
        this.baseRequest.setHttpMethod(HttpMethod.PUT);
        this.baseRequest.addHeader(CONTENT_RANGE_HEADER_NAME, String.format(CONTENT_RANGE_FORMAT, beginIndex, beginIndex + (long)chunkSize - 1L, totalLength));
    }

    public <UploadType> ChunkedUploadResult<UploadType> upload(ChunkedUploadResponseHandler<UploadType> responseHandler) {
        while (this.retryCount < this.maxRetry) {
            try {
                Thread.sleep(2000 * this.retryCount * this.retryCount);
            }
            catch (InterruptedException e) {
                throw new ClientException("Exception while waiting to retry file upload.", e);
            }
            ChunkedUploadResult result = null;
            try {
                result = this.baseRequest.getClient().getHttpProvider().send((IHttpRequest)this.baseRequest, ChunkedUploadResult.class, this.data, responseHandler);
            }
            catch (ClientException e) {
                throw new ClientException("Request failed with error, retry if necessary.", e);
            }
            if (result != null && result.chunkCompleted()) {
                return result;
            }
            ++this.retryCount;
        }
        return new ChunkedUploadResult(new ClientException("Upload session failed too many times.", null));
    }
}

