/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.SharedDriveItem;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISharedDriveItemCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISharedDriveItemCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SharedDriveItemCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SharedDriveItemCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SharedDriveItemCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SharedDriveItemRequestBuilder;

public class SharedDriveItemCollectionRequest
extends BaseCollectionRequest<SharedDriveItemCollectionResponse, ISharedDriveItemCollectionPage>
implements ISharedDriveItemCollectionRequest {
    public SharedDriveItemCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SharedDriveItemCollectionResponse.class, ISharedDriveItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISharedDriveItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SharedDriveItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISharedDriveItemCollectionPage get() throws ClientException {
        SharedDriveItemCollectionResponse response = (SharedDriveItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SharedDriveItem newSharedDriveItem, ICallback<SharedDriveItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SharedDriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSharedDriveItem, callback);
    }

    @Override
    public SharedDriveItem post(SharedDriveItem newSharedDriveItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SharedDriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSharedDriveItem);
    }

    @Override
    public ISharedDriveItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISharedDriveItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISharedDriveItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ISharedDriveItemCollectionPage buildFromResponse(SharedDriveItemCollectionResponse response) {
        SharedDriveItemCollectionRequestBuilder builder = response.nextLink != null ? new SharedDriveItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SharedDriveItemCollectionPage page = new SharedDriveItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

