/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.core;

import java.util.Arrays;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.ecm.webui.core.UIPagingGridDecorator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/ecm/webui/core/UIPageIterator.gtmpl", events={@EventConfig(listeners={ShowPageActionListener.class}), @EventConfig(listeners={ChangeMaxSizePageActionListener.class})})
@Serialized
public class UIECMPageIterator
extends UIPageIterator {
    private int itemsPerPage_ = 0;
    private int totalItems = 0;
    private boolean useMaxSizeSetting_ = false;
    public static final int[] MAX_ITEMS_PER_PAGE = new int[]{5, 10, 15, 20, 30, 60, 100};
    private boolean justPaginated_ = false;

    public boolean isJustPaginated() {
        return this.justPaginated_;
    }

    public void setJustPaginated(boolean value) {
        this.justPaginated_ = value;
    }

    public int[] getMaxItemPerPageList() {
        int pageSize = this.getItemsPerPage();
        if (this.isPageSizeInList(pageSize)) {
            return MAX_ITEMS_PER_PAGE;
        }
        int length = MAX_ITEMS_PER_PAGE.length + 1;
        int[] pageSizeList = new int[length];
        System.arraycopy(MAX_ITEMS_PER_PAGE, 0, pageSizeList, 0, MAX_ITEMS_PER_PAGE.length);
        pageSizeList[pageSizeList.length - 1] = pageSize;
        Arrays.sort(pageSizeList);
        return pageSizeList;
    }

    public int getItemsPerPage() {
        if (this.itemsPerPage_ <= 0) {
            this.itemsPerPage_ = 10;
        }
        return this.itemsPerPage_;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage_ = itemsPerPage;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(int totalItems) {
        this.totalItems = totalItems;
    }

    public void setUseMaxSizeSetting(boolean useMaxSizeSetting_) {
        this.useMaxSizeSetting_ = useMaxSizeSetting_;
    }

    public boolean isUseMaxSizeSetting() {
        return this.useMaxSizeSetting_;
    }

    public void setPageList(PageList pageList) {
        super.setPageList(pageList);
        this.itemsPerPage_ = pageList.getPageSize();
    }

    private boolean isPageSizeInList(int pageSize) {
        for (int size : MAX_ITEMS_PER_PAGE) {
            if (size != pageSize) continue;
            return true;
        }
        return false;
    }

    public static class ChangeMaxSizePageActionListener
    extends EventListener<UIECMPageIterator> {
        public void execute(Event<UIECMPageIterator> event) throws Exception {
            UIECMPageIterator uiPageIterator = (UIECMPageIterator)((Object)event.getSource());
            int itemsPerPage = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiPageIterator.setItemsPerPage(itemsPerPage);
            UIComponent parent = uiPageIterator.getParent();
            if (parent == null) {
                return;
            }
            if (parent instanceof UIPagingGrid) {
                ((UIPagingGrid)parent).refresh(uiPageIterator.getCurrentPage());
            } else if (parent instanceof UIPagingGridDecorator) {
                ((UIPagingGridDecorator)parent).refresh(uiPageIterator.getCurrentPage());
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(parent);
        }
    }

    public static class ShowPageActionListener
    extends EventListener<UIECMPageIterator> {
        public void execute(Event<UIECMPageIterator> event) throws Exception {
            UIECMPageIterator uiPageIterator = (UIECMPageIterator)((Object)event.getSource());
            int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiPageIterator.setCurrentPage(page);
            uiPageIterator.setJustPaginated(true);
            UIComponent parent = uiPageIterator.getParent();
            if (parent == null) {
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(parent);
            parent.broadcast(event, event.getExecutionPhase());
        }
    }
}

