/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.HasRemovePermissionFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsAbleToRestoreFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UISelectRestorePath;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={RestoreFromTrashActionListener.class}, csrfCheck=false)})
public class RestoreFromTrashManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsInTrashFilter(), new IsNotLockedFilter(), new IsCheckedOutFilter(), new HasRemovePermissionFilter(), new IsAbleToRestoreFilter(), new IsNotTrashHomeNodeFilter()});
    private static final Log LOG = ExoLogger.getLogger((String)RestoreFromTrashManageComponent.class.getName());

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class RestoreFromTrashActionListener
    extends UIWorkingAreaActionListener<RestoreFromTrashManageComponent> {
        private String itemName = "";
        private int numberItemsRestored = 0;

        public void restoreFromTrashManage(Event<RestoreFromTrashManageComponent> event) throws Exception {
            this.numberItemsRestored = 0;
            String srcPath = event.getRequestContext().getRequestParameter("objectId");
            if (srcPath.indexOf(59) > -1) {
                this.multiRestoreFromTrash(srcPath.split(";"), event);
            } else {
                this.restoreFromTrash(srcPath, event);
            }
            RequestContext context = RequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            String restoreNotice = "";
            if (!srcPath.contains(";") && this.numberItemsRestored == 1) {
                restoreNotice = "UIWorkingArea.msg.feedback-restore";
                restoreNotice = res.getString(restoreNotice);
                restoreNotice = restoreNotice.replace("{0}", this.itemName);
            } else if (srcPath.indexOf(59) > -1 && this.numberItemsRestored >= 1) {
                restoreNotice = "UIWorkingArea.msg.feedback-restore-multi";
                restoreNotice = res.getString(restoreNotice);
                restoreNotice = restoreNotice.replace("{0}", String.valueOf(this.numberItemsRestored));
            }
            restoreNotice = restoreNotice.replace("\"", "'");
            restoreNotice = StringEscapeUtils.escapeHtml((String)restoreNotice);
            if (restoreNotice.length() > 0) {
                UIWorkingArea uiWorkingArea = (UIWorkingArea)((RestoreFromTrashManageComponent)((Object)event.getSource())).getParent();
                uiWorkingArea.setWCMNotice(restoreNotice);
            }
        }

        private void multiRestoreFromTrash(String[] paths, Event<RestoreFromTrashManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((RestoreFromTrashManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            Arrays.sort(paths, Collections.reverseOrder());
            ArrayList<String> newPaths = new ArrayList<String>();
            for (int i = 0; i < paths.length; ++i) {
                String srcPath;
                String origialPath = srcPath = paths[i];
                Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
                }
                String wsName = matcher.group(1);
                srcPath = matcher.group(2);
                try {
                    Session session = uiExplorer.getSessionByWorkspace(wsName);
                    Node node = uiExplorer.getNodeByPath(srcPath, session, false);
                    if (Utils.targetNodeAndLinkInTrash((Node)node)) continue;
                    newPaths.add(origialPath);
                    continue;
                }
                catch (PathNotFoundException path) {
                    return;
                }
            }
            for (String path : newPaths) {
                if (!this.acceptForMultiNode(event, path)) continue;
                this.restoreFromTrash(path, event);
            }
        }

        private void restoreFromTrash(String srcPath, Event<RestoreFromTrashManageComponent> event) throws Exception {
            Node node;
            UIWorkingArea uiWorkingArea = (UIWorkingArea)((RestoreFromTrashManageComponent)((Object)event.getSource())).getParent();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiWorkingArea.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiWorkingArea.getAncestorOfType(UIApplication.class);
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
            if (!matcher.find()) {
                throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
            }
            String wsName = matcher.group(1);
            srcPath = matcher.group(2);
            Session session = uiExplorer.getSessionByWorkspace(wsName);
            try {
                node = uiExplorer.getNodeByPath(srcPath, session, false);
                if (Utils.targetNodeAndLinkInTrash((Node)node)) {
                    return;
                }
                srcPath = node.getPath();
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                return;
            }
            this.confirmToRestore(node, srcPath, event);
        }

        private void confirmToRestore(Node node, String srcPath, Event<RestoreFromTrashManageComponent> event) throws Exception {
            UIWorkingArea uiWorkingArea = (UIWorkingArea)((RestoreFromTrashManageComponent)((Object)event.getSource())).getParent();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiWorkingArea.getAncestorOfType(UIJCRExplorer.class);
            this.itemName = Utils.getTitle((Node)node);
            String restorePath = node.getProperty("exo:restorePath").getString();
            String restoreWs = node.getProperty("exo:restoreWorkspace").getString();
            Session session = uiExplorer.getSessionByWorkspace(restoreWs);
            NodeFinder nodeFinder = (NodeFinder)uiExplorer.getApplicationComponent(NodeFinder.class);
            try {
                nodeFinder.getItem(session, restorePath);
            }
            catch (PathNotFoundException e) {
                this.doRestore(srcPath, node, event);
                ++this.numberItemsRestored;
                return;
            }
            this.doRestore(srcPath, node, event);
            ++this.numberItemsRestored;
        }

        public void doRestore(String srcPath, Node node, Event<? extends UIComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getParent();
            TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
            UIApplication uiApp = (UIApplication)((UIComponent)event.getSource()).getAncestorOfType(UIApplication.class);
            try {
                uiExplorer.addLockToken(node);
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            SessionProvider sessionProvider = null;
            try {
                PortletPreferences portletPrefs = uiExplorer.getPortletPreferences();
                String repository = uiExplorer.getRepositoryName();
                String trashWorkspace = portletPrefs.getValue("trashWorkspace", "");
                String trashHomeNodePath = portletPrefs.getValue("trashHomeNodePath", "");
                sessionProvider = WCMCoreUtils.getSystemSessionProvider();
                RepositoryService repositoryService = (RepositoryService)uiExplorer.getApplicationComponent(RepositoryService.class);
                ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
                Session trashSession = sessionProvider.getSession(trashWorkspace, manageableRepository);
                Node trashHomeNode = (Node)trashSession.getItem(trashHomeNodePath);
                try {
                    trashService.restoreFromTrash(srcPath, sessionProvider);
                    LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
                    List symlinks = linkManager.getAllLinks(node, "exo:symlink");
                    for (Node symlink : symlinks) {
                        String realPath = symlink.getPath();
                        if (!trashHomeNode.getSession().itemExists(realPath)) {
                            realPath = trashHomeNodePath + "/" + symlink.getName();
                        }
                        trashService.restoreFromTrash(realPath, sessionProvider);
                    }
                    uiExplorer.updateAjax(event);
                }
                catch (PathNotFoundException e) {
                    UIPopupContainer uiPopupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
                    UISelectRestorePath uiSelectRestorePath = (UISelectRestorePath)uiWorkingArea.createUIComponent(UISelectRestorePath.class, null, null);
                    uiSelectRestorePath.setTrashHomeNode(trashHomeNode);
                    uiSelectRestorePath.setSrcPath(srcPath);
                    uiSelectRestorePath.setRepository(repository);
                    uiPopupContainer.activate((UIComponent)uiSelectRestorePath, 600, 300);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
                }
            }
            catch (PathNotFoundException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Path not found! Maybe, it was removed or path changed, can't restore node :" + node.getPath()));
                }
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                uiExplorer.updateAjax(event);
            }
            catch (LockException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("node is locked, can't restore node :" + node.getPath()));
                }
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                uiExplorer.updateAjax(event);
            }
            catch (VersionException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("node is checked in, can't restore node:" + node.getPath()));
                }
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                uiExplorer.updateAjax(event);
            }
            catch (AccessDeniedException | ConstraintViolationException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("access denied, can't restore of node:" + node.getPath()));
                }
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                uiExplorer.updateAjax(event);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"an unexpected error occurs", (Throwable)e);
                }
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                uiExplorer.updateAjax(event);
            }
        }

        public void processEvent(Event<RestoreFromTrashManageComponent> event) throws Exception {
            this.restoreFromTrashManage(event);
        }
    }
}

