/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.fonts.AFM;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.fonts.ofont.CMap;
import org.icepdf.core.pobjects.fonts.ofont.Encoding;
import org.icepdf.core.pobjects.fonts.ofont.OFont;
import org.icepdf.core.util.FontUtil;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
extends org.icepdf.core.pobjects.fonts.Font {
    private static final Logger logger = Logger.getLogger(Font.class.toString());
    public static final Name BASE_ENCODING_KEY = new Name("BaseEncoding");
    public static final Name ENCODING_KEY = new Name("Encoding");
    public static final Name TOUNICODE_KEY = new Name("ToUnicode");
    public static final Name DIFFERENCES_KEY = new Name("Differences");
    public static final Name WIDTHS_KEY = new Name("Widths");
    public static final Name FIRST_CHAR_KEY = new Name("FirstChar");
    public static final Name W_KEY = new Name("W");
    public static final Name FONT_DESCRIPTOR_KEY = new Name("FontDescriptor");
    public static final Name DESCENDANT_FONTS_KEY = new Name("DescendantFonts");
    public static final Name NONE_KEY = new Name("none");
    public static final Name STANDARD_ENCODING_KEY = new Name("StandardEncoding");
    public static final Name MACROMAN_ENCODING_KEY = new Name("MacRomanEncoding");
    public static final Name WINANSI_ENCODING_KEY = new Name("WinAnsiEncoding");
    public static final Name PDF_DOC_ENCODING_KEY = new Name("PDFDocEncoding");
    private Encoding encoding;
    private Name encodingName;
    private List widths;
    private HashMap<Integer, Float> cidWidths;
    private char[] cMap = new char[256];
    private CMap toUnicodeCMap;
    protected AFM afm;
    protected int style;
    private static final java.awt.Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    static final String[][] type1Diff = new String[][]{{"Bookman-Demi", "URWBookmanL-DemiBold", "Arial"}, {"Bookman-DemiItalic", "URWBookmanL-DemiBoldItal", "Arial"}, {"Bookman-Light", "URWBookmanL-Ligh", "Arial"}, {"Bookman-LightItalic", "URWBookmanL-LighItal", "Arial"}, {"Courier", "Nimbus Mono L Regular", "Nimbus Mono L"}, {"Courier-Oblique", "Nimbus Mono L Regular Oblique", "Nimbus Mono L"}, {"Courier-Bold", "Nimbus Mono L Bold", "Nimbus Mono L"}, {"Courier-BoldOblique", "Nimbus Mono L Bold Oblique", "Nimbus Mono L"}, {"AvantGarde-Book", "URWGothicL-Book", "Arial"}, {"AvantGarde-BookOblique", "URWGothicL-BookObli", "Arial"}, {"AvantGarde-Demi", "URWGothicL-Demi", "Arial"}, {"AvantGarde-DemiOblique", "URWGothicL-DemiObli", "Arial"}, {"Helvetica", "Nimbus Sans L Regular", "Nimbus Sans L"}, {"Helvetica-Oblique", "Nimbus Sans L Regular Italic", "Nimbus Sans L"}, {"Helvetica-Bold", "Nimbus Sans L Bold", "Nimbus Sans L"}, {"Helvetica-BoldOblique", "Nimbus Sans L Bold Italic", "Nimbus Sans L"}, {"Helvetica-Narrow", "Nimbus Sans L Regular Condensed", "Nimbus Sans L"}, {"Helvetica-Narrow-Oblique", "Nimbus Sans L Regular Condensed Italic", "Nimbus Sans L"}, {"Helvetica-Narrow-Bold", "Nimbus Sans L Bold Condensed", "Nimbus Sans L"}, {"Helvetica-Narrow-BoldOblique", "Nimbus Sans L Bold Condensed Italic", "Nimbus Sans L"}, {"Helvetica-Condensed", "Nimbus Sans L Regular Condensed", "Nimbus Sans L"}, {"Helvetica-Condensed-Oblique", "Nimbus Sans L Regular Condensed Italic", "Nimbus Sans L"}, {"Helvetica-Condensed-Bold", "Nimbus Sans L Bold Condensed", "Nimbus Sans L"}, {"Helvetica-Condensed-BoldOblique", "Nimbus Sans L Bold Condensed Italic", "Nimbus Sans L"}, {"Palatino-Roman", "URWPalladioL-Roma", "Arial"}, {"Palatino-Italic", "URWPalladioL-Ital", "Arial"}, {"Palatino-Bold", "URWPalladioL-Bold", "Arial"}, {"Palatino-BoldItalic", "URWPalladioL-BoldItal", "Arial"}, {"NewCenturySchlbk-Roman", "CenturySchL-Roma", "Arial"}, {"NewCenturySchlbk-Italic", "CenturySchL-Ital", "Arial"}, {"NewCenturySchlbk-Bold", "CenturySchL-Bold", "Arial"}, {"NewCenturySchlbk-BoldItalic", "CenturySchL-BoldItal", "Arial"}, {"Times-Roman", "Nimbus Roman No9 L Regular", "Nimbus Roman No9 L"}, {"Times-Italic", "Nimbus Roman No9 L Regular Italic", "Nimbus Roman No9 L"}, {"Times-Bold", "Nimbus Roman No9 L Medium", "Nimbus Roman No9 L"}, {"Times-BoldItalic", "Nimbus Roman No9 L Medium Italic", "Nimbus Roman No9 L"}, {"Symbol", "Standard Symbols L", "Standard Symbols L"}, {"ZapfChancery-MediumItalic", "URWChanceryL-MediItal", "Arial"}, {"ZapfDingbats", "Dingbats", "Dingbats"}};

    public Font(Library library, HashMap entries) {
        super(library, entries);
        for (int i = 0; i < 256; i = (int)((char)(i + 1))) {
            this.cMap[i] = i;
        }
        this.style = FontUtil.guessAWTFontStyle(this.basefont);
        this.basefont = this.cleanFontName(this.basefont);
        if (this.subtype.equals("Type3")) {
            this.basefont = "Symbol";
            this.encoding = Encoding.getSymbol();
        }
        if (this.subtype.equals("Type1")) {
            if (this.basefont.equals("Symbol")) {
                this.encoding = Encoding.getSymbol();
            } else if (this.basefont.equalsIgnoreCase("ZapfDingbats") && this.subtype.equals("Type1")) {
                this.encoding = Encoding.getZapfDingBats();
            } else {
                for (String[] aType1Diff : type1Diff) {
                    if (!this.basefont.equals(aType1Diff[0])) continue;
                    this.encodingName = STANDARD_ENCODING_KEY;
                    this.encoding = Encoding.getStandard();
                    break;
                }
            }
        }
        if (this.subtype.equals("TrueType") && this.basefont.equals("Symbol")) {
            this.encodingName = WINANSI_ENCODING_KEY;
            this.encoding = Encoding.getWinAnsi();
        }
    }

    @Override
    public synchronized void init() {
        block47: {
            AFM a;
            Object fontReference;
            List tmp;
            Object descendant;
            String name;
            AFM afm;
            Object of;
            Object o;
            Object objectUnicode;
            if (this.inited) {
                return;
            }
            if (this.encoding != null) {
                for (char i = '\u0000'; i < '\u0100'; i = (char)(i + '\u0001')) {
                    this.cMap[i] = this.encoding.get(i);
                }
            }
            if ((objectUnicode = this.library.getObject(this.entries, TOUNICODE_KEY)) != null && objectUnicode instanceof Stream) {
                this.toUnicodeCMap = new CMap(this.library, new HashMap(), (Stream)objectUnicode);
                this.toUnicodeCMap.init();
            }
            if ((o = this.library.getObject(this.entries, ENCODING_KEY)) != null) {
                if (o instanceof HashMap) {
                    HashMap encoding = (HashMap)o;
                    this.setBaseEncoding(this.library.getName(encoding, BASE_ENCODING_KEY));
                    List differences = (List)this.library.getObject(encoding, DIFFERENCES_KEY);
                    if (differences != null) {
                        int c = 0;
                        for (Object oo : differences) {
                            if (oo instanceof Number) {
                                c = ((Number)oo).intValue();
                                continue;
                            }
                            if (!(oo instanceof Name)) continue;
                            String n = oo.toString();
                            int c1 = Encoding.getUV(n);
                            if (c1 == -1 && n.charAt(0) == 'a') {
                                n = n.substring(1);
                                try {
                                    c1 = Integer.parseInt(n);
                                }
                                catch (Exception ex) {
                                    logger.log(Level.FINE, "Error parings font differences");
                                }
                            }
                            this.cMap[c] = (char)c1;
                            ++c;
                        }
                    }
                } else if (o instanceof Name) {
                    this.setBaseEncoding((Name)o);
                }
            }
            this.widths = (List)this.library.getObject(this.entries, WIDTHS_KEY);
            if (this.widths != null) {
                o = this.library.getObject(this.entries, FIRST_CHAR_KEY);
                if (o != null) {
                    this.firstchar = ((Number)o).intValue();
                }
            } else if (this.library.getObject(this.entries, W_KEY) != null) {
                this.cidWidths = this.calculateCIDWidths();
                this.firstchar = 0;
                this.isAFMFont = false;
            } else {
                this.isAFMFont = false;
            }
            if ((of = this.library.getObject(this.entries, FONT_DESCRIPTOR_KEY)) instanceof FontDescriptor) {
                this.fontDescriptor = (FontDescriptor)of;
                this.fontDescriptor.init();
            }
            if (this.fontDescriptor == null && this.basefont != null && (afm = AFM.AFMs.get(this.basefont.toLowerCase())) != null && afm instanceof AFM) {
                AFM fontMetrix = afm;
                this.fontDescriptor = FontDescriptor.createDescriptor(this.library, fontMetrix);
                this.fontDescriptor.init();
            }
            if (this.fontDescriptor != null && (name = this.fontDescriptor.getFontName()) != null && name.length() > 0) {
                this.basefont = this.cleanFontName(name);
            }
            if (this.fontDescriptor != null && (this.fontDescriptor.getFlags() & 0x40) != 0 && this.encoding == null) {
                this.encodingName = STANDARD_ENCODING_KEY;
                this.encoding = Encoding.getStandard();
            }
            if ((descendant = this.library.getObject(this.entries, DESCENDANT_FONTS_KEY)) != null && (tmp = (List)descendant).get(0) instanceof Reference && (fontReference = this.library.getObject((Reference)tmp.get(0))) instanceof Font) {
                Font desendant = (Font)fontReference;
                desendant.toUnicodeCMap = this.toUnicodeCMap;
                desendant.init();
                this.cidWidths = desendant.cidWidths;
                if (this.fontDescriptor == null) {
                    this.fontDescriptor = desendant.fontDescriptor;
                    String name2 = this.fontDescriptor.getFontName();
                    if (name2 != null) {
                        this.basefont = this.cleanFontName(name2);
                    }
                }
            }
            if (this.subtype.equals("Type1") && (a = AFM.AFMs.get(this.basefont.toLowerCase())) != null && a.getFontName() != null) {
                this.afm = a;
            }
            if (this.subtype.equals("Type1")) {
                for (String[] aType1Diff : type1Diff) {
                    java.awt.Font f;
                    if (!this.basefont.equals(aType1Diff[0]) || !(f = new java.awt.Font(aType1Diff[1], this.style, 12)).getFamily().equals(aType1Diff[2])) continue;
                    this.basefont = aType1Diff[1];
                    break;
                }
            }
            this.isFontSubstitution = true;
            if (this.fontDescriptor != null && this.fontDescriptor.getEmbeddedFont() != null) {
                this.font = this.fontDescriptor.getEmbeddedFont();
                this.isFontSubstitution = false;
                this.isAFMFont = false;
            }
            if (this.font == null && this.basefont != null) {
                for (java.awt.Font font1 : fonts) {
                    StringTokenizer st = new StringTokenizer(font1.getPSName(), " ", false);
                    String fontName = "";
                    while (st.hasMoreElements()) {
                        fontName = fontName + st.nextElement();
                    }
                    if (!fontName.equalsIgnoreCase(this.basefont)) continue;
                    this.font = new OFont(new java.awt.Font(font1.getFamily(), this.style, 1));
                    this.basefont = font1.getPSName();
                    this.isFontSubstitution = true;
                    break;
                }
            }
            if (this.font == null && this.basefont != null) {
                String fontFamily = FontUtil.guessFamily(this.basefont);
                for (java.awt.Font font1 : fonts) {
                    if (!FontUtil.normalizeString(font1.getFamily()).equalsIgnoreCase(fontFamily)) continue;
                    this.font = new OFont(new java.awt.Font(font1.getFamily(), this.style, 1));
                    this.basefont = font1.getFontName();
                    this.isFontSubstitution = true;
                    break;
                }
            }
            if (this.font == null) {
                try {
                    this.font = new OFont(java.awt.Font.getFont(this.basefont, new java.awt.Font(this.basefont, this.style, 12)));
                    this.basefont = this.font.getName();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block47;
                    logger.warning("Error creating awt.font for: " + this.entries);
                }
            }
        }
        if (!this.isFontSubstitution && this.font != null && !this.font.getName().toLowerCase().contains(this.font.getFamily().toLowerCase())) {
            if (this.font.getName().toLowerCase().contains("times new roman") || this.font.getName().toLowerCase().contains("timesnewroman") || this.font.getName().toLowerCase().contains("bodoni") || this.font.getName().toLowerCase().contains("garamond") || this.font.getName().toLowerCase().contains("minion web") || this.font.getName().toLowerCase().contains("stone serif") || this.font.getName().toLowerCase().contains("stoneserif") || this.font.getName().toLowerCase().contains("georgia") || this.font.getName().toLowerCase().contains("bitstream cyberbit")) {
                this.font = new OFont(new java.awt.Font("serif", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "serif";
            } else if (this.font.getName().toLowerCase().contains("helvetica") || this.font.getName().toLowerCase().contains("arial") || this.font.getName().toLowerCase().contains("trebuchet") || this.font.getName().toLowerCase().contains("avant garde gothic") || this.font.getName().toLowerCase().contains("avantgardegothic") || this.font.getName().toLowerCase().contains("verdana") || this.font.getName().toLowerCase().contains("univers") || this.font.getName().toLowerCase().contains("futura") || this.font.getName().toLowerCase().contains("stone sans") || this.font.getName().toLowerCase().contains("stonesans") || this.font.getName().toLowerCase().contains("gill sans") || this.font.getName().toLowerCase().contains("gillsans") || this.font.getName().toLowerCase().contains("akzidenz") || this.font.getName().toLowerCase().contains("grotesk")) {
                this.font = new OFont(new java.awt.Font("sansserif", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "sansserif";
            } else if (this.font.getName().toLowerCase().contains("courier") || this.font.getName().toLowerCase().contains("courier new") || this.font.getName().toLowerCase().contains("couriernew") || this.font.getName().toLowerCase().contains("prestige") || this.font.getName().toLowerCase().contains("eversonmono") || this.font.getName().toLowerCase().contains("Everson Mono")) {
                this.font = new OFont(new java.awt.Font("monospaced", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "monospaced";
            } else {
                this.font = new OFont(new java.awt.Font("serif", this.font.getStyle(), (int)this.font.getSize()));
                this.basefont = "serif";
            }
        }
        if (this.font == null) {
            this.font = new OFont(new java.awt.Font("serif", this.style, 12));
            this.basefont = "serif";
        }
        this.setWidth();
        this.font = this.font.deriveFont(this.encoding, this.toUnicodeCMap);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.name + " - " + this.encodingName + " " + this.basefont + " " + this.font.toString() + " " + this.isFontSubstitution);
        }
        this.inited = true;
    }

    private void setBaseEncoding(Name baseEncoding) {
        if (baseEncoding == null) {
            this.encodingName = NONE_KEY;
            return;
        }
        this.encodingName = baseEncoding;
        if (baseEncoding.equals(STANDARD_ENCODING_KEY)) {
            this.encoding = Encoding.getStandard();
        } else if (baseEncoding.equals(MACROMAN_ENCODING_KEY)) {
            this.encoding = Encoding.getMacRoman();
        } else if (baseEncoding.equals(WINANSI_ENCODING_KEY)) {
            this.encoding = Encoding.getWinAnsi();
        } else if (baseEncoding.equals(PDF_DOC_ENCODING_KEY)) {
            this.encoding = Encoding.getPDFDoc();
        }
        if (this.encoding != null) {
            for (char i = '\u0000'; i < '\u0100'; i = (char)(i + '\u0001')) {
                this.cMap[i] = this.encoding.get(i);
            }
        }
    }

    @Override
    public String toString() {
        return "FONT= " + this.encodingName + " " + this.entries.toString();
    }

    private void setWidth() {
        float missingWidth = 0.0f;
        float ascent = 0.0f;
        float descent = 0.0f;
        if (this.fontDescriptor != null && this.fontDescriptor.getMissingWidth() > 0.0f) {
            missingWidth = this.fontDescriptor.getMissingWidth() / 1000.0f;
            ascent = this.fontDescriptor.getAscent() / 1000.0f;
            descent = this.fontDescriptor.getDescent() / 1000.0f;
        }
        if (this.widths != null) {
            float[] newWidth = new float[256 - this.firstchar];
            int max = this.widths.size();
            for (int i = 0; i < max; ++i) {
                if (this.widths.get(i) == null) continue;
                newWidth[i] = ((Number)this.widths.get(i)).floatValue() / 1000.0f;
            }
            this.font = this.font.deriveFont(newWidth, this.firstchar, missingWidth, ascent, descent, this.cMap);
        } else if (this.cidWidths != null) {
            this.font = this.font.deriveFont(this.cidWidths, this.firstchar, missingWidth, ascent, descent, null);
        } else if (this.afm != null && this.isAFMFont) {
            this.font = this.font.deriveFont(this.afm.getWidths(), this.firstchar, missingWidth, ascent, descent, this.cMap);
        }
    }

    private String cleanFontName(String fontName) {
        fontName = FontUtil.removeBaseFontSubset(fontName);
        if ((this.subtype.equals("Type0") || this.subtype.equals("Type1") || this.subtype.equals("MMType1") || this.subtype.equals("TrueType")) && fontName != null) {
            fontName = fontName.replace(',', '-');
        }
        return fontName;
    }

    private HashMap<Integer, Float> calculateCIDWidths() {
        HashMap<Integer, Float> cidWidths = new HashMap<Integer, Float>(75);
        Object o = this.library.getObject(this.entries, W_KEY);
        if (o instanceof List) {
            List cidWidth = (List)o;
            int max = cidWidth.size() - 1;
            for (int i = 0; i < max; ++i) {
                int j;
                int currentChar;
                Object current = cidWidth.get(i);
                Object peek = cidWidth.get(i + 1);
                if (current instanceof Integer && peek instanceof List) {
                    currentChar = (Integer)current;
                    List subWidth = (List)peek;
                    int subMax = subWidth.size();
                    for (j = 0; j < subMax; ++j) {
                        if (subWidth.get(j) instanceof Integer) {
                            cidWidths.put(currentChar + j, Float.valueOf((float)((Integer)subWidth.get(j)).intValue() / 1000.0f));
                            continue;
                        }
                        if (!(subWidth.get(j) instanceof Float)) continue;
                        cidWidths.put(currentChar + j, Float.valueOf(((Float)subWidth.get(j)).floatValue() / 1000.0f));
                    }
                    ++i;
                }
                if (!(current instanceof Integer) || !(peek instanceof Integer)) continue;
                for (j = ((Integer)current).intValue(); j <= (Integer)peek; ++j) {
                    currentChar = j;
                    if (cidWidth.get(i + 2) instanceof Integer) {
                        cidWidths.put(currentChar, Float.valueOf((float)((Integer)cidWidth.get(i + 2)).intValue() / 1000.0f));
                        continue;
                    }
                    if (!(cidWidth.get(i + 2) instanceof Float)) continue;
                    cidWidths.put(currentChar, Float.valueOf(((Float)cidWidth.get(i + 2)).floatValue() / 1000.0f));
                }
                i += 2;
            }
        }
        return cidWidths;
    }
}

