/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.connector.BaseConnector;
import org.w3c.dom.Document;

@Path(value="/feed/")
public class RssConnector
extends BaseConnector
implements ResourceContainer {
    private static String WORKSPACE = "workspace";
    private static String REPOSITORY = "repository";
    private static String RSS_VERSION = "rss_2.0";
    private static String FEED_TITLE = "exo:feedTitle";
    private static String DESCRIPTION = "exo:description";
    private static String TITLE = "exo:title";
    private static String LINK = "exo:link";
    private static String SUMMARY = "exo:summary";
    private static String DETAIL_PAGE = "detail-page";
    private static String DETAIL_PARAM = "detail-param";
    private WCMComposer wcmComposer;
    private WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)WCMCoreUtils.getService(WCMConfigurationService.class);
    private static final Log LOG = ExoLogger.getLogger((String)RssConnector.class.getName());

    public RssConnector() {
        this.wcmComposer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
    }

    @GET
    @Path(value="/rss/")
    public Response generate(@QueryParam(value="repository") String repository, @QueryParam(value="workspace") String workspace, @QueryParam(value="server") String server, @QueryParam(value="siteName") String siteName, @QueryParam(value="title") String title, @QueryParam(value="desc") String desc, @QueryParam(value="folderPath") String folderPath, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="orderType") String orderType, @QueryParam(value="lang") String lang, @QueryParam(value="detailPage") String detailPage, @QueryParam(value="detailParam") String detailParam, @QueryParam(value="recursive") String recursive) throws Exception {
        HashMap<String, String> contextRss = new HashMap<String, String>();
        contextRss.put(REPOSITORY, repository);
        contextRss.put(WORKSPACE, workspace);
        contextRss.put(RSS_VERSION, "rss_2.0");
        contextRss.put(FEED_TITLE, title);
        if (desc == null) {
            desc = "Powered by eXo WCM-" + WCMCoreUtils.getProjectVersion();
        }
        contextRss.put(DESCRIPTION, desc);
        contextRss.put(LINK, server);
        if (detailPage == null) {
            detailPage = this.wcmConfigurationService.getRuntimeContextParam("parameterizedPageURI");
        }
        contextRss.put(DETAIL_PAGE, detailPage);
        if (detailParam == null) {
            detailParam = "content-id";
        }
        contextRss.put(DETAIL_PARAM, detailParam);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("filter-mode", "Live");
        if (orderType == null) {
            orderType = "DESC";
        }
        if (orderBy == null) {
            orderBy = "publication:liveDate";
        }
        if (lang == null) {
            lang = "en";
        }
        filters.put("filter-order-by", orderBy);
        filters.put("filter-order-type", orderType);
        filters.put("filter-language", lang);
        filters.put("filter-recursive", recursive);
        String path = null;
        if (folderPath != null) {
            path = folderPath;
        }
        List nodes = this.wcmComposer.getContents(workspace, path, filters, WCMCoreUtils.getUserSessionProvider());
        String feedXML = this.generateRSS(nodes, contextRss);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(feedXML.getBytes()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        Response response = Response.ok((Object)new DOMSource(document), (String)"text/xml").header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        return response;
    }

    private String generateRSS(List<Node> nodes, Map<String, String> context) {
        String rssVersion = context.get(RSS_VERSION);
        String feedTitle = context.get(FEED_TITLE);
        String feedDescription = context.get(DESCRIPTION);
        String feedLink = context.get(LINK);
        String detailPage = context.get(DETAIL_PAGE);
        String detailParam = context.get(DETAIL_PARAM);
        String repository = context.get(REPOSITORY);
        String workspace = context.get(WORKSPACE);
        String contentUrl = !feedLink.endsWith("/") ? feedLink + "/" + detailPage + "?" + detailParam + "=/" + repository + "/" + workspace : feedLink + detailPage + "?" + detailParam + "=/" + repository + "/" + workspace;
        if (feedTitle == null || feedTitle.length() == 0) {
            feedTitle = "";
        }
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssVersion);
            feed.setTitle(feedTitle.replaceAll("&nbsp;", " "));
            feed.setLink(feedLink);
            feed.setDescription(feedDescription.replaceAll("&nbsp;", " "));
            feed.setEncoding("UTF-8");
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            for (Node node : nodes) {
                StringBuilder url = new StringBuilder();
                url.append(contentUrl);
                if (node.isNodeType("nt:frozenNode")) {
                    String uuid = node.getProperty("jcr:frozenUuid").getString();
                    Node originalNode = node.getSession().getNodeByUUID(uuid);
                    url.append(originalNode.getPath());
                    url.append("&version=");
                    url.append(node.getParent().getName());
                } else {
                    url.append(node.getPath());
                }
                SyndEntryImpl entry = new SyndEntryImpl();
                if (node.hasProperty(TITLE)) {
                    String nTitle = node.getProperty(TITLE).getString();
                    nTitle = Text.unescapeIllegalJcrChars((String)new String(nTitle.getBytes("UTF-8")));
                    entry.setTitle(Text.encodeIllegalXMLCharacters((String)nTitle).replaceAll("&quot;", "\"").replaceAll("&apos;", "'"));
                } else {
                    entry.setTitle("");
                }
                entry.setLink(url.toString());
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                if (node.hasProperty(SUMMARY)) {
                    String summary = Text.encodeIllegalXMLCharacters((String)node.getProperty(SUMMARY).getString()).replaceAll("&nbsp;", " ").replaceAll("&amp;quot;", "\"").replaceAll("&apos;", "'");
                    description.setValue(summary);
                } else {
                    description.setValue("");
                }
                entry.setDescription((SyndContent)description);
                entries.add(entry);
                entry.getEnclosures();
            }
            feed.setEntries(entries);
            SyndFeedOutput output = new SyndFeedOutput();
            return output.outputString((SyndFeed)feed);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error when perform generateRSS: ", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected String getContentStorageType() throws Exception {
        return null;
    }

    @Override
    protected Node getRootContentStorage(Node node) throws Exception {
        return null;
    }
}

