/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public class IsNotIgnoreVersionNodeFilter
implements UIExtensionFilter {
    private static final Log LOG = ExoLogger.getLogger(IsNotIgnoreVersionNodeFilter.class);
    public static final String NODETYPES_IGNOREVERSION_PARAM = "wcm.nodetypes.ignoreversion";
    private List<NodeType> ignoredNodetypes = new ArrayList<NodeType>();

    public IsNotIgnoreVersionNodeFilter() {
        String[] arrNodetypes;
        String nodetypes = System.getProperty(NODETYPES_IGNOREVERSION_PARAM);
        if (StringUtils.isBlank((String)nodetypes)) {
            nodetypes = "exo:webContent";
        }
        for (String nodetype : arrNodetypes = nodetypes.split(",")) {
            ExtendedNodeTypeManager ntmanager = WCMCoreUtils.getRepository().getNodeTypeManager();
            try {
                this.ignoredNodetypes.add(ntmanager.getNodeType(nodetype));
            }
            catch (NoSuchNodeTypeException e) {
                LOG.warn((Object)"Nodetype '{}' configured in wcm.nodetypes.ignoreversion does not exist");
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error while fetching nodetype '" + nodetype + "'"), (Throwable)e);
            }
        }
    }

    public boolean accept(Map<String, Object> context) throws Exception {
        Node currentNode;
        if (context == null) {
            return true;
        }
        Node parentNode = currentNode = (Node)context.get(Node.class.getName());
        do {
            try {
                parentNode = parentNode.getParent();
            }
            catch (AccessDeniedException ex) {
                return true;
            }
            catch (Exception ex) {
                LOG.error((Object)("Error while getting parent of node " + parentNode.getPath()), (Throwable)ex);
                return false;
            }
            for (NodeType nodetype : this.ignoredNodetypes) {
                if (!parentNode.isNodeType(nodetype.getName())) continue;
                return false;
            }
        } while (!((NodeImpl)parentNode).isRoot());
        return true;
    }

    public UIExtensionFilterType getType() {
        return UIExtensionFilterType.MANDATORY;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
    }
}

