/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.action;

import java.security.AccessControlException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.CloudDriveStorage;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.NotCloudDriveException;
import org.exoplatform.services.cms.clouddrives.ThreadExecutor;
import org.exoplatform.services.cms.clouddrives.jcr.NodeFinder;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.picocontainer.Startable;

public class CloudFileActionService
implements Startable {
    public static final String EXO_SYMLINK = "exo:symlink";
    public static final String ECD_CLOUDFILELINK = "ecd:cloudFileLink";
    public static final String ECD_SHAREIDENTITY = "ecd:shareIdentity";
    public static final String SHARE_CLOUD_FILES_SPACES = "sharecloudfiles:spaces";
    protected static final Log LOG = ExoLogger.getLogger(CloudFileActionService.class);
    protected static final String SPACES_GROUP = "spaces";
    protected static final String EXO_OWNEABLE = "exo:owneable";
    protected static final String EXO_PRIVILEGEABLE = "exo:privilegeable";
    protected static final String EXO_TRASHFOLDER = "exo:trashFolder";
    protected static final String[] READER_PERMISSION = new String[]{"read"};
    protected static final String[] MANAGER_PERMISSION = new String[]{"read", "remove", "set_property"};
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final SessionProviderService sessionProviders;
    protected final OrganizationService orgService;
    protected final LinkManager linkManager;
    protected final ManageDriveService documentDrives;
    protected final TrashService trash;
    protected final ListenerService listenerService;
    protected final CmsService cmsService;
    protected final Map<String, String> removedLinks = new ConcurrentHashMap<String, String>();
    protected final Map<String, String> removedShared = new ConcurrentHashMap<String, String>();
    protected final NodeFinder finder;
    protected final ThreadExecutor workerExecutor = ThreadExecutor.getInstance();
    protected final String groupsPath;
    protected final String usersPath;

    public CloudFileActionService(CloudDriveService cloudDrives, RepositoryService jcrService, SessionProviderService sessionProviders, OrganizationService orgService, NodeFinder finder, NodeHierarchyCreator hierarchyCreator, LinkManager linkManager, ManageDriveService documentDrives, TrashService trash, ListenerService listeners, CmsService cmsService) {
        this.cloudDrives = cloudDrives;
        this.jcrService = jcrService;
        this.orgService = orgService;
        this.sessionProviders = sessionProviders;
        this.finder = finder;
        this.hierarchyCreator = hierarchyCreator;
        this.linkManager = linkManager;
        this.documentDrives = documentDrives;
        this.trash = trash;
        this.listenerService = listeners;
        this.cmsService = cmsService;
        this.groupsPath = hierarchyCreator.getJcrPath("groupsPath");
        this.usersPath = hierarchyCreator.getJcrPath("usersPath");
    }

    @Deprecated
    public boolean isGroupDrive(DriveData drive) {
        return drive.getHomePath().startsWith(this.groupsPath);
    }

    @Deprecated
    public boolean isUserDrive(DriveData drive) {
        return drive.getHomePath().startsWith(this.usersPath);
    }

    @Deprecated
    public boolean isGroupPath(String path) {
        return path.startsWith(this.groupsPath);
    }

    @Deprecated
    public boolean isUserPath(String path) {
        return path.startsWith(this.usersPath);
    }

    @Deprecated
    public DriveData getGroupDrive(String groupId) throws Exception {
        return this.documentDrives.getDriveByName(groupId.replace('/', '.'));
    }

    @Deprecated
    public DriveData getUserDrive(String userName) throws Exception {
        DriveData userDrive = null;
        String homePath = null;
        Iterator diter = this.documentDrives.getPersonalDrives(userName).iterator();
        while (diter.hasNext()) {
            DriveData drive = (DriveData)diter.next();
            String path = drive.getHomePath();
            if (!path.startsWith(this.usersPath) || !path.endsWith("/Private")) continue;
            homePath = path;
            userDrive = drive;
            if (homePath.indexOf("${userId}") < 0) break;
            if (diter.hasNext()) continue;
            homePath = Utils.getPersonalDrivePath((String)homePath, (String)userName);
            userDrive.setHomePath(homePath);
            break;
        }
        return userDrive;
    }

    @Deprecated
    public Node getUserPublicNode(String userName) throws Exception {
        Node profileNode = this.getUserProfileNode(userName);
        String userPublic = this.hierarchyCreator.getJcrPath("userPublic");
        return profileNode.getNode(userPublic != null ? userPublic : "Public");
    }

    @Deprecated
    public Node getUserProfileNode(String userName) throws Exception {
        SessionProvider ssp = this.sessionProviders.getSystemSessionProvider(null);
        if (ssp != null) {
            return this.hierarchyCreator.getUserNode(ssp, userName);
        }
        throw new RepositoryException("Cannot get session provider.");
    }

    public void shareToUser(Node fileNode, String userId, boolean canEdit) throws RepositoryException {
        this.setUserFilePermission(fileNode, userId, true);
        fileNode.save();
        try {
            DriveData userDrive = this.getUserDrive(userId);
            if (userDrive != null) {
                this.initCloudFileLink(fileNode, userId, userDrive.getHomePath(), canEdit);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error reading Cloud File links of " + fileNode.getPath()), (Throwable)e);
        }
    }

    public void unshareToUser(Node fileNode, String userId) throws RepositoryException {
        this.removeLinks(fileNode, userId);
        this.removePermission(fileNode, userId);
    }

    public void shareToGroup(Node fileNode, String groupId, boolean canEdit) throws RepositoryException {
        this.setGroupFilePermission(fileNode, groupId, true);
        fileNode.save();
        try {
            DriveData documentDrive = this.getGroupDrive(groupId);
            if (documentDrive != null) {
                this.initCloudFileLink(fileNode, groupId, documentDrive.getHomePath(), canEdit);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error reading Cloud File links of " + fileNode.getPath()), (Throwable)e);
        }
    }

    public void unshareToSpace(Node fileNode, String groupId) throws RepositoryException {
        this.removeLinks(fileNode, groupId);
        this.removePermission(fileNode, "*:" + groupId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node markRemoveLink(Node linkNode) throws NotCloudDriveException, DriveRemovedException, RepositoryException, CloudDriveException {
        if (linkNode.isNodeType(ECD_CLOUDFILELINK)) {
            try {
                Node target = this.linkManager.getTarget(linkNode, true);
                String cloudFileUUID = target.getUUID();
                this.removedLinks.put(linkNode.getPath(), cloudFileUUID);
                try {
                    this.removedShared.put(cloudFileUUID, linkNode.getProperty(ECD_SHAREIDENTITY).getString());
                    return target;
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
                return target;
            }
            catch (ItemNotFoundException e) {
                if (!LOG.isDebugEnabled()) return null;
                LOG.debug((Object)("Cloud File link has no target node: " + linkNode.getPath() + ". " + e.getMessage()));
                return null;
            }
        }
        LOG.warn((Object)("Not cloud file link: node " + linkNode.getPath() + " not of type " + ECD_CLOUDFILELINK));
        return null;
    }

    public void start() {
        try {
            this.listenFileLinks();
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Error starting symlinks remove listener", (Throwable)e);
        }
    }

    public void stop() {
    }

    protected void listenFileLinks() throws RepositoryException {
        Session session = null;
        try {
            session = this.systemSession();
            ObservationManager observation = session.getWorkspace().getObservationManager();
            observation.addEventListener((EventListener)new LinkTrashListener(), 1, null, false, null, new String[]{EXO_TRASHFOLDER}, false);
            observation.addEventListener((EventListener)new LinkRemoveListener(), 8, null, false, null, new String[]{ECD_CLOUDFILELINK}, false);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected String documentName(Node document) throws RepositoryException {
        try {
            return document.getProperty("exo:title").getString();
        }
        catch (PathNotFoundException te) {
            try {
                return document.getProperty("exo:name").getString();
            }
            catch (PathNotFoundException ne) {
                return document.getName();
            }
        }
    }

    protected Session systemSession() throws RepositoryException {
        SessionProvider ssp = this.sessionProviders.getSystemSessionProvider(null);
        if (ssp != null) {
            ManageableRepository jcrRepository = this.jcrService.getCurrentRepository();
            String workspaceName = jcrRepository.getConfiguration().getDefaultWorkspaceName();
            return ssp.getSession(workspaceName, jcrRepository);
        }
        throw new RepositoryException("Cannot get session provider.");
    }

    protected void removeLinks(Node fileNode, String identity) throws RepositoryException {
        NodeIterator niter = this.getCloudFileLinks(fileNode, identity, true);
        while (niter.hasNext()) {
            Node linkNode = niter.nextNode();
            try {
                org.exoplatform.wcm.ext.component.activity.listener.Utils.deleteFileActivity((Node)linkNode);
            }
            catch (Throwable e) {
                LOG.warn((Object)("Failed to remove unpublished file activity: " + linkNode.getPath()), e);
            }
            Node parent = linkNode.getParent();
            linkNode.remove();
            parent.save();
        }
    }

    public NodeIterator getCloudFileLinks(Node targetNode, String shareIdentity, String scopePath, boolean useSystemSession) throws RepositoryException {
        StringBuilder queryCode = new StringBuilder().append("SELECT * FROM ").append(ECD_CLOUDFILELINK).append(" WHERE exo:uuid='").append(targetNode.getUUID()).append("'");
        if (shareIdentity != null && shareIdentity.length() > 0) {
            queryCode.append(" AND ecd:shareIdentity='").append(shareIdentity).append("'");
        }
        if (scopePath != null && scopePath.length() > 0) {
            queryCode.append(" AND jcr:path LIKE '").append(scopePath).append("/%'");
        }
        QueryManager queryManager = useSystemSession ? this.systemSession().getWorkspace().getQueryManager() : targetNode.getSession().getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryCode.toString(), "sql");
        QueryResult queryResult = query.execute();
        return queryResult.getNodes();
    }

    protected String getMembershipName(String membershipType) {
        try {
            return this.orgService.getMembershipTypeHandler().findMembershipType(membershipType).getName();
        }
        catch (Exception e) {
            LOG.error((Object)"Error finding manager membership in organization service. Will use any (*) to remove permissions of shared cloud file link", (Throwable)e);
            return "*";
        }
    }

    protected void removePermission(Node node, String permIdentity) {
        try {
            ExtendedNode target = (ExtendedNode)node;
            target.removePermission(permIdentity);
            target.save();
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to remove permissions on " + node + " for " + permIdentity), (Throwable)e);
        }
    }

    protected void setUserFilePermission(Node fileNode, String userId, boolean forcePrivilegeable) throws RepositoryException {
        ExtendedNode file = (ExtendedNode)fileNode;
        boolean setPermission = false;
        if (file.canAddMixin(EXO_PRIVILEGEABLE)) {
            if (forcePrivilegeable) {
                file.addMixin(EXO_PRIVILEGEABLE);
                setPermission = true;
            }
        } else if (file.isNodeType(EXO_PRIVILEGEABLE)) {
            setPermission = true;
        }
        if (setPermission && !file.getACL().getPermissions(userId).contains("read")) {
            file.getACL().addPermissions(userId, READER_PERMISSION);
        }
        if (fileNode.isNodeType("nt:folder")) {
            NodeIterator niter = file.getNodes();
            while (niter.hasNext()) {
                Node child = niter.nextNode();
                this.setUserFilePermission(child, userId, false);
            }
        }
    }

    protected void setGroupFilePermission(Node fileNode, String groupId, boolean forcePrivilegeable) throws RepositoryException {
        ExtendedNode file = (ExtendedNode)fileNode;
        boolean setPermission = false;
        if (file.canAddMixin(EXO_PRIVILEGEABLE)) {
            if (forcePrivilegeable) {
                file.addMixin(EXO_PRIVILEGEABLE);
                setPermission = true;
            }
        } else if (file.isNodeType(EXO_PRIVILEGEABLE)) {
            setPermission = true;
        }
        if (setPermission) {
            String identity = "*:" + groupId;
            if (!file.getACL().getPermissions(identity).contains("read")) {
                file.getACL().addPermissions(identity, READER_PERMISSION);
            }
        }
        if (fileNode.isNodeType("nt:folder")) {
            NodeIterator niter = file.getNodes();
            while (niter.hasNext()) {
                Node child = niter.nextNode();
                this.setGroupFilePermission(child, groupId, false);
            }
        }
    }

    protected void setLinkPermission(Node linkNode, String ownerId, String sharedIdentity, boolean canEdit) throws AccessControlException, RepositoryException {
        ExtendedNode link = (ExtendedNode)linkNode;
        boolean setPermission = false;
        if (link.canAddMixin(EXO_PRIVILEGEABLE)) {
            link.addMixin(EXO_PRIVILEGEABLE);
            setPermission = true;
        } else if (link.isNodeType(EXO_PRIVILEGEABLE)) {
            setPermission = true;
        }
        if (setPermission) {
            if (sharedIdentity.startsWith("/")) {
                link.setPermission(ownerId, PermissionType.ALL);
                if (canEdit) {
                    link.setPermission("*:" + sharedIdentity, MANAGER_PERMISSION);
                } else {
                    this.removeWritePermissions(link, sharedIdentity);
                    link.setPermission("*:" + sharedIdentity, READER_PERMISSION);
                    String managerMembership = this.getMembershipName("manager");
                    link.setPermission(managerMembership + ':' + sharedIdentity, MANAGER_PERMISSION);
                }
            } else {
                link.setPermission(ownerId, PermissionType.ALL);
                link.setPermission(sharedIdentity, MANAGER_PERMISSION);
            }
        }
    }

    protected void initCloudFileLink(Node fileNode, String identity, String targetPath, boolean canEdit) {
        try {
            SessionProvider systemSession = this.sessionProviders.getSystemSessionProvider(null);
            List links = this.linkManager.getAllLinks(fileNode, EXO_SYMLINK, systemSession);
            for (Node linkNode : links) {
                if (!linkNode.getPath().startsWith(targetPath)) continue;
                if (linkNode.canAddMixin(ECD_CLOUDFILELINK)) {
                    linkNode.addMixin(ECD_CLOUDFILELINK);
                    if (identity != null) {
                        linkNode.setProperty(ECD_SHAREIDENTITY, identity);
                    }
                    this.setLinkPermission(linkNode, ((ExtendedNode)fileNode).getACL().getOwner(), identity, canEdit);
                    linkNode.save();
                    continue;
                }
                LOG.warn((Object)("Cannot add mixin ecd:cloudFileLink to symlink " + linkNode.getPath()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error initializing cloud file link: " + fileNode), (Throwable)e);
        }
    }

    protected void removeWritePermissions(ExtendedNode target, String groupOrUserId) throws RepositoryException {
        for (AccessControlEntry acle : target.getACL().getPermissionEntries()) {
            if (!acle.getIdentity().equals(groupOrUserId) && (acle.getMembershipEntry() == null || !acle.getMembershipEntry().getGroup().equals(groupOrUserId)) || !"add_node".equals(acle.getPermission()) && !"remove".equals(acle.getPermission()) && !"set_property".equals(acle.getPermission())) continue;
            target.removePermission(acle.getIdentity(), acle.getPermission());
        }
    }

    public NodeIterator getCloudFileLinks(Node targetNode, String shareIdentity, boolean useSystemSession) throws RepositoryException {
        return this.getCloudFileLinks(targetNode, shareIdentity, null, useSystemSession);
    }

    protected class LinkTrashListener
    implements EventListener {
        private final Queue<String> processingLinks = new ConcurrentLinkedQueue<String>();

        protected LinkTrashListener() {
        }

        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                Event event = events.nextEvent();
                try {
                    final String eventPath = event.getPath();
                    Item linkItem = CloudFileActionService.this.systemSession().getItem(eventPath);
                    if (!linkItem.isNode() || !CloudFileActionService.this.linkManager.isLink(linkItem)) continue;
                    try {
                        Node fileNode = CloudFileActionService.this.linkManager.getTarget((Node)linkItem, true);
                        CloudDrive localDrive = CloudFileActionService.this.cloudDrives.findDrive(fileNode);
                        if (localDrive != null) {
                            if (localDrive.isConnected()) {
                                String cloudFileUUID;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Cloud File link trashed. User: " + event.getUserID() + ". Path: " + eventPath));
                                }
                                if (this.processingLinks.contains(cloudFileUUID = fileNode.getUUID())) continue;
                                this.processingLinks.add(cloudFileUUID);
                                CloudFileActionService.this.removedLinks.values().remove(cloudFileUUID);
                                CloudFileActionService.this.removedLinks.put(eventPath, cloudFileUUID);
                                final ExoContainer container = ExoContainerContext.getCurrentContainer();
                                CloudFileActionService.this.workerExecutor.submit(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        try {
                                            Thread.sleep(2000L);
                                            ExoContainerContext.setCurrentContainer((ExoContainer)container);
                                            RequestLifeCycle.begin((ExoContainer)container);
                                            try {
                                                Item linkItem = CloudFileActionService.this.systemSession().getItem(eventPath);
                                                if (linkItem.isNode()) {
                                                    Node linkNode = (Node)linkItem;
                                                    Node parent = linkNode.getParent();
                                                    linkNode.remove();
                                                    parent.save();
                                                    if (LOG.isDebugEnabled()) {
                                                        LOG.debug((Object)("Cloud File link '" + linkItem.getName() + "' successfully removed from the Trash."));
                                                    }
                                                }
                                            }
                                            finally {
                                                RequestLifeCycle.end();
                                            }
                                        }
                                        catch (PathNotFoundException e) {
                                            LOG.warn((Object)("Cloud File " + eventPath + " node already removed directly from JCR: " + e.getMessage()));
                                        }
                                        catch (InterruptedException e) {
                                            LOG.warn((Object)("Cloud File symlink remover interrupted " + e.getMessage()));
                                            Thread.currentThread().interrupt();
                                        }
                                        catch (Throwable e) {
                                            LOG.error((Object)("Error removing node of Cloud File " + eventPath + ". " + e.getMessage()), e);
                                        }
                                        finally {
                                            LinkTrashListener.this.processingLinks.remove(cloudFileUUID);
                                        }
                                    }
                                });
                                continue;
                            }
                            LOG.warn((Object)("Cloud Drive not connected for " + fileNode.getPath() + ". Drive: " + localDrive));
                            continue;
                        }
                        LOG.warn((Object)("Cloud Drive not found for " + fileNode.getPath()));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Symlink " + eventPath + " removal error: " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (PathNotFoundException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    try {
                        LOG.debug((Object)("Trashed item not found " + event.getPath() + ". " + e.getMessage()), (Throwable)e);
                    }
                    catch (RepositoryException repositoryException) {
                    }
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Symlink listener error: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    protected class LinkRemoveListener
    implements EventListener {
        protected LinkRemoveListener() {
        }

        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                Event event = events.nextEvent();
                try {
                    String identity;
                    String linkPath;
                    String cloudFileUUID;
                    String eventPath = event.getPath();
                    if (!eventPath.endsWith(CloudFileActionService.ECD_SHAREIDENTITY)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Cloud File link removed. User: " + event.getUserID() + ". Path: " + eventPath));
                    }
                    if ((cloudFileUUID = CloudFileActionService.this.removedLinks.remove(linkPath = eventPath.substring(0, eventPath.indexOf(CloudFileActionService.ECD_SHAREIDENTITY) - 1))) == null || (identity = CloudFileActionService.this.removedShared.get(cloudFileUUID)) == null) continue;
                    try {
                        Node fileNode = CloudFileActionService.this.systemSession().getNodeByUUID(cloudFileUUID);
                        CloudDrive localDrive = CloudFileActionService.this.cloudDrives.findDrive(fileNode);
                        if (localDrive == null || CloudFileActionService.this.getCloudFileLinks(fileNode, identity, true).getSize() != 0L) continue;
                        DriveData documentDrive = null;
                        if (identity.startsWith("/")) {
                            documentDrive = CloudFileActionService.this.getGroupDrive(identity);
                            if (documentDrive != null) {
                                this.removeCloudFilePermission(fileNode, localDrive, "*:" + identity);
                            }
                        } else {
                            documentDrive = CloudFileActionService.this.getUserDrive(identity);
                            if (documentDrive != null) {
                                this.removeCloudFilePermission(fileNode, localDrive, identity);
                            }
                        }
                        if (documentDrive != null || !LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Cannot find documents drive for " + fileNode.getPath() + ". Unsharing not complete for this node."));
                    }
                    catch (DriveRemovedException e) {
                        LOG.warn((Object)("Cloud File unsharing canceled due to removed drive: " + e.getMessage() + ". Path: " + eventPath));
                    }
                    catch (NotCloudDriveException e) {
                        LOG.warn((Object)("Cloud File unsharing not possible for not cloud drives: " + e.getMessage() + ". Path: " + eventPath));
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Cloud File unsharing error: " + e.getMessage() + ". Path: " + eventPath), e);
                    }
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Symlink removal listener error: " + e.getMessage()), (Throwable)e);
                }
            }
        }

        protected void removeCloudFilePermission(final Node fileNode, CloudDrive cloudDrive, final String sharedIndentity) throws NotCloudDriveException, DriveRemovedException, RepositoryException, CloudDriveException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unsharing Cloud File " + fileNode.getPath() + " of " + cloudDrive + " from  " + sharedIndentity));
            }
            CloudDriveStorage cdStorage = (CloudDriveStorage)cloudDrive;
            cdStorage.localChange((CloudDriveStorage.Change)new CloudDriveStorage.Change<Void>(){

                public Void apply() throws RepositoryException {
                    CloudFileActionService.this.removePermission(fileNode, sharedIndentity);
                    return null;
                }
            });
        }
    }
}

