/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.ecm.webui.presentation.removeattach.RemoveAttachmentComponent;
import org.exoplatform.ecm.webui.presentation.removecomment.RemoveCommentComponent;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={SwitchToAudioDescriptionActionListener.class}), @EventConfig(listeners={SwitchToOriginalActionListener.class}), @EventConfig(listeners={UIBaseNodePresentation.OpenDocInDesktopActionListener.class})})
public class UIPresentation
extends UIBaseNodePresentation {
    private static final Log LOG = ExoLogger.getLogger((String)UIPresentation.class.getName());
    private NodeLocation originalNodeLocation;
    private NodeLocation viewNodeLocation;
    String templatePath = null;

    public Node getOriginalNode() throws Exception {
        return this.originalNodeLocation == null ? null : Utils.getViewableNodeByComposer((String)this.originalNodeLocation.getRepository(), (String)this.originalNodeLocation.getWorkspace(), (String)this.originalNodeLocation.getPath(), (String)"base");
    }

    public void setOriginalNode(Node node) throws Exception {
        this.originalNodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public Node getNode() throws Exception {
        Node audioDescription;
        Node ret = this.getDisplayNode();
        if ("DISPLAY".equals(this.getMediaState()) && (ret.isNodeType("exo:accessibleMedia") || ret.isNodeType("nt:frozenNode") && "exo:accessibleMedia".equals(ret.getProperty("jcr:frozenPrimaryType").getString())) && (audioDescription = org.exoplatform.services.cms.impl.Utils.getChildOfType((Node)ret, (String)"exo:audioDescription")) != null) {
            return audioDescription;
        }
        return ret;
    }

    public String getFastPublicLink(Node viewNode) {
        String fastPublishLink;
        block2: {
            fastPublishLink = null;
            try {
                UIPresentationContainer container = (UIPresentationContainer)this.getParent();
                fastPublishLink = container.event("FastPublish", NodeLocation.getExpressionByNode((Node)viewNode));
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)e.getMessage());
            }
        }
        return fastPublishLink;
    }

    public Node getDisplayNode() throws Exception {
        if (this.viewNodeLocation == null) {
            return null;
        }
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        String sharedCache = preferences.getValue("sharedCache", "true");
        sharedCache = "true".equals(sharedCache) ? "public" : "user";
        Node ret = Utils.getViewableNodeByComposer((String)this.viewNodeLocation.getRepository(), (String)this.viewNodeLocation.getWorkspace(), (String)this.viewNodeLocation.getPath(), null, (String)sharedCache);
        return ret;
    }

    public void setNode(Node node) {
        this.viewNodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public String getRepositoryName() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = portletRequestContext.getRequest().getPreferences();
        return this.originalNodeLocation != null ? this.originalNodeLocation.getRepository() : portletPreferences.getValue(UISingleContentViewerPortlet.REPOSITORY, "repository");
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public String getTemplatePath() throws Exception {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
        return new JCRResourceResolver(workspace);
    }

    public ResourceResolver getTemplateResourceResolver() {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
        return new JCRResourceResolver(workspace);
    }

    public String getNodeType() throws Exception {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public boolean isFastPublishLink() {
        return true;
    }

    public String getFastPublishLink() throws Exception {
        UIPresentationContainer container = (UIPresentationContainer)this.getParent();
        return container.event("FastPublish");
    }

    public UIComponent getCommentComponent() {
        return null;
    }

    public UIComponent getRemoveAttach() throws Exception {
        this.removeChild(RemoveAttachmentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveAttachmentComponent.class, null, "PresentationRemoveAttach");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPresentationContainer.class));
        return uicomponent;
    }

    public UIComponent getRemoveComment() throws Exception {
        this.removeChild(RemoveCommentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveCommentComponent.class, null, "PresentationRemoveComment");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPresentationContainer.class));
        return uicomponent;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getUIComponent((String)mimeType, (UIContainer)this);
    }

    public String getViewableLink(Node node, Parameter[] params) throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        String basePath = Utils.getPortletPreference((String)"basePath");
        String scvWith = Utils.getPortletPreference((String)"showScvWith");
        if (scvWith == null || scvWith.length() == 0) {
            scvWith = "content-id";
        }
        StringBuffer param = new StringBuffer();
        param.append("/").append(nodeLocation.getRepository()).append("/").append(nodeLocation.getWorkspace());
        if (node.isNodeType("nt:frozenNode")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            Node originalNode = node.getSession().getNodeByUUID(uuid);
            param.append(originalNode.getPath());
        } else {
            param.append(node.getPath());
        }
        NodeURL nodeURL = (NodeURL)Util.getPortalRequestContext().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), basePath);
        nodeURL.setResource(resource).setQueryParameterValue(scvWith, param.toString());
        String link = baseURI + nodeURL.toString();
        FriendlyService friendlyService = (FriendlyService)this.getApplicationComponent(FriendlyService.class);
        link = friendlyService.getFriendlyUri(link);
        return link;
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        Node parent = this.getOriginalNode();
        NodeIterator childrenIterator = parent.getNodes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = org.exoplatform.ecm.webui.utils.Utils.getListAllowedFileType((Node)parent, (TemplateService)templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            attachments.add(childNode);
        }
        return attachments;
    }

    public boolean isDisplayAlternativeText() {
        try {
            Node node = this.getNode();
            return (node.isNodeType("exo:accessibleMedia") || node.isNodeType("nt:frozenNode") && "exo:accessibleMedia".equals(node.getProperty("jcr:frozenPrimaryType").getString())) && node.hasProperty("exo:alternativeText") && StringUtils.isNotEmpty((String)node.getProperty("exo:alternativeText").getString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean playAudioDescription() {
        try {
            Node node = this.getNode();
            return (node.isNodeType("exo:accessibleMedia") || node.isNodeType("nt:frozenNode") && "exo:accessibleMedia".equals(node.getProperty("jcr:frozenPrimaryType").getString())) && org.exoplatform.services.cms.impl.Utils.hasChild((Node)node, (String)"exo:audioDescription");
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean switchBackAudioDescription() {
        try {
            Node node = this.getNode();
            Node parent = node.getParent();
            return node.isNodeType("exo:audioDescription") && (parent.isNodeType("exo:accessibleMedia") || parent.isNodeType("nt:frozenNode") && "exo:accessibleMedia".equals(parent.getProperty("jcr:frozenPrimaryType").getString()));
        }
        catch (Exception e) {
            return false;
        }
    }

    public UIPopupContainer getPopupContainer() throws Exception {
        return (UIPopupContainer)((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).getChild(UIPopupContainer.class);
    }

    public static class SwitchToOriginalActionListener
    extends EventListener<UIPresentation> {
        public void execute(Event<UIPresentation> event) throws Exception {
            UIPresentation uiPresentation = (UIPresentation)((Object)event.getSource());
            UIPresentationContainer uiContainer = (UIPresentationContainer)uiPresentation.getAncestorOfType(UIPresentationContainer.class);
            uiPresentation.switchMediaState();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class SwitchToAudioDescriptionActionListener
    extends EventListener<UIPresentation> {
        public void execute(Event<UIPresentation> event) throws Exception {
            UIPresentation uiPresentation = (UIPresentation)((Object)event.getSource());
            UIPresentationContainer uiContainer = (UIPresentationContainer)uiPresentation.getAncestorOfType(UIPresentationContainer.class);
            uiPresentation.switchMediaState();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class DownloadActionListener
    extends EventListener<UIPresentation> {
        public void execute(Event<UIPresentation> event) throws Exception {
            block2: {
                UIPresentation uiComp = (UIPresentation)((Object)event.getSource());
                try {
                    String downloadLink = Utils.getDownloadLink((Node)Utils.getFileLangNode((Node)uiComp.getNode()));
                    RequireJS requireJS = event.getRequestContext().getJavascriptManager().getRequireJS();
                    requireJS.require("SHARED/ecm-utils", "ecmutil").addScripts("ecmutil.ECMUtils.ajaxRedirect('" + downloadLink + "');");
                }
                catch (RepositoryException e) {
                    if (!LOG.isErrorEnabled()) break block2;
                    LOG.error((Object)"Repository cannot be found", (Throwable)e);
                }
            }
        }
    }
}

