/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.LicenseDetails;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ILicenseDetailsCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ILicenseDetailsCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.LicenseDetailsCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.LicenseDetailsCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.LicenseDetailsCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.LicenseDetailsRequestBuilder;

public class LicenseDetailsCollectionRequest
extends BaseCollectionRequest<LicenseDetailsCollectionResponse, ILicenseDetailsCollectionPage>
implements ILicenseDetailsCollectionRequest {
    public LicenseDetailsCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, LicenseDetailsCollectionResponse.class, ILicenseDetailsCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ILicenseDetailsCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(LicenseDetailsCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ILicenseDetailsCollectionPage get() throws ClientException {
        LicenseDetailsCollectionResponse response = (LicenseDetailsCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(LicenseDetails newLicenseDetails, ICallback<LicenseDetails> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new LicenseDetailsRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newLicenseDetails, callback);
    }

    @Override
    public LicenseDetails post(LicenseDetails newLicenseDetails) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new LicenseDetailsRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newLicenseDetails);
    }

    @Override
    public ILicenseDetailsCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ILicenseDetailsCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ILicenseDetailsCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ILicenseDetailsCollectionPage buildFromResponse(LicenseDetailsCollectionResponse response) {
        LicenseDetailsCollectionRequestBuilder builder = response.nextLink != null ? new LicenseDetailsCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        LicenseDetailsCollectionPage page = new LicenseDetailsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

