/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinKey;
import org.exoplatform.portal.resource.SkinVisitor;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.skin.XSkinService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WCMSkinVisitor
implements SkinVisitor {
    private void visit(Collection<SkinConfig> skins, Map.Entry<SkinKey, SkinConfig> entry) {
        String currentContext = WCMCoreUtils.getRepository().getConfiguration().getName();
        String cssPath = entry.getValue().getCSSPath();
        Map<String, String> params = XSkinService.getSkinParams(cssPath);
        if (cssPath.matches("/(.*)/css/jcr/(.*)/(.*)/(.*)/(.*).css") && !params.get("context").equals(currentContext)) {
            return;
        }
        skins.add(entry.getValue());
    }

    public Collection<SkinConfig> getSkins(Set<Map.Entry<SkinKey, SkinConfig>> portalSkins, Set<Map.Entry<SkinKey, SkinConfig>> skinConfigs) {
        String currentSkin = this.getCurrentSkin();
        String currentModuleName = this.getCurrentModuleName();
        ArrayList<SkinConfig> wcmSharedSkins = new ArrayList<SkinConfig>();
        for (Map.Entry<SkinKey, SkinConfig> entry : portalSkins) {
            String string = entry.getKey().getName();
            if (!string.equals(currentSkin)) continue;
            this.visit(wcmSharedSkins, entry);
        }
        ArrayList<SkinConfig> wcmSiteSkins = new ArrayList<SkinConfig>();
        for (Map.Entry entry : skinConfigs) {
            String module = ((SkinKey)entry.getKey()).getModule();
            String name = ((SkinKey)entry.getKey()).getName();
            if (!name.equals(currentSkin) || !module.equals(currentModuleName)) continue;
            this.visit(wcmSiteSkins, entry);
        }
        LinkedList<SkinConfig> skins = new LinkedList<SkinConfig>();
        Comparator<SkinConfig> comparator = new Comparator<SkinConfig>(){

            @Override
            public int compare(SkinConfig o1, SkinConfig o2) {
                return o1.getCSSPriority() - o2.getCSSPriority();
            }
        };
        Collections.sort(wcmSharedSkins, comparator);
        skins.addAll(wcmSharedSkins);
        Collections.sort(wcmSiteSkins, comparator);
        skins.addAll(wcmSiteSkins);
        return skins;
    }

    private String getCurrentModuleName() {
        String currentSiteName = Util.getUIPortal().getName();
        return XSkinService.createModuleName(currentSiteName);
    }

    private String getCurrentSkin() {
        return Util.getUIPortalApplication().getSkin();
    }
}

