/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UITagForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UITaggingForm;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, template="system:/groovy/portal/webui/container/UIContainer.gtmpl")
public class UITaggingFormContainer
extends UIContainer
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UITaggingFormContainer.class.getName());

    public void activate() {
        block2: {
            try {
                UITaggingForm uiForm = (UITaggingForm)this.addChild(UITaggingForm.class, null, null);
                uiForm.activate();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Unexpected error!", new Object[]{e.getMessage()});
            }
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ((UITaggingForm)this.getChild(UITaggingForm.class)).activate();
        super.processRender(context);
    }

    public void deActivate() {
    }

    private void initTaggingFormPopup(Node selectedTag) throws Exception {
        this.removeChildById("TagPopup");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "TagPopup");
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(600, 200);
        UITagForm uiForm = (UITagForm)this.createUIComponent(UITagForm.class, null, null);
        uiForm.setTag(selectedTag);
        uiPopup.setUIComponent((UIComponent)uiForm);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public Node getSelectedTag(String tagName) throws Exception {
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UITaggingForm uiTaggingForm = (UITaggingForm)this.getChild(UITaggingForm.class);
        String workspace = uiExplorer.getRepository().getConfiguration().getDefaultWorkspaceName();
        String userName = WCMCoreUtils.getRemoteUser();
        String tagScope = (String)uiTaggingForm.getUIFormSelectBox("tagScopes").getValue();
        int scope = uiTaggingForm.getIntValue(tagScope);
        uiExplorer.setTagScope(scope);
        String publicTagNodePath = nodeHierarchyCreator.getJcrPath("exoPublicTagNode");
        List tagList = scope == 0 ? newFolksonomyService.getAllPublicTags(publicTagNodePath, workspace) : newFolksonomyService.getAllPrivateTags(userName);
        for (Node tag : tagList) {
            if (!tag.getName().equals(tagName)) continue;
            return tag;
        }
        return null;
    }

    public void edit(Event<? extends UIComponent> event) throws Exception {
        UITaggingFormContainer uiTaggingFormContainer = this;
        String selectedName = event.getRequestContext().getRequestParameter("objectId");
        Node selectedTag = uiTaggingFormContainer.getSelectedTag(selectedName);
        uiTaggingFormContainer.initTaggingFormPopup(selectedTag);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTaggingFormContainer.getAncestorOfType(UIJCRExplorer.class);
        Preference preferences = uiExplorer.getPreference();
        if (preferences.isShowSideBar()) {
            UISideBar uiSideBar = (UISideBar)uiExplorer.findFirstComponentOfType(UISideBar.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSideBar);
        }
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaggingFormContainer);
    }

    public static class EditActionListener
    extends EventListener<UITaggingFormContainer> {
        public void execute(Event<UITaggingFormContainer> event) throws Exception {
            UITaggingFormContainer uiTaggingFormContainer = (UITaggingFormContainer)((Object)event.getSource());
            String selectedName = event.getRequestContext().getRequestParameter("objectId");
            Node selectedTag = uiTaggingFormContainer.getSelectedTag(selectedName);
            uiTaggingFormContainer.initTaggingFormPopup(selectedTag);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTaggingFormContainer.getAncestorOfType(UIJCRExplorer.class);
            Preference preferences = uiExplorer.getPreference();
            if (preferences.isShowSideBar()) {
                UISideBar uiSideBar = (UISideBar)uiExplorer.findFirstComponentOfType(UISideBar.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSideBar);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaggingFormContainer);
        }
    }
}

