/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.form;

import java.io.Serializable;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.services.pdfviewer.ObjectKey;
import org.exoplatform.services.pdfviewer.PDFViewerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class DialogFormActionListeners {

    public static class ChangeTabActionListener
    extends EventListener<UIDialogForm> {
        public void execute(Event<UIDialogForm> event) throws Exception {
            UIDialogForm uiForm = (UIDialogForm)((Object)event.getSource());
            uiForm.setSelectedTab(event.getRequestContext().getRequestParameter("objectId"));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class RemoveDataActionListener
    extends EventListener<UIDialogForm> {
        public void execute(Event<UIDialogForm> event) throws Exception {
            UIDialogForm uiForm = (UIDialogForm)((Object)event.getSource());
            String referenceNodePath = event.getRequestContext().getRequestParameter("objectId");
            uiForm.releaseLock();
            if (referenceNodePath.indexOf("$") > -1) {
                int index = referenceNodePath.indexOf("$");
                String removedNode = referenceNodePath.substring(index + 1);
                referenceNodePath = referenceNodePath.substring(0, index);
                if (StringUtils.isNotEmpty((String)removedNode)) {
                    Node currentNode = uiForm.getNode();
                    if (currentNode.isLocked()) {
                        Object[] args = new Object[]{currentNode.getPath()};
                        Utils.createPopupMessage((UIContainer)uiForm, "UIPermissionManagerGrid.msg.node-locked", args, 1);
                        return;
                    }
                    uiForm.addRemovedNode(removedNode);
                }
            }
            if (referenceNodePath.startsWith("/")) {
                Node referenceNode = (Node)uiForm.getSession().getItem(uiForm.getNodePath() + referenceNodePath);
                if (referenceNode.hasProperty("jcr:data")) {
                    uiForm.removeData(referenceNodePath);
                }
            } else {
                Node currentNode = uiForm.getNode();
                if (currentNode.isLocked()) {
                    Object[] args = new Object[]{currentNode.getPath()};
                    Utils.createPopupMessage((UIContainer)uiForm, "UIPermissionManagerGrid.msg.node-locked", args, 1);
                    return;
                }
                if (currentNode.hasProperty(referenceNodePath)) {
                    uiForm.removeData(referenceNodePath);
                }
            }
            this.clearPDFCached(uiForm.getNode());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }

        private void clearPDFCached(Node currentNode) throws Exception {
            PDFViewerService pdfViewerService = (PDFViewerService)WCMCoreUtils.getService(PDFViewerService.class);
            String wsName = currentNode.getSession().getWorkspace().getName();
            String repoName = WCMCoreUtils.getRepository().getConfiguration().getName();
            String uuid = currentNode.getUUID();
            StringBuilder bd = new StringBuilder();
            StringBuilder bd1 = new StringBuilder();
            bd.append(repoName).append("/").append(wsName).append("/").append(uuid);
            bd1.append((CharSequence)bd).append("/jcr:lastModified");
            pdfViewerService.getCache().remove((Serializable)new ObjectKey(bd.toString()));
            pdfViewerService.getCache().remove((Serializable)new ObjectKey(bd1.toString()));
        }
    }
}

