/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.service;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.model.Permission;
import org.exoplatform.services.attachments.plugin.AttachmentACLPlugin;
import org.exoplatform.services.attachments.service.AttachmentService;
import org.exoplatform.services.attachments.storage.AttachmentStorage;
import org.exoplatform.services.attachments.utils.EntityBuilder;
import org.exoplatform.services.attachments.utils.Utils;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.NewDocumentTemplate;
import org.exoplatform.services.cms.documents.NewDocumentTemplateProvider;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class AttachmentServiceImpl
implements AttachmentService {
    private static final Log LOG = ExoLogger.getExoLogger(AttachmentServiceImpl.class);
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private AttachmentStorage attachmentStorage;
    private DocumentService documentService;
    private IdentityManager identityManager;
    private ManageDriveService manageDriveService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private NodeFinder nodeFinder;
    private LinkManager linkManager;
    private Map<String, AttachmentACLPlugin> aclPlugins = new HashMap<String, AttachmentACLPlugin>();

    public AttachmentServiceImpl(AttachmentStorage attachmentStorage, RepositoryService repositoryService, SessionProviderService sessionProviderService, DocumentService documentService, IdentityManager identityManager, ManageDriveService manageDriveService, NodeHierarchyCreator nodeHierarchyCreator, NodeFinder nodeFinder, LinkManager linkManager) {
        this.attachmentStorage = attachmentStorage;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.documentService = documentService;
        this.identityManager = identityManager;
        this.manageDriveService = manageDriveService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.nodeFinder = nodeFinder;
        this.linkManager = linkManager;
    }

    @Override
    public Attachment linkAttachmentToEntity(long userIdentityId, long entityId, String entityType, String attachmentId) throws IllegalAccessException {
        if (entityId <= 0L) {
            throw new IllegalArgumentException("Entity Id must be positive");
        }
        if (StringUtils.isBlank((String)entityType)) {
            throw new IllegalArgumentException("Entity type is mandatory");
        }
        if (StringUtils.isBlank((String)attachmentId)) {
            throw new IllegalArgumentException("attachments Id must not be empty");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalAccessException("User identity must be positive");
        }
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalAccessException("User with name " + userIdentityId + " doesn't exist");
        }
        this.attachmentStorage.linkAttachmentToEntity(entityId, entityType, attachmentId);
        return this.getAttachmentByIdByEntity(entityType, entityId, attachmentId, userIdentityId);
    }

    @Override
    public void updateEntityAttachments(long userIdentityId, long entityId, String entityType, List<String> attachmentIds) throws IllegalAccessException, ObjectNotFoundException {
        List<Attachment> existingEntityAttachments;
        if (entityId <= 0L) {
            throw new IllegalArgumentException("Entity Id must be positive");
        }
        if (StringUtils.isEmpty((String)entityType)) {
            throw new IllegalArgumentException("Entity type is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalAccessException("User identity must be positive");
        }
        attachmentIds.forEach(attachmentId -> {
            if (StringUtils.isBlank((String)attachmentId)) {
                throw new IllegalArgumentException("attachmentId must not be empty");
            }
        });
        try {
            existingEntityAttachments = this.attachmentStorage.getAttachmentsByEntity(entityId, entityType);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't get attachments of entity with type " + entityType + " and id " + entityId, e);
        }
        List existingAttachmentsIds = existingEntityAttachments.stream().map(Attachment::getId).collect(Collectors.toList());
        if (attachmentIds.isEmpty()) {
            this.deleteAllEntityAttachments(userIdentityId, entityId, entityType);
        } else {
            for (String attachmentId2 : existingAttachmentsIds) {
                if (attachmentIds.contains(attachmentId2) || attachmentId2 == null) continue;
                this.deleteAttachmentItemById(userIdentityId, entityId, entityType, attachmentId2);
            }
        }
        if (attachmentIds != null && !attachmentIds.isEmpty()) {
            for (String attachmentId2 : attachmentIds) {
                if (existingAttachmentsIds.contains(attachmentId2) || !StringUtils.isNotEmpty((String)attachmentId2)) continue;
                this.linkAttachmentToEntity(userIdentityId, entityId, entityType, attachmentId2);
            }
        }
    }

    @Override
    public void deleteAllEntityAttachments(long userIdentityId, long entityId, String entityType) throws ObjectNotFoundException, IllegalAccessException {
        List<Attachment> existingEntityAttachments;
        if (entityId <= 0L) {
            throw new IllegalArgumentException("Entity Id must be positive");
        }
        if (StringUtils.isEmpty((String)entityType)) {
            throw new IllegalArgumentException("Entity type is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalAccessException("User identity must be positive");
        }
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        boolean canDetach = this.canDetach(userIdentityId, entityType, entityId, "");
        if (userIdentity == null || !canDetach) {
            throw new IllegalAccessException("User with name " + userIdentityId + " doesn't exist");
        }
        try {
            existingEntityAttachments = this.attachmentStorage.getAttachmentsByEntity(entityId, entityType);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't get attachments of entity with type " + entityType + " and id " + entityId, e);
        }
        List attachmentsIds = existingEntityAttachments.stream().map(Attachment::getId).collect(Collectors.toList());
        if (attachmentsIds.isEmpty()) {
            throw new ObjectNotFoundException("Entity with id " + entityId + " and type" + entityType + " has no attachment linked");
        }
        for (String attachmentId : attachmentsIds) {
            this.deleteAttachmentItemById(userIdentityId, entityId, entityType, attachmentId);
        }
    }

    @Override
    public void deleteAttachmentItemById(long userIdentityId, long entityId, String entityType, String attachmentId) throws ObjectNotFoundException, IllegalAccessException {
        if (entityId <= 0L) {
            throw new IllegalArgumentException("Entity Id must be positive");
        }
        if (StringUtils.isEmpty((String)entityType)) {
            throw new IllegalArgumentException("Entity type is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalAccessException("User identity must be positive");
        }
        if (StringUtils.isBlank((String)attachmentId)) {
            throw new IllegalAccessException("AttachmentId must not be empty");
        }
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        boolean canDetach = this.canDetach(userIdentityId, entityType, entityId, attachmentId);
        if (userIdentity == null || !canDetach) {
            throw new IllegalAccessException("User with name " + userIdentityId + " doesn't exist");
        }
        try {
            Attachment attachment = this.attachmentStorage.getAttachmentItemByEntity(entityId, entityType, attachmentId);
            if (attachment == null) {
                throw new ObjectNotFoundException("Attachment with id" + attachmentId + " linked to entity with id " + entityId + " and type" + entityType + " not found");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't get attachment with jcr uuid " + attachmentId + " of entity with type " + entityType + " and id " + entityId);
        }
        this.attachmentStorage.deleteAttachmentItemByIdByEntity(entityId, entityType, attachmentId);
    }

    @Override
    public List<Attachment> getAttachmentsByEntity(long userIdentityId, long entityId, String entityType) throws IllegalAccessException {
        List<Attachment> entityAttachments;
        if (entityId <= 0L) {
            throw new IllegalArgumentException("Entity Id should be positive");
        }
        if (StringUtils.isEmpty((String)entityType)) {
            throw new IllegalArgumentException("Entity type is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalAccessException("User identity must be positive");
        }
        try {
            entityAttachments = this.attachmentStorage.getAttachmentsByEntity(entityId, entityType);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't get attachments of entity with type " + entityType + " and id " + entityId, e);
        }
        if (!entityAttachments.isEmpty()) {
            entityAttachments.forEach(attachment -> {
                boolean canView = this.canView(userIdentityId, entityType, entityId, attachment.getId());
                boolean canEdit = this.canEdit(userIdentityId, entityType, entityId, attachment.getId());
                boolean canDetach = this.canDetach(userIdentityId, entityType, entityId, attachment.getId());
                Permission attachmentACL = new Permission(attachment.getAcl().isCanAccess(), canView, canDetach, canEdit);
                attachment.setAcl(attachmentACL);
            });
        }
        return entityAttachments;
    }

    @Override
    public Attachment getAttachmentByIdByEntity(String entityType, long entityId, String attachmentId, long userIdentityId) {
        Attachment attachment;
        Session session = null;
        try {
            session = Utils.getSession(this.sessionProviderService, this.repositoryService);
            attachment = EntityBuilder.fromAttachmentNode(this.repositoryService, this.documentService, this.linkManager, Utils.getCurrentWorkspace(this.repositoryService), session, attachmentId);
            boolean canView = this.canView(userIdentityId, entityType, entityId, attachment.getId());
            boolean canDetach = this.canDetach(userIdentityId, entityType, entityId, attachment.getId());
            boolean canEdit = this.canEdit(userIdentityId, entityType, entityId, attachment.getId());
            Permission attachmentACL = new Permission(attachment.getAcl().isCanAccess(), canView, canDetach, canEdit);
            attachment.setAcl(attachmentACL);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't convert attachment JCR node with id " + attachmentId + " to entity", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return attachment;
    }

    @Override
    public Attachment getAttachmentById(String attachmentId) throws ObjectNotFoundException {
        Session session = null;
        try {
            session = Utils.getSession(this.sessionProviderService, this.repositoryService);
            Attachment attachment = EntityBuilder.fromAttachmentNode(this.repositoryService, this.documentService, this.linkManager, Utils.getCurrentWorkspace(this.repositoryService), session, attachmentId);
            return attachment;
        }
        catch (ObjectNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't convert attachment JCR node with id " + attachmentId + " to entity", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public Attachment moveAttachmentToNewPath(long userIdentityId, String attachmentId, String newPathDrive, String newPath, String entityType, long entityId) throws IllegalAccessException {
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("User identity must be positive");
        }
        if (StringUtils.isEmpty((String)attachmentId)) {
            throw new IllegalArgumentException("Attachment id is mandatory");
        }
        if (StringUtils.isEmpty((String)newPathDrive)) {
            throw new IllegalArgumentException("New destination path's drive must not be empty");
        }
        if (!this.canEdit(userIdentityId, entityType, entityId, attachmentId)) {
            throw new IllegalAccessException("User with identity id" + userIdentityId + "is not allowed to move attachment with id" + attachmentId);
        }
        Session session = null;
        try {
            session = Utils.getSession(this.sessionProviderService, this.repositoryService);
            Node attachmentNode = session.getNodeByUUID(attachmentId);
            Node destNode = Utils.getParentFolderNode(session, this.manageDriveService, this.nodeHierarchyCreator, this.nodeFinder, newPathDrive, newPath);
            String destPath = destNode.getPath().concat("/").concat(attachmentNode.getName());
            session.move(attachmentNode.getPath(), destPath);
            session.save();
            Attachment attachment = EntityBuilder.fromAttachmentNode(this.repositoryService, this.documentService, this.linkManager, Utils.getCurrentWorkspace(this.repositoryService), session, attachmentId);
            return attachment;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while trying to move attachment node with id " + attachmentId + " to the new path " + newPath, e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public Attachment createNewDocument(Identity userIdentity, String title, String path, String pathDrive, String templateName) throws Exception {
        if (userIdentity == null) {
            throw new IllegalArgumentException("User identity is mandatory");
        }
        if (StringUtils.isEmpty((String)title)) {
            throw new IllegalArgumentException("New document title is mandatory");
        }
        if (StringUtils.isEmpty((String)path)) {
            throw new IllegalArgumentException("new document path is mandatory");
        }
        if (StringUtils.isEmpty((String)pathDrive)) {
            throw new IllegalArgumentException("new document path's drive is mandatory");
        }
        if (StringUtils.isEmpty((String)templateName)) {
            throw new IllegalArgumentException("template name is mandatory");
        }
        Session session = null;
        try {
            session = Utils.getSession(this.sessionProviderService, this.repositoryService);
            Node currentNode = Utils.getParentFolderNode(session, this.manageDriveService, this.nodeHierarchyCreator, this.nodeFinder, pathDrive, path);
            if (currentNode.hasNode(title)) {
                throw new ItemExistsException("Document with the same name " + title + " already exist in this current path");
            }
            List<NewDocumentTemplate> documentTemplates = this.getDocumentTemplateList(userIdentity);
            NewDocumentTemplate documentTemplate = documentTemplates.stream().filter(template -> template.getName().equals(templateName)).findFirst().orElse(null);
            if (documentTemplate != null) {
                Node createdDocument = this.documentService.createDocumentFromTemplate(currentNode, title, documentTemplate);
                session.save();
                Attachment attachment = EntityBuilder.fromAttachmentNode(this.repositoryService, this.documentService, this.linkManager, Utils.getCurrentWorkspace(this.repositoryService), session, createdDocument.getUUID());
                boolean canView = this.checkAttachmentJCRPermission(attachment.getId(), "read");
                boolean canDetach = this.checkAttachmentJCRPermission(attachment.getId(), "remove");
                boolean canEdit = this.checkAttachmentJCRPermission(attachment.getId(), "set_property");
                Permission attachmentACL = new Permission(attachment.getAcl().isCanAccess(), canView, canDetach, canEdit);
                attachment.setAcl(attachmentACL);
                Attachment attachment2 = attachment;
                return attachment2;
            }
            try {
                throw new IllegalStateException("Document template not available with " + templateName + " as a name");
            }
            catch (Exception e) {
                LOG.error((Object)"Error while trying to create a new document", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private List<NewDocumentTemplate> getDocumentTemplateList(Identity identity) {
        ArrayList<NewDocumentTemplate> options = new ArrayList<NewDocumentTemplate>();
        List<NewDocumentTemplateProvider> templateProviders = this.documentService.getNewDocumentTemplateProviders();
        templateProviders.forEach(provider -> {
            if (provider.getEditor().isAvailableForUser(identity)) {
                options.addAll(provider.getTemplates());
            }
        });
        return options;
    }

    public void addACLPlugin(AttachmentACLPlugin aclPlugin) {
        this.aclPlugins.put(aclPlugin.getEntityType(), aclPlugin);
    }

    public boolean canView(long userIdentityId, String entityType, long entityId, String attachmentId) {
        AttachmentACLPlugin attachmentACLPlugin = this.aclPlugins.get(entityType);
        boolean jcrViewPermission = true;
        if (!StringUtils.isBlank((String)attachmentId)) {
            jcrViewPermission = this.checkAttachmentJCRPermission(attachmentId, "read");
        }
        if (attachmentACLPlugin == null) {
            return jcrViewPermission;
        }
        return jcrViewPermission && attachmentACLPlugin.canView(userIdentityId, entityType, String.valueOf(entityId));
    }

    public boolean canDetach(long userIdentityId, String entityType, long entityId, String attachmentId) {
        AttachmentACLPlugin attachmentACLPlugin = this.aclPlugins.get(entityType);
        boolean jcrDeletePermission = true;
        if (!StringUtils.isBlank((String)attachmentId)) {
            jcrDeletePermission = this.checkAttachmentJCRPermission(attachmentId, "remove");
        }
        if (attachmentACLPlugin == null) {
            return jcrDeletePermission;
        }
        return attachmentACLPlugin.canDetach(userIdentityId, entityType, String.valueOf(entityId));
    }

    public boolean canEdit(long userIdentityId, String entityType, long entityId, String attachmentId) {
        AttachmentACLPlugin attachmentACLPlugin = this.aclPlugins.get(entityType);
        boolean jcrEditPermission = true;
        if (!StringUtils.isBlank((String)attachmentId)) {
            jcrEditPermission = this.checkAttachmentJCRPermission(attachmentId, "set_property");
        }
        if (attachmentACLPlugin == null) {
            return jcrEditPermission;
        }
        return jcrEditPermission && attachmentACLPlugin.canEdit(userIdentityId, entityType, String.valueOf(entityId));
    }

    private boolean checkAttachmentJCRPermission(String attachmentId, String permissionType) {
        boolean attachmentPermission = true;
        try {
            Session session = Utils.getSession(this.sessionProviderService, this.repositoryService);
            Node attachmentNode = session.getNodeByUUID(attachmentId);
            session.checkPermission(attachmentNode.getPath(), permissionType);
        }
        catch (AccessControlException | AccessDeniedException e) {
            attachmentPermission = false;
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Can't get attachment node with id" + attachmentId, e);
        }
        return attachmentPermission;
    }
}

