/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataType;

public class FavoriteServiceImpl
implements FavoriteService {
    private IdentityManager identityManager;
    private org.exoplatform.social.metadata.favorite.FavoriteService favoriteService;
    private MetadataService metadataService;
    private SessionProviderService sessionProviderService;
    private RepositoryService repositoryService;
    private static final Log LOG = ExoLogger.getLogger(FavoriteServiceImpl.class);
    public static final MetadataType METADATA_TYPE = new MetadataType(1L, "favorites");

    public FavoriteServiceImpl(IdentityManager identityManager, org.exoplatform.social.metadata.favorite.FavoriteService favoriteService, MetadataService metadataService, SessionProviderService sessionProviderService, RepositoryService repositoryService) {
        this.identityManager = identityManager;
        this.favoriteService = favoriteService;
        this.metadataService = metadataService;
        this.sessionProviderService = sessionProviderService;
        this.repositoryService = repositoryService;
    }

    @Override
    public void addFavorite(Node node, String userName) throws Exception {
        Identity identity = this.identityManager.getOrCreateUserIdentity(userName);
        if (identity != null) {
            Favorite favorite = new Favorite("file", node.getUUID(), "", Long.parseLong(identity.getId()));
            this.favoriteService.createFavorite(favorite);
        }
    }

    @Override
    public List<Node> getAllFavoriteNodesByUser(String userName, int limit) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        Identity identity = this.identityManager.getOrCreateUserIdentity(userName);
        if (identity != null) {
            SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            List favorites = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(String.valueOf(identity.getId()), METADATA_TYPE.getName(), "file", 0L, (long)limit);
            for (MetadataItem favorite : favorites) {
                try {
                    Node node = session.getNodeByUUID(favorite.getObjectId());
                    if (node == null) continue;
                    ret.add(node);
                }
                catch (RepositoryException repositoryException) {
                    LOG.warn("Can't get Favorite Node with UIID {}", new Object[]{favorite.getObjectId()});
                }
            }
        }
        return ret;
    }

    @Override
    public void removeFavorite(Node node, String userName) throws Exception {
        Identity identity = this.identityManager.getOrCreateUserIdentity(userName);
        Favorite favorite = new Favorite("file", node.getUUID(), "", Long.parseLong(identity.getId()));
        this.favoriteService.deleteFavorite(favorite);
    }

    @Override
    public boolean isFavoriter(String userName, Node node) throws Exception {
        try {
            Identity identity = this.identityManager.getOrCreateUserIdentity(userName);
            Favorite favorite = new Favorite("file", node.getUUID(), "", Long.parseLong(identity.getId()));
            return this.favoriteService.isFavorite(favorite);
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot get the identifier of the node");
            return false;
        }
    }
}

