/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.fastcontentcreator.config.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.wcm.webui.fastcontentcreator.UIFCCPortlet;
import org.exoplatform.wcm.webui.fastcontentcreator.UIFCCUtils;
import org.exoplatform.wcm.webui.fastcontentcreator.config.UIFCCConfig;
import org.exoplatform.wcm.webui.fastcontentcreator.config.action.UIFCCActionContainer;
import org.exoplatform.wcm.webui.fastcontentcreator.config.action.UIFCCActionForm;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/FastContentCreatorPortlet/UIFCCActionTypeForm.gtmpl", events={@EventConfig(listeners={ChangeActionTypeActionListener.class})})
public class UIFCCActionTypeForm
extends UIForm {
    public static final String ACTION_TYPE = "actionType";
    public static final String CHANGE_ACTION = "ChangeActionType";
    private List<SelectItemOption<String>> typeList_ = new ArrayList<SelectItemOption<String>>();
    private String nodePath = null;
    public String defaultActionType_;

    public UIFCCActionTypeForm() throws Exception {
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(ACTION_TYPE, ACTION_TYPE, new ArrayList());
        uiSelectBox.setOnChange(CHANGE_ACTION);
        this.addUIFormInput((UIFormInput)uiSelectBox);
    }

    private Iterator<NodeType> getCreatedActionTypes() throws Exception {
        ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        return actionService.getCreatedActionTypes(UIFCCUtils.getPreferenceRepository()).iterator();
    }

    public void setDefaultActionType() throws Exception {
        boolean isNews = true;
        UIFCCPortlet fastContentCreatorPortlet = (UIFCCPortlet)this.getAncestorOfType(UIFCCPortlet.class);
        UIFCCConfig fastContentCreatorConfig = (UIFCCConfig)fastContentCreatorPortlet.getChild(UIFCCConfig.class);
        Node savedLocationNode = fastContentCreatorConfig.getSavedLocationNode();
        UIFCCActionContainer fastContentCreatorActionContainer = (UIFCCActionContainer)this.getParent();
        UIFCCActionForm fastContentCreatorActionForm = (UIFCCActionForm)fastContentCreatorActionContainer.getChild(UIFCCActionForm.class);
        if (this.defaultActionType_ == null) {
            this.defaultActionType_ = "exo:addMetadataAction";
            isNews = true;
        } else {
            isNews = false;
        }
        fastContentCreatorActionForm.setNodePath(this.nodePath);
        this.getUIFormSelectBox(ACTION_TYPE).setValue(this.defaultActionType_).setDisabled(!isNews);
        fastContentCreatorActionForm.createNewAction(savedLocationNode, this.defaultActionType_, isNews);
        fastContentCreatorActionForm.setWorkspace(savedLocationNode.getSession().getWorkspace().getName());
        fastContentCreatorActionForm.setStoredPath(savedLocationNode.getPath());
    }

    public void update() throws Exception {
        Iterator<NodeType> actions = this.getCreatedActionTypes();
        while (actions.hasNext()) {
            String action = actions.next().getName();
            this.typeList_.add((SelectItemOption<String>)new SelectItemOption(action, (Object)action));
        }
        this.getUIFormSelectBox(ACTION_TYPE).setOptions(this.typeList_);
        this.setDefaultActionType();
    }

    public void init(String nodePath, String actionType) throws RepositoryException {
        this.nodePath = nodePath;
        this.defaultActionType_ = actionType;
    }

    public static class ChangeActionTypeActionListener
    extends EventListener<UIFCCActionTypeForm> {
        public void execute(Event<UIFCCActionTypeForm> event) throws Exception {
            UIFCCActionTypeForm fastContentCreatorActionTypeForm = (UIFCCActionTypeForm)((Object)event.getSource());
            UIFCCPortlet fastContentCreatorPortlet = (UIFCCPortlet)fastContentCreatorActionTypeForm.getAncestorOfType(UIFCCPortlet.class);
            UIFCCConfig fastContentCreatorConfig = (UIFCCConfig)fastContentCreatorPortlet.getChild(UIFCCConfig.class);
            Node currentNode = fastContentCreatorConfig.getSavedLocationNode();
            String actionType = (String)fastContentCreatorActionTypeForm.getUIFormSelectBox(UIFCCActionTypeForm.ACTION_TYPE).getValue();
            TemplateService templateService = (TemplateService)fastContentCreatorActionTypeForm.getApplicationComponent(TemplateService.class);
            String userName = Util.getPortalRequestContext().getRemoteUser();
            UIApplication uiApp = (UIApplication)fastContentCreatorActionTypeForm.getAncestorOfType(UIApplication.class);
            try {
                String templatePath = templateService.getTemplatePathByUser(true, actionType, userName);
                if (templatePath == null) {
                    Object[] arg = new Object[]{actionType};
                    uiApp.addMessage(new ApplicationMessage("UIFastContentCreatorActionTypeForm.msg.access-denied", arg, 1));
                    actionType = "exo:addMetadataAction";
                    fastContentCreatorActionTypeForm.getUIFormSelectBox(UIFCCActionTypeForm.ACTION_TYPE).setValue(actionType);
                    UIFCCActionContainer fastContentCreatorActionContainer = (UIFCCActionContainer)fastContentCreatorActionTypeForm.getAncestorOfType(UIFCCActionContainer.class);
                    UIFCCActionForm fastContentCreatorActionForm = (UIFCCActionForm)fastContentCreatorActionContainer.getChild(UIFCCActionForm.class);
                    fastContentCreatorActionForm.createNewAction(currentNode, actionType, true);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)fastContentCreatorActionContainer);
                    return;
                }
            }
            catch (PathNotFoundException path) {
                Object[] arg = new Object[]{actionType};
                uiApp.addMessage(new ApplicationMessage("UIFastContentCreatorActionTypeForm.msg.not-support", arg, 1));
                actionType = "exo:addMetadataAction";
                fastContentCreatorActionTypeForm.getUIFormSelectBox(UIFCCActionTypeForm.ACTION_TYPE).setValue(actionType);
                UIFCCActionContainer fastContentCreatorActionContainer = (UIFCCActionContainer)fastContentCreatorActionTypeForm.getAncestorOfType(UIFCCActionContainer.class);
                UIFCCActionForm fastContentCreatorActionForm = (UIFCCActionForm)fastContentCreatorActionContainer.getChild(UIFCCActionForm.class);
                fastContentCreatorActionForm.createNewAction(currentNode, actionType, true);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)fastContentCreatorActionContainer);
            }
            UIFCCActionContainer fastContentCreatorActionContainer = (UIFCCActionContainer)fastContentCreatorActionTypeForm.getParent();
            UIFCCActionForm uiActionForm = (UIFCCActionForm)fastContentCreatorActionContainer.getChild(UIFCCActionForm.class);
            uiActionForm.createNewAction(currentNode, actionType, true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)fastContentCreatorActionContainer);
        }
    }
}

