/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.ProfilePhoto;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IProfilePhotoCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IProfilePhotoCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ProfilePhotoCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ProfilePhotoCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ProfilePhotoCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ProfilePhotoRequestBuilder;

public class ProfilePhotoCollectionRequest
extends BaseCollectionRequest<ProfilePhotoCollectionResponse, IProfilePhotoCollectionPage>
implements IProfilePhotoCollectionRequest {
    public ProfilePhotoCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ProfilePhotoCollectionResponse.class, IProfilePhotoCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IProfilePhotoCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ProfilePhotoCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IProfilePhotoCollectionPage get() throws ClientException {
        ProfilePhotoCollectionResponse response = (ProfilePhotoCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ProfilePhoto newProfilePhoto, ICallback<ProfilePhoto> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ProfilePhotoRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newProfilePhoto, callback);
    }

    @Override
    public ProfilePhoto post(ProfilePhoto newProfilePhoto) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ProfilePhotoRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newProfilePhoto);
    }

    @Override
    public IProfilePhotoCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IProfilePhotoCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IProfilePhotoCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IProfilePhotoCollectionPage buildFromResponse(ProfilePhotoCollectionResponse response) {
        ProfilePhotoCollectionRequestBuilder builder = response.nextLink != null ? new ProfilePhotoCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ProfilePhotoCollectionPage page = new ProfilePhotoCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

