/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.filters;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.filters.AbstractCloudDriveNodeFilter;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.CloudDriveStorage;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;

public class LocalNodeFilter
extends AbstractCloudDriveNodeFilter {
    protected static final Log LOG = ExoLogger.getLogger(LocalNodeFilter.class);

    protected boolean accept(Node node) throws RepositoryException {
        block4: {
            CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
            CloudDrive drive = driveService.findDrive(node);
            if (drive != null && this.acceptProvider(drive.getUser().getProvider())) {
                try {
                    if (((CloudDriveStorage)drive).isLocal(node)) {
                        WebuiRequestContext.getCurrentInstance().setAttribute(CloudDrive.class, (Object)drive);
                        return true;
                    }
                }
                catch (DriveRemovedException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)(">> LocalNodeFilter.accept(" + node.getPath() + ") drive removed " + drive + ": " + e.getMessage()));
                }
            }
        }
        return false;
    }
}

