/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Path(value="/contents/rename/")
public class RenameConnector
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)RenameConnector.class.getName());
    private static final Pattern FILE_EXPLORER_URL_SYNTAX = Pattern.compile("([^:/]+):(/.*)");
    private static final String RELATION_PROP = "exo:relation";
    private static final String DEFAULT_NAME = "untitled";

    @GET
    @Path(value="/getObjectId/")
    public Response getObjectId(@QueryParam(value="nodePath") String nodePath) throws Exception {
        return Response.ok((Object)Utils.getObjectId((String)nodePath), (String)"text/plain").build();
    }

    @GET
    @Path(value="/rename/")
    @RolesAllowed(value={"users"})
    public Response rename(@QueryParam(value="oldPath") String oldPath, @QueryParam(value="newTitle") String newTitle) throws Exception {
        block19: {
            try {
                if (StringUtils.isBlank((String)newTitle)) {
                    return Response.status((int)400).build();
                }
                String newExoTitle = newTitle;
                String newName = Text.escapeIllegalJcrChars((String)Utils.cleanString((String)newTitle));
                newName = Utils.cleanName((String)newName);
                newName = StringUtils.isEmpty((String)(newName = URLDecoder.decode(newName, "UTF-8"))) ? DEFAULT_NAME : newName;
                String[] workspaceAndPath = this.parseWorkSpaceNameAndNodePath(oldPath);
                Node renamedNode = (Node)((NodeFinder)WCMCoreUtils.getService(NodeFinder.class)).getItem(this.getSession(workspaceAndPath[0]), workspaceAndPath[1], false);
                String oldName = renamedNode.getName();
                if (oldName.indexOf(46) != -1 && renamedNode.isNodeType("nt:file")) {
                    String ext = oldName.substring(oldName.lastIndexOf(46));
                    newName = newName.concat(ext);
                    newExoTitle = newExoTitle.concat(ext);
                }
                String oldExoTitle = renamedNode.hasProperty("exo:title") ? renamedNode.getProperty("exo:title").getString() : "";
                CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);
                cmsService.getPreProperties().clear();
                String nodeUUID = "";
                if (renamedNode.isNodeType("mix:referenceable")) {
                    nodeUUID = renamedNode.getUUID();
                }
                cmsService.getPreProperties().put(nodeUUID + "_exo:title", oldExoTitle);
                if (renamedNode.getName().equals(newName) && oldExoTitle.equals(newExoTitle)) {
                    return Response.status((int)400).build();
                }
                if (!this.canEditLockedNode(renamedNode)) {
                    return Response.status((int)400).build();
                }
                if (renamedNode.canAddMixin("mix:referenceable")) {
                    renamedNode.addMixin("mix:referenceable");
                    renamedNode.save();
                }
                String uuid = renamedNode.getUUID();
                Session nodeSession = renamedNode.getSession();
                if (!renamedNode.getName().equals(newName)) {
                    ArrayList<Node> refList = new ArrayList<Node>();
                    PropertyIterator references = renamedNode.getReferences();
                    RelationsService relationsService = (RelationsService)WCMCoreUtils.getService(RelationsService.class);
                    while (references.hasNext()) {
                        Property pro = references.nextProperty();
                        Node refNode = pro.getParent();
                        if (!refNode.hasProperty(RELATION_PROP)) continue;
                        refList.add(refNode);
                        relationsService.removeRelation(refNode, renamedNode.getPath());
                    }
                    Node parent = renamedNode.getParent();
                    String srcPath = renamedNode.getPath();
                    String destPath = (parent.getPath().equals("/") ? "" : parent.getPath()) + "/" + newName;
                    this.addLockToken(renamedNode.getParent());
                    nodeSession.getWorkspace().move(srcPath, destPath);
                    Node destNode = nodeSession.getNodeByUUID(uuid);
                    for (Node addRef : refList) {
                        relationsService.addRelation(addRef, destNode.getPath(), nodeSession.getWorkspace().getName());
                    }
                    if (destNode.isLocked()) {
                        ((LockService)WCMCoreUtils.getService(LockService.class)).changeLockToken(renamedNode, destNode);
                    }
                    this.changeLockForChild(srcPath, destNode);
                    if (destNode.canAddMixin("exo:modify")) {
                        destNode.addMixin("exo:modify");
                    }
                    destNode.setProperty("exo:lastModifier", nodeSession.getUserID());
                    if (renamedNode.canAddMixin("exo:sortable")) {
                        renamedNode.addMixin("exo:sortable");
                    }
                    renamedNode.setProperty("exo:name", renamedNode.getName());
                    renamedNode = destNode;
                }
                if (!renamedNode.hasProperty("exo:title")) {
                    renamedNode.addMixin("exo:rss-enable");
                }
                renamedNode.setProperty("exo:title", newExoTitle);
                nodeSession.save();
                WCMPublicationService publicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
                if (publicationService.isEnrolledInWCMLifecycle(renamedNode)) {
                    ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
                    listenerService.broadcast("CmsService.event.postEdit", (Object)this, (Object)renamedNode);
                }
                return Response.ok((Object)uuid).build();
            }
            catch (LockException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"The node or parent node is locked. Rename is not successful!");
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Rename is not successful!", (Throwable)e);
                }
                if (!LOG.isWarnEnabled()) break block19;
                LOG.warn((Object)"Rename is not successful!");
            }
        }
        return Response.status((int)400).build();
    }

    private void changeLockForChild(String srcPath, Node parentNewNode) throws Exception {
        if (parentNewNode.hasNodes()) {
            NodeIterator newNodeIter = parentNewNode.getNodes();
            String newSRCPath = null;
            while (newNodeIter.hasNext()) {
                Node newChildNode = newNodeIter.nextNode();
                newSRCPath = newChildNode.getPath().replace(parentNewNode.getPath(), srcPath);
                if (newChildNode.isLocked()) {
                    ((LockService)WCMCoreUtils.getService(LockService.class)).changeLockToken(newSRCPath, newChildNode);
                }
                if (!newChildNode.hasNodes()) continue;
                this.changeLockForChild(newSRCPath, newChildNode);
            }
        }
    }

    private boolean canEditLockedNode(Node node) throws Exception {
        LockService lockService = (LockService)WCMCoreUtils.getService(LockService.class);
        if (!node.isLocked()) {
            return true;
        }
        String lockToken = lockService.getLockTokenOfUser(node);
        if (lockToken != null) {
            node.getSession().addLockToken(lockService.getLockToken(node));
            return true;
        }
        return false;
    }

    private void addLockToken(Node node) throws Exception {
        String lockToken;
        if (node.isLocked() && (lockToken = ((LockService)WCMCoreUtils.getService(LockService.class)).getLockToken(node)) != null) {
            node.getSession().addLockToken(lockToken);
        }
    }

    private String[] parseWorkSpaceNameAndNodePath(String nodePath) {
        Matcher matcher = FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
        if (!matcher.find()) {
            return null;
        }
        String[] workSpaceNameAndNodePath = new String[]{matcher.group(1), matcher.group(2)};
        return workSpaceNameAndNodePath;
    }

    private Session getSession(String workspaceName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        return sessionProvider.getSession(workspaceName, WCMCoreUtils.getRepository());
    }
}

