/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.ResourceConfig;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public abstract class BaseResourceLoaderService
implements Startable {
    protected NodeHierarchyCreator nodeHierarchyCreator_;
    protected RepositoryService repositoryService_;
    protected ConfigurationManager cservice_;
    protected ExoCache<String, CmsScript> resourceCache_;
    private ActivityCommonService activityService = null;
    private static final String EDITED_CONFIGURED_SCRIPTS = "EditedConfiguredScripts";
    private static final String CACHE_NAME = "ecms.BaseResourceCache";
    private DMSConfiguration dmsConfiguration_;

    public BaseResourceLoaderService(ConfigurationManager cservice, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService, CacheService cacheService, DMSConfiguration dmsConfiguration) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repositoryService;
        this.cservice_ = cservice;
        this.resourceCache_ = cacheService.getCacheInstance(CACHE_NAME);
        this.dmsConfiguration_ = dmsConfiguration;
    }

    protected abstract String getBasePath();

    protected abstract void removeFromCache(String var1);

    public void start() {
    }

    public void stop() {
    }

    protected void init(Session session, ResourceConfig resourceConfig, String location) throws Exception {
        this.addScripts(session, resourceConfig.getRessources(), location);
    }

    protected void addScripts(Session session, List<ResourceConfig.Resource> resources, String location) throws Exception {
        String resourcesPath = this.getBasePath();
        if (resources.size() == 0) {
            return;
        }
        try {
            String firstResourceName = resources.get(0).getName();
            session.getItem(resourcesPath + "/" + firstResourceName);
            return;
        }
        catch (PathNotFoundException e) {
            Node resourcesHome = (Node)session.getItem(resourcesPath);
            String warPath = location + resourcesPath.substring(resourcesPath.lastIndexOf("/"));
            for (ResourceConfig.Resource resource : resources) {
                String name = resource.getName();
                if (Utils.getAllEditedConfiguredData(this.getClass().getSimpleName(), EDITED_CONFIGURED_SCRIPTS, true).contains(name)) continue;
                String description = resource.getDescription();
                String path = warPath + "/" + name;
                InputStream in = this.cservice_.getInputStream(path);
                this.addResource(resourcesHome, name, description, in);
            }
            resourcesHome.save();
            return;
        }
    }

    public void addResource(Node resourcesHome, String resourceName, InputStream in) throws Exception {
        this.addResource(resourcesHome, resourceName, resourceName, in);
    }

    public void addResource(Node resourcesHome, String resourceName, String resourceDescription, InputStream in) throws Exception {
        Node contentNode = null;
        if (resourceName.lastIndexOf("/") > -1) {
            Node parentResource;
            String realParenPath = StringUtils.substringBeforeLast((String)resourceName, (String)"/");
            resourcesHome = parentResource = resourcesHome.getNode(realParenPath);
            resourceName = StringUtils.substringAfterLast((String)resourceName, (String)"/");
        }
        Node script = null;
        try {
            script = resourcesHome.getNode(resourceName);
            contentNode = script.getNode("jcr:content");
            if (!contentNode.isCheckedOut()) {
                contentNode.checkout();
            }
        }
        catch (PathNotFoundException e) {
            script = resourcesHome.addNode(resourceName, "nt:file");
            contentNode = script.addNode("jcr:content", "exo:resources");
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:mimeType", "application/x-groovy");
        }
        if (this.activityService == null) {
            this.activityService = WCMCoreUtils.getService(ActivityCommonService.class);
        }
        this.activityService.setCreating(script, true);
        contentNode.setProperty("jcr:data", in);
        contentNode.setProperty("dc:description", new String[]{resourceDescription});
        contentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        this.activityService.setCreating(script, false);
        resourcesHome.save();
    }

    protected Node getResourcesHome(SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = null;
        manageableRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        Session session = sessionProvider.getSession(dmsRepoConfig.getSystemWorkspace(), manageableRepository);
        String resourcesPath = this.getBasePath();
        return (Node)session.getItem(resourcesPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceAsText(String resourceName) throws Exception {
        try (SessionProvider systemProvider = SessionProvider.createSystemProvider();){
            String text;
            Node resourceNode = this.getResourceByName(systemProvider, resourceName);
            String string = text = resourceNode.getNode("jcr:content").getProperty("jcr:data").getString();
            return string;
        }
    }

    public Node getResourceByName(SessionProvider systemProvider, String resourceName) throws Exception {
        Node resourcesHome = this.getResourcesHome(systemProvider);
        return resourcesHome.getNode(resourceName);
    }

    public String getResourceNameByNodeType(NodeType nodeType) throws Exception {
        if (nodeType.isNodeType("exo:scriptAction")) {
            PropertyDefinition[] arrProperties;
            for (PropertyDefinition property : arrProperties = nodeType.getPropertyDefinitions()) {
                if (!property.getName().equals("exo:script")) continue;
                return property.getDefaultValues()[0].getString();
            }
        }
        return "";
    }

    public NodeType getNodeTypeByResourceName(String resourceName) throws Exception {
        ActionServiceContainer actionsServiceContainer = WCMCoreUtils.getService(ActionServiceContainer.class);
        Collection<NodeType> actionList = actionsServiceContainer.getCreatedActionTypes(WCMCoreUtils.getRepository().getConfiguration().getName());
        for (NodeType nodeType : actionList) {
            PropertyDefinition[] arrProperties;
            if (!nodeType.isNodeType("exo:scriptAction")) continue;
            for (PropertyDefinition property : arrProperties = nodeType.getPropertyDefinitions()) {
                if (!property.getName().equals("exo:script") || !property.getDefaultValues()[0].getString().equals(resourceName)) continue;
                return nodeType;
            }
        }
        return null;
    }

    public String getResourceDescription(String resourceName) throws Exception {
        Node resource = this.getResourceByName(WCMCoreUtils.getSystemSessionProvider(), resourceName);
        return resource.getNode("jcr:content").getProperty("dc:description").getValues()[0].getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String resourceName) throws Exception {
        try (SessionProvider systemProvider = SessionProvider.createSystemProvider();){
            InputStream stream;
            Node resourceNode = this.getResourceByName(systemProvider, resourceName);
            InputStream inputStream = stream = resourceNode.getNode("jcr:content").getProperty("jcr:data").getStream();
            return inputStream;
        }
    }

    public NodeIterator getResources(SessionProvider sessionProvider) throws Exception {
        Node resourcesHome = this.getResourcesHome(sessionProvider);
        return resourcesHome.getNodes();
    }

    public boolean hasResources(SessionProvider sessionProvider) throws Exception {
        Node resourcesHome = this.getResourcesHome(sessionProvider);
        return resourcesHome.hasNodes();
    }

    public void addResource(String name, String text, SessionProvider provider) throws Exception {
        Node resourcesHome = this.getResourcesHome(provider);
        ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());
        this.addResource(resourcesHome, name, in);
        resourcesHome.save();
    }

    public void removeResource(String resourceName, SessionProvider provider) throws Exception {
        this.removeFromCache(resourceName);
        Node resourcesHome = this.getResourcesHome(provider);
        Node resource2remove = resourcesHome.getNode(resourceName);
        resource2remove.remove();
        resourcesHome.save();
    }
}

