/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.filters;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.filters.AbstractCloudDriveNodeFilter;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.NotCloudDriveException;
import org.exoplatform.services.cms.clouddrives.NotCloudFileException;
import org.exoplatform.services.cms.clouddrives.NotYetCloudFileException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NotCloudDriveOrFileFilter
extends AbstractCloudDriveNodeFilter {
    protected static final Log LOG = ExoLogger.getLogger(NotCloudDriveOrFileFilter.class);

    protected boolean accept(Node node) throws RepositoryException {
        block11: {
            CloudDriveService driveService;
            CloudDrive drive;
            if (node != null && (drive = (driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class)).findDrive(node)) != null) {
                try {
                    if (this.acceptProvider(drive.getUser().getProvider())) {
                        if (drive.getPath().equals(node.getPath())) {
                            return false;
                        }
                        drive.getFile(node.getPath());
                        return false;
                    }
                }
                catch (DriveRemovedException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> NotCloudDriveOrFileFilter.accept(" + node.getPath() + ") drive removed " + drive + ": " + e.getMessage()));
                    }
                    return false;
                }
                catch (NotYetCloudFileException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> NotCloudDriveOrFileFilter.accept(" + node.getPath() + ") not yet cloud file: " + e.getMessage()));
                    }
                    return false;
                }
                catch (NotCloudFileException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> NotCloudDriveOrFileFilter.accept(" + node.getPath() + ") not cloud file: " + e.getMessage()));
                    }
                }
                catch (NotCloudDriveException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug((Object)(">> NotCloudDriveOrFileFilter.accept(" + node.getPath() + ") not in cloud drive: " + e.getMessage()));
                }
            }
        }
        return true;
    }
}

