/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.authoring;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.extensions.security.SHAMessageDigester;

@Path(value="/copyfile/")
public class CopyContentFile
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)CopyContentFile.class.getName());
    private static final String OK_RESPONSE = "OK";
    private static final String KO_RESPONSE = "KO";
    private String stagingStorage;
    private String targetKey;
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    public CopyContentFile(InitParams params) {
        this.stagingStorage = params.getValueParam("stagingStorage").getValue();
        this.targetKey = params.getValueParam("targetKey").getValue();
    }

    @POST
    @Path(value="/copy/")
    public Response copyFile(String param) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Start Execute CopyContentFile Web Service");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        try {
            long time;
            String[] tabParam = param.split("&&");
            String timesTamp = tabParam[0].split("=")[1];
            String clientHash = tabParam[1].split("=")[1];
            String contents = tabParam[2].split("contentsfile=")[1];
            String[] tab = this.targetKey.split("$TIMESTAMP");
            StringBuffer resultKey = new StringBuffer();
            for (int k = 0; k < tab.length; ++k) {
                resultKey.append(tab[k]);
                if (k == tab.length - 1) continue;
                resultKey.append(timesTamp);
            }
            String serverHash = SHAMessageDigester.getHash(resultKey.toString());
            if (serverHash != null && serverHash.equals(clientHash)) {
                Date date = new Date();
                time = date.getTime();
                File stagingFolder = new File(this.stagingStorage);
                if (!stagingFolder.exists()) {
                    stagingFolder.mkdirs();
                }
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Anthentification failed...");
                }
                return Response.ok((Object)"KO...Anthentification failed", (String)"text/plain").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
            File contentsFile = new File(this.stagingStorage + File.separator + clientHash + "-" + time + ".xml");
            FileOutputStream ops = new FileOutputStream(contentsFile);
            ((OutputStream)ops).write(contents.getBytes());
            ((OutputStream)ops).close();
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("error when copying content file" + ex.getMessage()));
            }
            return Response.ok((Object)("KO..." + ex.getMessage()), (String)"text/plain").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Start Execute CopyContentFile Web Service");
        }
        return Response.ok((Object)"OK...content has been successfully copied in the production server", (String)"text/plain").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }
}

