/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.legacy.search.es;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.ecms.legacy.search.SearchServiceConnector;
import org.exoplatform.ecms.legacy.search.data.SearchContext;
import org.exoplatform.ecms.legacy.search.data.SearchResult;
import org.exoplatform.ecms.legacy.search.es.ElasticSearchFilter;
import org.exoplatform.ecms.legacy.search.es.ElasticSearchFilterType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Deprecated(forRemoval=true, since="6.0.0")
public class ElasticSearchServiceConnector
extends SearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(ElasticSearchServiceConnector.class);
    public static final String HIGHLIGHT_FRAGMENT_SIZE_PARAM_NAME = "highlightFragmentSize";
    public static final int HIGHLIGHT_FRAGMENT_SIZE_DEFAULT_VALUE = 100;
    public static final String HIGHLIGHT_FRAGMENT_NUMBER_PARAM_NAME = "highlightFragmentNumber";
    public static final int HIGHLIGHT_FRAGMENT_NUMBER_DEFAULT_VALUE = 3;
    private final ElasticSearchingClient client;
    public static final String GROUP = "group";
    public static final String WIKI_TYPE = "wikiType";
    private String index;
    private List<String> searchFields;
    private List<String> boostedSearchFields;
    private List<String> searchFieldsWithBoost;
    private int highlightFragmentSize;
    private int highlightFragmentNumber;
    private String img;
    private String titleElasticFieldName = "title";
    private String updatedDateElasticFieldName = "lastUpdatedDate";
    private Map<String, String> sortMapping = new HashMap<String, String>();

    public ElasticSearchServiceConnector(InitParams initParams, ElasticSearchingClient client) {
        super(initParams);
        String highlightFragmentNumberParamValue;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        if (StringUtils.isNotBlank((String)param.getProperty("titleField"))) {
            this.titleElasticFieldName = param.getProperty("titleField");
        }
        if (StringUtils.isNotBlank((String)param.getProperty("updatedDateField"))) {
            this.updatedDateElasticFieldName = param.getProperty("updatedDateField");
        }
        this.searchFields = new ArrayList<String>(Arrays.asList(param.getProperty("searchFields").split(",")));
        if (StringUtils.isBlank((String)param.getProperty("boostedSearchFields"))) {
            if (this.searchFields.contains(this.titleElasticFieldName)) {
                this.boostedSearchFields = Collections.singletonList(this.titleElasticFieldName);
            }
        } else {
            this.boostedSearchFields = new ArrayList<String>(Arrays.asList(param.getProperty("boostedSearchFields").split(",")));
        }
        this.searchFieldsWithBoost = this.boostedSearchFields != null && !this.boostedSearchFields.isEmpty() ? this.searchFields.stream().map(searchField -> {
            if (this.boostedSearchFields.contains(searchField)) {
                searchField = (String)searchField + "^5";
            }
            return searchField;
        }).collect(Collectors.toList()) : this.searchFields;
        String highlightFragmentSizeParamValue = param.getProperty(HIGHLIGHT_FRAGMENT_SIZE_PARAM_NAME);
        if (highlightFragmentSizeParamValue != null) {
            try {
                this.highlightFragmentSize = Integer.valueOf(highlightFragmentSizeParamValue);
            }
            catch (NumberFormatException e) {
                this.highlightFragmentSize = 100;
                LOG.warn((Object)("Value of param highlightFragmentSize of search connector " + ((Object)((Object)this)).getClass().getName() + " is not a valid number (" + highlightFragmentSizeParamValue + "), default value will be used (100)"));
            }
        } else {
            this.highlightFragmentSize = 100;
        }
        if ((highlightFragmentNumberParamValue = param.getProperty(HIGHLIGHT_FRAGMENT_NUMBER_PARAM_NAME)) != null) {
            try {
                this.highlightFragmentNumber = Integer.valueOf(highlightFragmentNumberParamValue);
            }
            catch (NumberFormatException e) {
                this.highlightFragmentNumber = 3;
                LOG.warn((Object)("Value of param highlightFragmentNumber of search connector " + ((Object)((Object)this)).getClass().getName() + " is not a valid number (" + highlightFragmentNumberParamValue + "), default value will be used (3)"));
            }
        } else {
            this.highlightFragmentNumber = 3;
        }
        this.sortMapping.put("relevancy", "_score");
        this.sortMapping.put("date", "lastUpdatedDate");
    }

    @Override
    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        String esQuery = this.buildQuery(query, sites, offset, limit, sort, order);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse, context);
    }

    @Override
    public boolean isIndexed(SearchContext context, String id) {
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{\n");
        esQuery.append("  \"query\": {\n");
        esQuery.append("    \"term\" : { \"_id\" : \"" + id + "\" }\n");
        esQuery.append("  }\n");
        esQuery.append("}");
        String jsonResponse = this.client.sendRequest(esQuery.toString(), this.index);
        Collection<SearchResult> results = this.buildResult(jsonResponse, context);
        results.stream().forEach(arg_0 -> ((Log)LOG).info(arg_0));
        return !results.isEmpty();
    }

    public Collection<SearchResult> filteredSearch(SearchContext context, String query, List<ElasticSearchFilter> filters, Collection<String> sites, int offset, int limit, String sort, String order) {
        String esQuery = this.buildFilteredQuery(query, sites, filters, offset, limit, sort, order);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse, context);
    }

    public Collection<SearchResult> searchByEntityId(SearchContext context, String query, String entityId) {
        String esQuery = this.builQueryWithEntityId(query, entityId);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse, context);
    }

    protected String buildQuery(String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        return this.buildFilteredQuery(query, sites, null, offset, limit, sort, order);
    }

    protected String builQueryWithEntityId(String query, String id) {
        ArrayList composedKeywords = new ArrayList();
        List<String> keywords = Arrays.asList(query.split(","));
        keywords = keywords.stream().filter(key -> {
            if (key.contains(" ")) {
                composedKeywords.add(key);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        query = String.join((CharSequence)" ", keywords);
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{\n");
        esQuery.append("     \"track_scores\": true,\n");
        esQuery.append("     \"_source\": [" + this.getSourceFields() + "],");
        esQuery.append("     \"query\": {\n");
        esQuery.append("        \"bool\" : {\n");
        esQuery.append("            \"should\" : [\n");
        if (StringUtils.isNotBlank((String)query)) {
            Object queryParts = Arrays.asList(query.split("[\\+\\-=\\&\\|><\\!\\(\\)\\{\\}\\[\\]\\^\"\\*\\?:\\/ @$]+"));
            queryParts = queryParts.stream().map(queryPart -> {
                if (((String)(queryPart = this.escapeReservedCharacters((String)queryPart))).length() > 5) {
                    queryPart = (String)queryPart + "~1";
                }
                return queryPart;
            }).collect(Collectors.toList());
            String escapedQueryWithOROperator = StringUtils.join(queryParts, (String)" OR ");
            esQuery.append("            {\n");
            esQuery.append("                \"query_string\" : {\n");
            esQuery.append("                    \"fields\" : [" + this.getFields() + "],\n");
            esQuery.append("                    \"query\" : \"" + escapedQueryWithOROperator + "\"\n");
            esQuery.append("                }\n");
            if (composedKeywords.isEmpty()) {
                esQuery.append("            }\n");
            } else {
                esQuery.append("            },\n");
            }
        }
        if (!composedKeywords.isEmpty()) {
            esQuery.append("            {\n");
            esQuery.append("            \"dis_max\" : {\n");
            esQuery.append("              \"queries\": [\n");
            for (String composedKeyword : composedKeywords) {
                esQuery.append("                {\n");
                esQuery.append("                \"multi_match\" : {\n");
                esQuery.append("                    \"type\" : \"phrase\",\n");
                esQuery.append("                    \"fields\" : [" + this.getFields() + "],\n");
                esQuery.append("                    \"query\" : \"" + composedKeyword + "\"\n");
                esQuery.append("                }\n");
                esQuery.append("                },");
            }
            esQuery.deleteCharAt(esQuery.length() - 1);
            esQuery.append("                  ]\n");
            esQuery.append("               }\n");
            esQuery.append("            }\n");
        }
        esQuery.append("            ],\n");
        esQuery.append("            \"filter\" : {\n");
        esQuery.append("              \"bool\" : {\n");
        esQuery.append("                \"must\" : [\n");
        esQuery.append("                  {\n");
        esQuery.append("                   \"bool\" : {\n");
        esQuery.append("                     \"should\" : [\n");
        esQuery.append("                       { \"term\" : { \"_id\" : \"" + id + "\" } }\n");
        esQuery.append("                     ]\n");
        esQuery.append("                   }\n");
        esQuery.append("                  }\n");
        esQuery.append("                ]\n");
        esQuery.append("              }\n");
        esQuery.append("            }");
        esQuery.append("        }\n");
        esQuery.append("     },\n");
        esQuery.append("     \"highlight\" : {\n");
        esQuery.append("       \"fields\" : {\n");
        for (int i = 0; i < this.searchFields.size(); ++i) {
            esQuery.append("         \"" + this.searchFields.get(i) + "\" : {}");
            if (i < this.searchFields.size() - 1) {
                esQuery.append(",");
            }
            esQuery.append("\n");
        }
        esQuery.append("       }\n");
        esQuery.append("     }\n");
        esQuery.append("}");
        LOG.debug("Search Query request to ES : {} ", new Object[]{esQuery});
        return esQuery.toString();
    }

    protected String buildFilteredQuery(String query, Collection<String> sites, List<ElasticSearchFilter> filters, int offset, int limit, String sort, String order) {
        String additionalFilters;
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{\n");
        esQuery.append("     \"from\" : " + offset + ",\n");
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            esQuery.append("     \"size\" : " + limit + ",\n");
        }
        esQuery.append("     \"track_scores\": true,\n");
        esQuery.append("     \"sort\" : [\n");
        esQuery.append("       { \"" + (StringUtils.isNotBlank((String)this.sortMapping.get(sort)) ? this.sortMapping.get(sort) : "_score") + "\" : ");
        esQuery.append("{\"order\" : \"" + (StringUtils.isNotBlank((String)order) ? order : "desc") + "\"}}\n");
        esQuery.append("     ],\n");
        esQuery.append("     \"_source\": [" + this.getSourceFields() + "],");
        esQuery.append("     \"query\": {\n");
        esQuery.append("        \"bool\" : {\n");
        if (StringUtils.isNotBlank((String)query)) {
            List<String> queryParts = Arrays.asList(query.split("[\\+\\-=\\&\\|><\\!\\(\\)\\{\\}\\[\\]\\^\"\\*\\?:\\/ @]+"));
            queryParts = queryParts.stream().map(queryPart -> {
                if (((String)(queryPart = this.escapeReservedCharacters((String)queryPart))).length() > 5) {
                    queryPart = (String)queryPart + "~1";
                }
                return queryPart;
            }).collect(Collectors.toList());
            String escapedQueryWithAndOperator = StringUtils.join(queryParts, (String)" AND ");
            String escapedQueryWithoutOperator = StringUtils.join(queryParts, (String)" ");
            esQuery.append("            \"must\" : {\n");
            esQuery.append("                \"query_string\" : {\n");
            esQuery.append("                    \"fields\" : [" + this.getFields() + "],\n");
            esQuery.append("                    \"query\" : \"" + escapedQueryWithAndOperator + "\"\n");
            esQuery.append("                }\n");
            esQuery.append("            },\n");
            esQuery.append("            \"should\" : {\n");
            esQuery.append("                \"multi_match\" : {\n");
            esQuery.append("                    \"type\" : \"phrase\",\n");
            esQuery.append("                    \"fields\" : [" + this.getFields() + "],\n");
            esQuery.append("                    \"boost\" : 5,\n");
            esQuery.append("                    \"query\" : \"" + escapedQueryWithoutOperator + "\"\n");
            esQuery.append("                }\n");
            esQuery.append("            },\n");
        }
        esQuery.append("            \"filter\" : [\n");
        String metadataQuery = this.getMetadataQuery(filters);
        if (StringUtils.isNotBlank((String)metadataQuery)) {
            esQuery.append(metadataQuery);
        }
        esQuery.append("            {\n");
        esQuery.append("              \"bool\" : {\n");
        esQuery.append("                \"must\" : [\n");
        esQuery.append("                  {\n");
        esQuery.append("                   \"bool\" : {\n");
        esQuery.append("                     \"should\" : [\n");
        if (filters != null && filters.size() > 1 && WIKI_TYPE.equals(filters.get(0).getField()) && GROUP.equals(filters.get(0).getValue()) && StringUtils.isNotBlank((String)filters.get(1).getValue())) {
            esQuery.append("                      " + this.getPermissionFilterWiki(filters.get(1).getValue()) + "\n");
        } else {
            esQuery.append("                      " + this.getPermissionFilter() + "\n");
        }
        esQuery.append("                      ]\n");
        esQuery.append("                    }\n");
        esQuery.append("                  }\n");
        String sitesFilter = this.getSitesFilter(sites);
        if (StringUtils.isNotBlank((String)sitesFilter)) {
            esQuery.append("                  ,{\n");
            esQuery.append("                   \"bool\" : {\n");
            esQuery.append("                     \"should\" : \n");
            esQuery.append("                      " + sitesFilter + "\n");
            esQuery.append("                    }\n");
            esQuery.append("                  }");
        }
        if (StringUtils.isNotBlank((String)(additionalFilters = this.getAdditionalFilters(filters)))) {
            esQuery.append(additionalFilters);
        }
        esQuery.append("                  \n");
        esQuery.append("                ]\n");
        esQuery.append("              }\n");
        esQuery.append("             }\n");
        esQuery.append("            ]");
        esQuery.append("        }\n");
        esQuery.append("     },\n");
        esQuery.append("     \"highlight\" : {\n");
        esQuery.append("       \"pre_tags\" : [\"<span class='searchMatchExcerpt'>\"],\n");
        esQuery.append("       \"post_tags\" : [\"</span>\"],\n");
        esQuery.append("       \"fields\" : {\n");
        for (int i = 0; i < this.searchFields.size(); ++i) {
            esQuery.append("         \"" + this.searchFields.get(i) + "\" : {\n").append("          \"type\" : \"unified\",\n").append("          \"fragment_size\" : " + this.highlightFragmentSize + ",\n").append("          \"no_match_size\" : 0,\n").append("          \"number_of_fragments\" : " + this.highlightFragmentNumber + "}");
            if (i < this.searchFields.size() - 1) {
                esQuery.append(",");
            }
            esQuery.append("\n");
        }
        esQuery.append("       }\n");
        esQuery.append("     }\n");
        esQuery.append("}");
        LOG.debug("Search Query request to ES : {} ", new Object[]{esQuery});
        return esQuery.toString();
    }

    protected String escapeReservedCharacters(String query) {
        if (StringUtils.isNotEmpty((String)query)) {
            return query.replaceAll("[" + Pattern.quote("+-=&|><!(){}\\[\\]^\"*?:\\/") + "]", Matcher.quoteReplacement("\\\\") + "$0");
        }
        return query;
    }

    protected Collection<SearchResult> buildResult(String jsonResponse, SearchContext context) {
        JSONArray jsonHits;
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult != null && (jsonHits = (JSONArray)jsonResult.get((Object)"hits")) != null) {
            for (Object jsonHit : jsonHits) {
                results.add(this.buildHit((JSONObject)jsonHit, context));
            }
        }
        return results;
    }

    protected SearchResult buildHit(JSONObject jsonHit, SearchContext searchContext) {
        JSONObject hitSource = (JSONObject)jsonHit.get((Object)"_source");
        String title = this.getTitleFromJsonResult(hitSource);
        String url = this.getUrlFromJsonResult(hitSource, searchContext);
        Long lastUpdatedDate = this.getUpdatedDateFromResult(hitSource);
        if (lastUpdatedDate == null) {
            lastUpdatedDate = new Date().getTime();
        }
        Double score = (Double)jsonHit.get((Object)"_score");
        String detail = this.buildDetail(jsonHit, searchContext);
        JSONObject hitHighlight = (JSONObject)jsonHit.get((Object)"highlight");
        HashMap<String, List<String>> excerpts = new HashMap<String, List<String>>();
        StringBuilder excerpt = new StringBuilder();
        if (hitHighlight != null) {
            for (String key : hitHighlight.keySet()) {
                JSONArray highlights = (JSONArray)hitHighlight.get((Object)key);
                List excerptsList = highlights.stream().map(Object::toString).collect(Collectors.toList());
                excerpts.put(key, excerptsList);
                excerpt.append("... ").append(StringUtils.join(excerptsList, (String)"..."));
            }
        }
        LOG.debug("Excerpt extract from ES response : {}", new Object[]{excerpt.toString()});
        return new SearchResult(url, title, excerpts, excerpt.toString(), detail, this.img, lastUpdatedDate, score.longValue());
    }

    protected String buildDetail(JSONObject jsonHit, SearchContext searchContext) {
        return null;
    }

    protected Long getUpdatedDateFromResult(JSONObject hitSource) {
        Object date = hitSource.get((Object)this.updatedDateElasticFieldName);
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date != null) {
            try {
                return Long.parseLong(date.toString());
            }
            catch (Exception ex) {
                LOG.error("Can not parse updatedDate field as Long {}", new Object[]{date});
            }
        }
        return null;
    }

    protected String getUrlFromJsonResult(JSONObject hitSource, SearchContext context) {
        return (String)hitSource.get((Object)"url");
    }

    protected String getTitleFromJsonResult(JSONObject hitSource) {
        return (String)hitSource.get((Object)this.titleElasticFieldName);
    }

    protected String getAdditionalFilters(List<ElasticSearchFilter> filters) {
        if (filters == null) {
            return "";
        }
        StringBuilder filterJSON = new StringBuilder();
        for (ElasticSearchFilter filter : filters) {
            if (filter.getType().equals((Object)ElasticSearchFilterType.FILTER_MY_WORK_DOCS)) {
                filterJSON.append(this.getFilter(filter));
                continue;
            }
            filterJSON.append("                  ,\n");
            filterJSON.append("                  {\n");
            filterJSON.append("                   \"bool\" : {\n");
            filterJSON.append("                     \"should\" : [\n");
            filterJSON.append("                      " + this.getFilter(filter) + "\n");
            filterJSON.append("                       ]\n");
            filterJSON.append("                    }\n");
            filterJSON.append("                  }");
        }
        return filterJSON.toString();
    }

    protected String getMetadataQuery(List<ElasticSearchFilter> filters) {
        if (filters == null) {
            return "";
        }
        StringBuilder metaQuery = new StringBuilder();
        for (ElasticSearchFilter filter : filters) {
            if (!filter.getType().equals((Object)ElasticSearchFilterType.FILTER_MATADATAS)) continue;
            metaQuery.append(filter.getValue());
        }
        return metaQuery.toString();
    }

    private String getFilter(ElasticSearchFilter filter) {
        switch (filter.getType()) {
            case FILTER_BY_TERM: {
                return this.getTermFilter(filter.getField(), filter.getValue());
            }
            case FILTER_EXIST: {
                return this.getExistFilter(filter.getField());
            }
            case FILTER_NOT_EXIST: {
                return this.getNotExistFilter(filter.getField());
            }
            case FILTER_CUSTOM: {
                return this.getCustomFilter(filter.getValue());
            }
            case FILTER_MY_WORK_DOCS: {
                return this.myWorkDocumentsFilter(filter.getValue());
            }
        }
        return "";
    }

    private String getTermFilter(String field, String value) {
        return "{\n \"term\" : { \"" + field + "\" : \"" + value + "\" }\n }";
    }

    private String getNotExistFilter(String field) {
        return "{\n  \"not\": {\n    \"exists\" : { \"field\" : \"" + field + "\" }\n  }\n}";
    }

    private String getExistFilter(String field) {
        return "{\n \"exists\" : { \"field\" : \"" + field + "\" }\n }";
    }

    protected String getFields() {
        ArrayList<CallSite> fields = new ArrayList<CallSite>();
        List<String> fieldsToUse = this.searchFieldsWithBoost != null && !this.searchFieldsWithBoost.isEmpty() ? this.searchFieldsWithBoost : this.searchFields;
        for (String searchField : fieldsToUse) {
            fields.add((CallSite)((Object)("\"" + searchField + "\"")));
        }
        return StringUtils.join(fields, (String)",");
    }

    private String getCustomFilter(String value) {
        return value;
    }

    private String myWorkDocumentsFilter(String value) {
        StringBuilder filterJSON = new StringBuilder();
        filterJSON.append("                  ,\n");
        filterJSON.append("                  {\n");
        filterJSON.append("                   \"bool\" : {\n");
        filterJSON.append("                       " + value + "\n");
        filterJSON.append("                    }\n");
        filterJSON.append("                  }");
        return filterJSON.toString();
    }

    protected String getPermissionFilter() {
        StringBuilder permissionSB = new StringBuilder();
        Set<String> membershipSet = this.getUserMemberships();
        if (!membershipSet.isEmpty()) {
            String memberships = StringUtils.join((Object[])membershipSet.toArray(new String[membershipSet.size()]), (String)"|");
            permissionSB.append("{\n").append("  \"term\" : { \"permissions\" : \"").append(this.getCurrentUser()).append("\" }\n").append("},\n").append("{\n").append("  \"term\" : { \"permissions\" : \"").append(IdentityConstants.ANY).append("\" }\n").append("},\n").append("{\n").append("  \"regexp\" : { \"permissions\" : \"").append(memberships).append("\" }\n").append("}");
        } else {
            permissionSB.append("{\n").append("  \"term\" : { \"permissions\" : \"").append(this.getCurrentUser()).append("\" }\n").append("},\n").append("{\n").append("  \"term\" : { \"permissions\" : \"").append(IdentityConstants.ANY).append("\" }\n").append("}");
        }
        return permissionSB.toString();
    }

    protected String getSitesFilter(Collection<String> sitesCollection) {
        if (sitesCollection != null && !sitesCollection.isEmpty()) {
            ArrayList<CallSite> sites = new ArrayList<CallSite>();
            for (String site : sitesCollection) {
                sites.add((CallSite)((Object)("\"" + site + "\"")));
            }
            String sitesList = "[" + StringUtils.join(sites, (String)",") + "]";
            return " [ { \"bool\" : {\n         \"must_not\": {\n           \"exists\" : { \"field\" : \"sites\" }\n         }\n       }\n},\n{\n  \"terms\" : { \n    \"sites\" : " + sitesList + "\n  }\n} ]";
        }
        return " { \"bool\" : {\n  \"must_not\": {\n      \"exists\" : { \"field\" : \"sites\" }\n   }\n  }\n}\n";
    }

    protected String getPermissionFilterWiki(String permission) {
        StringBuilder permissionSB = new StringBuilder();
        Set<String> membershipSet = this.getUserMemberships();
        if (!membershipSet.isEmpty()) {
            String memberships = StringUtils.join((Object[])membershipSet.toArray(new String[membershipSet.size()]), (String)"|");
            permissionSB.append("{\n").append("  \"term\" : { \"permissions\" : \"").append(permission).append("\" }\n").append("},\n").append("{\n").append("  \"term\" : { \"permissions\" : \"").append(IdentityConstants.ANY).append("\" }\n").append("},\n").append("{\n").append("  \"regexp\" : { \"permissions\" : \"").append(memberships).append("\" }\n").append("}");
        } else {
            permissionSB.append("{\n").append("  \"term\" : { \"permissions\" : \"").append(this.getCurrentUser()).append("\" }\n").append("},\n").append("{\n").append("  \"term\" : { \"permissions\" : \"").append(IdentityConstants.ANY).append("\" }\n").append("}");
        }
        return permissionSB.toString();
    }

    private String getCurrentUser() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent() is null");
        }
        if (ConversationState.getCurrent().getIdentity() == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent().getIdentity() is null");
        }
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    protected Set<String> getUserMemberships() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent() is null");
        }
        if (ConversationState.getCurrent().getIdentity() == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent().getIdentity() is null");
        }
        if (ConversationState.getCurrent().getIdentity().getMemberships() == null) {
            throw new IllegalStateException("No Membership found: ConversationState.getCurrent().getIdentity().getMemberships() is null");
        }
        HashSet<String> entries = new HashSet<String>();
        for (MembershipEntry entry : ConversationState.getCurrent().getIdentity().getMemberships()) {
            if (entry.getMembershipType().equals("*")) {
                entries.add(entry.toString().replace("*", ".*"));
                continue;
            }
            entries.add(entry.toString());
            entries.add("*:" + entry.getGroup());
        }
        return entries;
    }

    protected String getSourceFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("url");
        fields.add(this.getTitleElasticFieldName());
        ArrayList<CallSite> sourceFields = new ArrayList<CallSite>();
        for (String sourceField : fields) {
            sourceFields.add((CallSite)((Object)("\"" + sourceField + "\"")));
        }
        return StringUtils.join(sourceFields, (String)",");
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getImg() {
        return this.img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public String getTitleElasticFieldName() {
        return this.titleElasticFieldName;
    }

    public void setTitleElasticFieldName(String titleElasticFieldName) {
        this.titleElasticFieldName = titleElasticFieldName;
    }

    public List<String> getSearchFields() {
        return this.searchFields;
    }

    public void setSearchFields(List<String> searchFields) {
        this.searchFields = searchFields;
    }

    public ElasticSearchingClient getClient() {
        return this.client;
    }
}

