/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives;

import org.exoplatform.services.cms.clouddrives.CloudDriveException;

public abstract class CloudProvider {
    public static final String CONNECT_URL_BASE = "/portal/rest/clouddrive/connect/";
    public static final String AUTH_NOSTATE = "__no_state_set__";
    protected final String id;
    protected final String name;
    protected final int hashCode;

    protected CloudProvider(String id, String name) {
        this.id = id.intern();
        this.name = name.intern();
        int hc = 1;
        hc = hc * 31 + id.hashCode();
        this.hashCode = hc = hc * 31 + name.hashCode();
    }

    public abstract String getAuthURL() throws CloudDriveException;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getErrorMessage(Throwable error) {
        return error.getMessage();
    }

    public String getErrorMessage(String error, String errorDescription) {
        StringBuilder msg = new StringBuilder();
        msg.append(error);
        if (errorDescription != null && errorDescription.length() > 0) {
            msg.append(". ");
            msg.append(errorDescription);
        }
        return msg.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CloudProvider) {
            CloudProvider other = (CloudProvider)obj;
            return this.id == other.id && this.name == other.name;
        }
        return false;
    }

    public String toString() {
        return this.getId() + " " + this.getName();
    }

    public abstract boolean retryOnProviderError();
}

