/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.jcr.AccessDeniedException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.connector.collaboration.editors.ErrorMessage;
import org.exoplatform.wcm.connector.collaboration.editors.HypermediaLink;
import org.exoplatform.wcm.connector.collaboration.editors.HypermediaSupport;
import org.exoplatform.wcm.connector.collaboration.editors.IdentityData;

@Path(value="/identity/search")
public class IdentitySearchRESTService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(IdentitySearchRESTService.class);
    protected static final String CANNOT_LOAD_IDENTITIES = "CannotLoadIdentities";
    protected static final int MAX_RESULT_SIZE = 30;
    protected static final String USER_TYPE = "user";
    protected static final String SPACE_TYPE = "space";
    protected static final String GROUP_TYPE = "group";
    protected static final String SELF = "self";
    protected IdentityManager identityManager;
    protected OrganizationService organization;
    protected SpaceService spaceService;

    public IdentitySearchRESTService(IdentityManager identityManager, OrganizationService organization, SpaceService spaceService) {
        this.identityManager = identityManager;
        this.organization = organization;
        this.spaceService = spaceService;
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    public Response searchIdentities(@Context UriInfo uriInfo, @PathParam(value="name") String name) {
        try {
            IdentitiesDataResponse responseEntity = new IdentitiesDataResponse(this.findGroupsAndUsers(name));
            responseEntity.addLink(SELF, new HypermediaLink(uriInfo.getAbsolutePath().toString()));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseEntity).build();
        }
        catch (AccessDeniedException e) {
            LOG.error("Access denied to get identities with name: {}, error: {}", new Object[]{name, e.getMessage()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorMessage("Access denied error.", CANNOT_LOAD_IDENTITIES)).build();
        }
        catch (Exception e) {
            LOG.error("Cannot get identities with name: {}, error: {}", new Object[]{name, e.getMessage()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorMessage(e.getMessage(), CANNOT_LOAD_IDENTITIES)).build();
        }
    }

    protected List<IdentityData> findGroupsAndUsers(String name) throws Exception {
        List<IdentityData> identitiesData = this.findUsers(name, 15);
        int remain = 30 - identitiesData.size();
        identitiesData.addAll(this.findGroups(name, remain));
        Collections.sort(identitiesData, new Comparator<IdentityData>(){

            @Override
            public int compare(IdentityData s1, IdentityData s2) {
                return s1.getDisplayName().compareTo(s2.getDisplayName());
            }
        });
        return identitiesData;
    }

    protected List<IdentityData> findUsers(String name, int count) throws Exception {
        int size;
        ArrayList<IdentityData> results = new ArrayList<IdentityData>();
        ProfileFilter identityFilter = new ProfileFilter();
        identityFilter.setName(name);
        ListAccess identitiesList = this.identityManager.getIdentitiesByProfileFilter("organization", identityFilter, false);
        int n = size = identitiesList.getSize() >= count ? count : identitiesList.getSize();
        if (size > 0) {
            Identity[] identities;
            for (Identity id : identities = (Identity[])identitiesList.load(0, size)) {
                Profile profile = id.getProfile();
                String fullName = profile.getFullName();
                String userName = (String)profile.getProperty("username");
                String avatarUrl = profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png";
                results.add(new IdentityData(userName, fullName, USER_TYPE, avatarUrl));
            }
        }
        return results;
    }

    protected List<IdentityData> findGroups(String name, int count) throws Exception {
        int size;
        ArrayList<IdentityData> results = new ArrayList<IdentityData>();
        ListAccess groupsAccess = this.organization.getGroupHandler().findGroupsByKeyword(name);
        int n = size = groupsAccess.getSize() >= count ? count : groupsAccess.getSize();
        if (size > 0) {
            Group[] groups;
            for (Group group : groups = (Group[])groupsAccess.load(0, size)) {
                Space space = this.spaceService.getSpaceByGroupId(group.getId());
                if (space != null) {
                    String avatarUrl = space.getAvatarUrl() != null ? space.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png";
                    results.add(new IdentityData(space.getGroupId(), space.getDisplayName(), SPACE_TYPE, avatarUrl));
                    continue;
                }
                results.add(new IdentityData(group.getId(), group.getLabel(), GROUP_TYPE, "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png"));
            }
        }
        return results;
    }

    public static class IdentitiesDataResponse
    extends HypermediaSupport {
        private final List<IdentityData> identities;

        public IdentitiesDataResponse(List<IdentityData> identities) {
            this.identities = identities;
        }

        public List<IdentityData> getIdentities() {
            return this.identities;
        }
    }
}

