/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.drives;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.exoplatform.ecm.webui.nodetype.selector.UINodeTypeSelector;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/admin/drives/UINodeTypeSelector.gtmpl", events={@EventConfig(listeners={SearchNodeTypeActionListener.class}), @EventConfig(listeners={SaveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RefreshActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectedAllNodeTypesActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UINodeTypeSelector
extends org.exoplatform.ecm.webui.nodetype.selector.UINodeTypeSelector
implements ComponentSelector {
    private static final String ALL_DOCUMENT_TYPES = "ALL_DOCUMENT_TYPES";

    public static class CloseActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiNodeTypeSelector.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            UIComponent component = uiNodeTypeSelector.getSourceComponent().getParent();
            if (component != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(component);
            }
        }
    }

    public static class ShowPageActionListener
    extends EventListener<UIPageIterator> {
        public void execute(Event<UIPageIterator> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((UIPageIterator)event.getSource()).getAncestorOfType(UINodeTypeSelector.class);
            List selectedNodetypes = uiNodeTypeSelector.getSelectedNodetypes();
            ArrayList listCheckbox = new ArrayList();
            uiNodeTypeSelector.findComponentOfType(listCheckbox, UICheckBoxInput.class);
            for (UICheckBoxInput uiCheckBox : listCheckbox) {
                if (selectedNodetypes.contains(((Boolean)uiCheckBox.getValue()).toString())) {
                    uiCheckBox.setChecked(true);
                    continue;
                }
                uiCheckBox.setChecked(false);
            }
        }
    }

    public static class SelectedAllNodeTypesActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((Object)event.getSource());
            String returnField = uiNodeTypeSelector.getReturnFieldName();
            String value = "*";
            ((UISelectable)uiNodeTypeSelector.getSourceComponent()).doSelect(returnField, (Object)value);
            UIPopupWindow uiPopup = (UIPopupWindow)uiNodeTypeSelector.getParent();
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiNodeTypeSelector.getSourceComponent().getParent());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class RefreshActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((Object)event.getSource());
            ArrayList listCheckbox = new ArrayList();
            uiNodeTypeSelector.findComponentOfType(listCheckbox, UICheckBoxInput.class);
            for (int i = 0; i < listCheckbox.size(); ++i) {
                ((UICheckBoxInput)listCheckbox.get(i)).setChecked(false);
                uiNodeTypeSelector.getSelectedNodetypes().clear();
            }
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)((Object)event.getSource())).getAncestorOfType(UIPopupWindow.class);
            uiPopup.setShowMask(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class SaveActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((Object)event.getSource());
            String returnField = uiNodeTypeSelector.getReturnFieldName();
            List selectedNodetypes = uiNodeTypeSelector.getSelectedNodetypes();
            if (selectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES)) {
                selectedNodetypes.remove(UINodeTypeSelector.ALL_DOCUMENT_TYPES);
                for (String docNodeType : uiNodeTypeSelector.getDocumentNodetypes()) {
                    if (selectedNodetypes.contains(docNodeType) || !((UICheckBoxInput)uiNodeTypeSelector.findComponentById(docNodeType)).isChecked()) continue;
                    selectedNodetypes.add(docNodeType);
                }
            }
            StringBuffer sb = new StringBuffer("");
            int index = 0;
            for (String strNodeType : selectedNodetypes) {
                if (index == 0) {
                    sb.append(strNodeType);
                } else {
                    sb.append(",").append(strNodeType);
                }
                ++index;
            }
            String nodeTypeString = sb.toString();
            ((UISelectable)uiNodeTypeSelector.getSourceComponent()).doSelect(returnField, (Object)nodeTypeString);
            selectedNodetypes.clear();
            UIPopupWindow uiPopup = (UIPopupWindow)uiNodeTypeSelector.getParent();
            uiPopup.setShow(false);
            UIComponent component = uiNodeTypeSelector.getSourceComponent().getParent();
            if (component != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(component);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class OnChangeActionListener
    extends EventListener<UINodeTypeSelector> {
        private void updateCheckBox(List<String> selectedNodetypes, UICheckBoxInput uiCheckBox) {
            if (uiCheckBox.isChecked()) {
                if (!selectedNodetypes.contains(uiCheckBox.getName().toString())) {
                    selectedNodetypes.add(uiCheckBox.getName().toString());
                }
            } else {
                selectedNodetypes.remove(uiCheckBox.getName().toString());
            }
        }

        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelect = (UINodeTypeSelector)((Object)event.getSource());
            List selectedNodetypes = uiNodeTypeSelect.getSelectedNodetypes();
            ArrayList preSelectedNodetypes = new ArrayList();
            preSelectedNodetypes.addAll(selectedNodetypes);
            List lstNodeType = uiNodeTypeSelect.getNodeTypeList();
            UICheckBoxInput uiCheckBox = (UICheckBoxInput)uiNodeTypeSelect.getChildById(UINodeTypeSelector.ALL_DOCUMENT_TYPES);
            this.updateCheckBox(selectedNodetypes, uiCheckBox);
            for (UINodeTypeSelector.NodeTypeBean nodetype : lstNodeType) {
                uiCheckBox = (UICheckBoxInput)uiNodeTypeSelect.getChildById(nodetype.getName());
                this.updateCheckBox(selectedNodetypes, uiCheckBox);
            }
            if (selectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES) && !preSelectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES)) {
                for (String nodeTypeName : uiNodeTypeSelect.getDocumentNodetypes()) {
                    ((UICheckBoxInput)uiNodeTypeSelect.getChildById(nodeTypeName)).setChecked(true);
                    if (selectedNodetypes.contains(nodeTypeName)) continue;
                    selectedNodetypes.add(nodeTypeName);
                }
            } else if (!selectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES) && preSelectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES) && selectedNodetypes.containsAll(uiNodeTypeSelect.getDocumentNodetypes())) {
                for (String nodeTypeName : uiNodeTypeSelect.getDocumentNodetypes()) {
                    ((UICheckBoxInput)uiNodeTypeSelect.getChildById(nodeTypeName)).setChecked(false);
                    selectedNodetypes.remove(nodeTypeName);
                }
            }
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)((Object)event.getSource())).getAncestorOfType(UIPopupWindow.class);
            uiPopup.setShowMask(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class SearchNodeTypeActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)((Object)event.getSource());
            UIFormStringInput uiInputNodeType = (UIFormStringInput)uiNodeTypeSelector.findComponentById("NodeTypeText");
            String nodeTypeName = (String)uiInputNodeType.getValue();
            if (nodeTypeName == null || nodeTypeName.length() == 0) {
                return;
            }
            if (nodeTypeName.contains("*") && !nodeTypeName.contains(".*")) {
                nodeTypeName = nodeTypeName.replace("*", ".*");
            }
            Pattern p = Pattern.compile(".*".concat(nodeTypeName.trim()).concat(".*"), 2);
            if (uiNodeTypeSelector.getLSTNodetype() == null) {
                uiNodeTypeSelector.setLSTNodetype(uiNodeTypeSelector.getAllNodeTypes());
            }
            ArrayList<UINodeTypeSelector.NodeTypeBean> lstNodetype = new ArrayList<UINodeTypeSelector.NodeTypeBean>();
            for (UINodeTypeSelector.NodeTypeBean nodeType : uiNodeTypeSelector.getLSTNodetype()) {
                if (!p.matcher(nodeType.getName()).find()) continue;
                lstNodetype.add(nodeType);
            }
            uiNodeTypeSelector.init(1, uiNodeTypeSelector.getSelectedNodetypes(), lstNodetype);
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)((Object)event.getSource())).getAncestorOfType(UIPopupWindow.class);
            uiPopup.setShowMask(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }
}

