/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.cms.link.PropertyLinkAware;
import org.exoplatform.services.cms.link.SessionLinkAware;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.ItemLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public abstract class ItemLinkAware
implements Item {
    protected final ItemLocation itemLocation;
    protected final String originalWorkspaceName;
    protected final String virtualPath;

    protected ItemLinkAware(String originalWorkspaceName, String virtualPath, Item item) {
        this.originalWorkspaceName = originalWorkspaceName;
        this.itemLocation = ItemLocation.getItemLocationByItem(item);
        if (!virtualPath.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + virtualPath + "' must be an absolute path");
        }
        this.virtualPath = virtualPath;
    }

    public static ItemLinkAware newInstance(String originalWorkspaceName, String originalAbsPath, Item item) {
        if (item instanceof Node) {
            return new NodeLinkAware(originalWorkspaceName, originalAbsPath, (Node)item);
        }
        return new PropertyLinkAware(originalWorkspaceName, originalAbsPath, (Property)item);
    }

    public Item getItem() {
        return ItemLocation.getItemByLocation(this.itemLocation);
    }

    public Session getItemSession() throws RepositoryException {
        return this.getItem().getSession();
    }

    public Session getOriginalSession() throws RepositoryException {
        SessionProvider sessionProvider = this.itemLocation.isSystemSession() ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
        return sessionProvider.getSession(this.originalWorkspaceName, WCMCoreUtils.getRepository());
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.getItem().accept(visitor);
    }

    public Item getAncestor(int depth) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return LinkUtils.getNodeFinder().getItem(this.getOriginalSession(), LinkUtils.getAncestorPath(this.virtualPath, depth));
    }

    public int getDepth() throws RepositoryException {
        return LinkUtils.getDepth(this.virtualPath);
    }

    public String getName() throws RepositoryException {
        return this.getItem().getName();
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return (Node)LinkUtils.getNodeFinder().getItem(this.getOriginalSession(), LinkUtils.getParentPath(this.virtualPath));
    }

    public String getPath() throws RepositoryException {
        return this.virtualPath;
    }

    public Session getSession() throws RepositoryException {
        return new SessionLinkAware(this);
    }

    public boolean isModified() {
        return this.getItem().isModified();
    }

    public boolean isNew() {
        return this.getItem().isNew();
    }

    public boolean isNode() {
        return this.getItem().isNode();
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        return this.getItem().isSame(otherItem);
    }

    public void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        this.getItem().refresh(keepChanges);
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.getItem().remove();
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.getItem().save();
    }
}

