/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.diff.DiffResult;
import org.exoplatform.commons.diff.DiffService;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.versions.UIVersionInfo;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.document.DocumentReader;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.document.HandlerNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/versions/UIDiff.gtmpl", events={@EventConfig(listeners={CompareActionListener.class}), @EventConfig(listeners={CloseCompareActionListener.class})})
public class UIDiff
extends UIComponent {
    private static final String EXO_LAST_MODIFIED_DATE = "exo:lastModifiedDate";
    private static final Log LOG = ExoLogger.getLogger((String)UIDiff.class.getName());
    public static final String FROM_PARAM = "from";
    public static final String TO_PARAM = "to";
    private String baseVersionName_;
    private String baseVersionDate_;
    private String baseVersionAuthor_;
    private String baseVersionLabel_;
    private String versionName_;
    private String versionDate_;
    private String versionAuthor_;
    private String versionLabel_;
    private String previousText_ = null;
    private String currentText_ = null;
    private boolean versionCompareable_ = true;
    private String diffResultHTML_ = null;
    private boolean isImage_ = false;
    private String baseImage_ = null;
    private String currentImage_ = null;

    public void setVersions(Node baseVersion, Node version) throws Exception {
        String[] versionLabels;
        UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)this.getAncestorOfType(UIDocumentWorkspace.class);
        UIVersionInfo uiVersionInfo = (UIVersionInfo)uiDocumentWorkspace.getChild(UIVersionInfo.class);
        boolean bl = this.versionCompareable_ = baseVersion != null && version != null && !baseVersion.getUUID().equals(version.getUUID());
        if (!this.versionCompareable_) {
            throw new IllegalStateException("Can't compare both versions");
        }
        Version versionRootVersion = null;
        versionRootVersion = version instanceof Version ? ((Version)version).getContainingHistory().getRootVersion() : version.getVersionHistory().getRootVersion();
        Version baseVersionRootVersion = null;
        baseVersionRootVersion = baseVersion instanceof Version ? ((Version)baseVersion).getContainingHistory().getRootVersion() : baseVersion.getVersionHistory().getRootVersion();
        this.versionCompareable_ = baseVersionRootVersion.getUUID().endsWith(versionRootVersion.getUUID());
        if (!this.versionCompareable_) {
            throw new IllegalStateException("Versions to compare are the same");
        }
        Node currentNode = uiVersionInfo.getCurrentNode();
        VersionHistory versionHistory = currentNode.getVersionHistory();
        Version rootVersion = versionHistory.getRootVersion();
        if (currentNode.getUUID().equals(baseVersion.getUUID())) {
            Node tmpNode = baseVersion;
            baseVersion = version;
            version = tmpNode;
        } else if (!currentNode.getUUID().equals(version.getUUID()) && baseVersion instanceof Version && version instanceof Version) {
            int versionNumIndice;
            int baseVersionIndice = Integer.parseInt(baseVersion.getName());
            if (baseVersionIndice == (versionNumIndice = Integer.parseInt(version.getName()))) {
                throw new IllegalStateException("Can't compare the same version");
            }
            if (baseVersionIndice > versionNumIndice) {
                Node tmpNode = baseVersion;
                baseVersion = version;
                version = tmpNode;
            }
        }
        this.baseVersionName_ = ((Version)baseVersion).getName();
        this.versionName_ = version instanceof Version ? version.getName() : uiVersionInfo.getRootVersionNum();
        Calendar modifiedDate = this.getModifiedDate(baseVersion);
        this.baseVersionDate_ = this.formatDate(modifiedDate);
        modifiedDate = this.getModifiedDate(version);
        this.versionDate_ = this.formatDate(modifiedDate);
        this.baseVersionAuthor_ = this.getLastModifier(baseVersion);
        this.versionAuthor_ = this.getLastModifier(version);
        String[] baseVersionLabels = versionHistory.getVersionLabels((Version)baseVersion);
        String string = this.baseVersionLabel_ = baseVersionLabels == null || baseVersionLabels.length == 0 ? null : baseVersionLabels[0];
        this.versionLabel_ = version instanceof Version ? ((versionLabels = versionHistory.getVersionLabels((Version)version)) == null || versionLabels.length == 0 ? null : versionLabels[0]) : ((versionLabels = versionHistory.getVersionLabels(rootVersion)) == null || versionLabels.length == 0 ? null : versionLabels[0]);
        this.isImage_ = this.isOriginalNodeImage(version) && this.isOriginalNodeImage(baseVersion);
        this.previousText_ = null;
        this.currentText_ = null;
        this.diffResultHTML_ = null;
        this.currentImage_ = null;
        this.baseImage_ = null;
        boolean bl2 = this.isImage_ = this.isOriginalNodeImage(version) && this.isOriginalNodeImage(baseVersion);
        if (this.isImage_) {
            String wsName = currentNode.getSession().getWorkspace().getName();
            String originalNodePath = currentNode.getPath();
            String basePath = "/" + WCMCoreUtils.getPortalName() + "/" + WCMCoreUtils.getRestContextName() + "/jcr/" + WCMCoreUtils.getRepository().getConfiguration().getName() + "/" + wsName + originalNodePath;
            long timeInMS = Calendar.getInstance().getTimeInMillis();
            this.currentImage_ = basePath + (currentNode.getUUID().equals(version.getUUID()) ? "?" + timeInMS : "?version=" + version.getName() + "&" + timeInMS);
            this.baseImage_ = basePath + (currentNode.getUUID().equals(baseVersion.getUUID()) ? "?" + timeInMS : "?version=" + baseVersion.getName() + "&" + timeInMS);
        } else {
            try {
                this.previousText_ = this.getText(baseVersion);
                this.currentText_ = this.getText(version);
            }
            catch (HandlerNotFoundException e) {
                this.versionCompareable_ = false;
            }
            if (this.versionCompareable_) {
                if (StringUtils.isBlank((CharSequence)this.previousText_) && StringUtils.isBlank((CharSequence)this.currentText_)) {
                    this.versionCompareable_ = false;
                } else if (this.previousText_ != null && this.currentText_ != null) {
                    DiffService diffService = (DiffService)WCMCoreUtils.getService(DiffService.class);
                    DiffResult diffResult = diffService.getDifferencesAsHTML(this.previousText_, this.currentText_, true);
                    this.diffResultHTML_ = diffResult.getDiffHTML();
                }
            }
        }
    }

    public String getBaseVersionNum() throws Exception {
        return this.baseVersionName_;
    }

    public String getCurrentVersionNum() throws Exception {
        return this.versionName_;
    }

    public String getBaseVersionDate() throws Exception {
        return this.baseVersionDate_;
    }

    public String getCurrentVersionDate() throws Exception {
        return this.versionDate_;
    }

    public String getBaseVersionAuthor() {
        return this.baseVersionAuthor_;
    }

    public String getCurrentVersionAuthor() {
        return this.versionAuthor_;
    }

    public String getBaseVersionLabel() {
        return this.baseVersionLabel_;
    }

    public String getCurrentVersionLabel() {
        return this.versionLabel_;
    }

    public String getBaseImage() throws Exception {
        return this.baseImage_;
    }

    public String getCurrentImage() throws Exception {
        return this.currentImage_;
    }

    public boolean isCompareable() {
        return this.versionCompareable_;
    }

    public String getDifferences() throws Exception {
        return this.diffResultHTML_;
    }

    public boolean isImage() {
        return this.isImage_;
    }

    private Calendar getModifiedDate(Node node) throws RepositoryException {
        Property property = this.getProperty(node, EXO_LAST_MODIFIED_DATE);
        return property == null ? null : property.getDate();
    }

    private String getLastModifier(Node node) throws RepositoryException {
        Property property = this.getProperty(node, "exo:lastModifier");
        return property == null ? null : property.getString();
    }

    private boolean isOriginalNodeImage(Node node) throws Exception {
        Property mimeProperty = this.getProperty(node, "jcr:mimeType");
        String mimeType = mimeProperty == null ? null : mimeProperty.getString();
        return StringUtils.isNotBlank((CharSequence)mimeType) && mimeType.startsWith("image");
    }

    private String getText(Node node) throws Exception {
        Property mimeProperty = this.getProperty(node, "jcr:mimeType");
        Property dataProperty = this.getProperty(node, "jcr:data");
        if (mimeProperty != null && dataProperty != null) {
            String mimeType = mimeProperty.getString();
            if (mimeType.startsWith("text")) {
                return dataProperty.getString();
            }
            DocumentReaderService readerService = (DocumentReaderService)this.getApplicationComponent(DocumentReaderService.class);
            DocumentReader documentReader = readerService.getDocumentReader(mimeType);
            if (documentReader != null) {
                try {
                    return documentReader.getContentAsText(dataProperty.getStream());
                }
                catch (Exception e) {
                    LOG.warn((Object)("An error occured while getting text from file " + node.getPath() + " with mimeType " + mimeType + " with document reader = " + String.valueOf(documentReader) + ". File comparaison will be disabled"), (Throwable)e);
                }
            }
        }
        throw new HandlerNotFoundException();
    }

    private Property getProperty(Node node, String propertyName) throws RepositoryException, PathNotFoundException {
        Node content;
        Property property = null;
        if (node instanceof Version) {
            if (node.hasNode("jcr:frozenNode")) {
                node = node.getNode("jcr:frozenNode");
            } else {
                return null;
            }
        }
        if (node.hasProperty(propertyName)) {
            property = node.getProperty(propertyName);
        } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty(propertyName)) {
            property = content.getProperty(propertyName);
        }
        return property;
    }

    private String formatDate(Calendar calendar) {
        Locale currentLocale = Util.getPortalRequestContext().getLocale();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, currentLocale);
        return dateFormat.format(calendar.getTime());
    }

    public static class CompareActionListener
    extends EventListener<UIDiff> {
        public void execute(Event<UIDiff> event) throws Exception {
            UIDiff uiDiff = (UIDiff)((Object)event.getSource());
            String fromVersionName = event.getRequestContext().getRequestParameter(UIDiff.FROM_PARAM);
            String toVersionName = event.getRequestContext().getRequestParameter(UIDiff.TO_PARAM);
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiDiff.getAncestorOfType(UIDocumentWorkspace.class);
            UIVersionInfo uiVersionInfo = (UIVersionInfo)uiDocumentWorkspace.getChild(UIVersionInfo.class);
            uiDiff.setVersions(uiVersionInfo.getVersion(fromVersionName), uiVersionInfo.getVersion(toVersionName));
        }
    }

    public static class CloseCompareActionListener
    extends EventListener<UIDiff> {
        public void execute(Event<UIDiff> event) throws Exception {
            UIDiff uiDiff = (UIDiff)((Object)event.getSource());
            if (uiDiff.isRendered()) {
                uiDiff.setRendered(false);
            }
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiDiff.getAncestorOfType(UIDocumentWorkspace.class);
            UIVersionInfo uiVersionInfo = (UIVersionInfo)uiDocumentWorkspace.getChild(UIVersionInfo.class);
            uiVersionInfo.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentWorkspace);
        }
    }
}

