/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.jcr.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class VersionNode {
    private static final String EXO_LAST_MODIFIED_DATE = "exo:lastModifiedDate";
    private boolean isExpanded;
    private List<VersionNode> children_;
    private static final Log LOG = ExoLogger.getLogger((String)VersionNode.class.getName());
    private Calendar createdTime_;
    private String name_;
    private String displayName;
    private String path_;
    private String ws_;
    private String uuid_;
    private String[] versionLabels_;
    private String author_;

    public VersionNode(Node node, Session session) {
        block6: {
            this.isExpanded = true;
            this.children_ = new ArrayList<VersionNode>();
            this.name_ = "";
            this.displayName = "";
            this.path_ = "";
            this.ws_ = "";
            this.versionLabels_ = new String[0];
            this.author_ = "";
            Version version = node instanceof Version ? (Version)node : null;
            try {
                Property property = this.getProperty(node, EXO_LAST_MODIFIED_DATE);
                if (property != null) {
                    this.createdTime_ = property.getDate();
                }
                this.name_ = version == null ? "" : version.getName();
                this.path_ = node.getPath();
                this.ws_ = node.getSession().getWorkspace().getName();
                this.uuid_ = node.getUUID();
                Property prop = this.getProperty(node, "exo:lastModifier");
                String string = this.author_ = prop == null ? null : prop.getString();
                if (version == null) {
                    if (node.isNodeType("mix:versionable")) {
                        this.addVersions(node, session);
                    }
                } else {
                    this.addVersions(node, session);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    private void addVersions(Node node, Session session) throws RepositoryException {
        if (node instanceof Version) {
            Version version = (Version)node;
            this.versionLabels_ = version.getContainingHistory().getVersionLabels(version);
        } else {
            int maxVersion = 0;
            HashMap<String, String> mapVersionName = new HashMap<String, String>();
            if (node.isNodeType("mix:versionDisplayName")) {
                if (node.hasProperty("exo:maxVersion")) {
                    maxVersion = (int)node.getProperty("exo:maxVersion").getLong();
                }
                if (node.hasProperty("exo:versionList")) {
                    Value[] values;
                    for (Value value : values = node.getProperty("exo:versionList").getValues()) {
                        mapVersionName.put(value.getString().split(":")[0], value.getString().split(":")[1]);
                    }
                }
            }
            Version rootVersion = node.getVersionHistory().getRootVersion();
            VersionIterator allVersions = node.getVersionHistory().getAllVersions();
            int maxIndex = 0;
            while (allVersions.hasNext()) {
                Version version = allVersions.nextVersion();
                if (version.getUUID().equals(rootVersion.getUUID())) continue;
                int versionIndex = Integer.parseInt(version.getName());
                maxIndex = Math.max(maxIndex, versionIndex);
                String versionOffset = (String)mapVersionName.get(version.getName());
                VersionNode versionNode = new VersionNode((Node)version, session);
                if (versionOffset != null) {
                    versionNode.setDisplayName(String.valueOf(Integer.parseInt(versionOffset) - 1));
                } else {
                    versionNode.setDisplayName(String.valueOf(versionIndex - 1));
                }
                this.children_.add(versionNode);
            }
            this.name_ = String.valueOf(maxIndex + 1);
            this.displayName = maxVersion > 0 ? String.valueOf(maxVersion - 1) : String.valueOf(maxIndex);
            this.versionLabels_ = node.getVersionHistory().getVersionLabels(rootVersion);
        }
    }

    private Property getProperty(Node node, String propName) throws RepositoryException {
        Property property = null;
        if (node.hasProperty(propName)) {
            property = node.getProperty(propName);
        } else if (node.hasNode("jcr:frozenNode") && node.getNode("jcr:frozenNode").hasProperty(propName)) {
            property = node.getNode("jcr:frozenNode").getProperty(propName);
        }
        return property;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public String getName() {
        return this.name_;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName_) {
        this.displayName = displayName_;
    }

    public String getWs() {
        return this.ws_;
    }

    public String getPath() {
        return this.path_;
    }

    public int getChildrenSize() {
        return this.children_.size();
    }

    public List<VersionNode> getChildren() {
        return this.children_;
    }

    public Calendar getCreatedTime() {
        return this.createdTime_;
    }

    public String getAuthor() {
        return this.author_;
    }

    public String[] getVersionLabels() {
        return this.versionLabels_;
    }

    public Node getNode(String nodeName) throws RepositoryException {
        DMSConfiguration dmsConf = (DMSConfiguration)WCMCoreUtils.getService(DMSConfiguration.class);
        String systemWS = dmsConf.getConfig().getSystemWorkspace();
        ManageableRepository repo = WCMCoreUtils.getRepository();
        SessionProvider provider = systemWS.equals(this.ws_) ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
        return ((Node)provider.getSession(this.ws_, repo).getItem(this.path_)).getNode(nodeName);
    }

    public boolean hasNode(String nodeName) throws Exception {
        DMSConfiguration dmsConf = (DMSConfiguration)WCMCoreUtils.getService(DMSConfiguration.class);
        String systemWS = dmsConf.getConfig().getSystemWorkspace();
        ManageableRepository repo = WCMCoreUtils.getRepository();
        SessionProvider provider = systemWS.equals(this.ws_) ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
        return ((Node)provider.getSession(this.ws_, repo).getItem(this.path_)).hasNode(nodeName);
    }

    public String getUUID() {
        return this.uuid_;
    }

    public VersionNode findVersionNode(String path) throws RepositoryException {
        if (this.path_.equals(path)) {
            return this;
        }
        VersionNode node = null;
        for (VersionNode child : this.children_) {
            node = child.findVersionNode(path);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public void removeVersionInChild(VersionNode versionNode1, VersionNode versionNodeRemove) throws RepositoryException {
        if (versionNode1.getChildren().contains(versionNodeRemove)) {
            versionNode1.getChildren().remove(versionNodeRemove);
        } else {
            for (VersionNode vsN : versionNode1.getChildren()) {
                this.removeVersionInChild(vsN, versionNodeRemove);
            }
        }
    }
}

