/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.fckeditor;

import java.security.AccessControlException;
import javax.jcr.Node;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FCKUtils {
    public static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    public static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    public static String GET_FOLDERS_AND_FILES = "getFoldersAndFiles";
    public static String CREATE_FOLDER = "createFolder";
    public static String UPLOAD_FILE = "upload";
    public static final String EXO_HIDDENABLE = "exo:hiddenable";
    public static final String NT_FILE = "nt:file";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String DOCUMENT_TYPE = "file";
    public static final String IMAGE_TYPE = "image";
    public static final String FLASH_TYPE = "flash";
    public static final String LINK_TYPE = "link";

    public static Element createRootElement(String command, Node node, String folderType) throws Exception {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.newDocument();
        StringBuffer currentPath = new StringBuffer(node.getPath());
        if (!currentPath.toString().endsWith("/")) {
            currentPath.append("/");
        }
        Element rootElement = doc.createElement("Connector");
        doc.appendChild(rootElement);
        rootElement.setAttribute("command", command);
        rootElement.setAttribute("resourceType", "Node");
        Element currentFolderElement = doc.createElement("CurrentFolder");
        currentFolderElement.setAttribute("name", node.getName());
        currentFolderElement.setAttribute("folderType", folderType);
        currentFolderElement.setAttribute("path", currentPath.toString());
        currentFolderElement.setAttribute("url", FCKUtils.createWebdavURL(node));
        rootElement.appendChild(currentFolderElement);
        return rootElement;
    }

    public static boolean hasAddNodePermission(Node node) throws Exception {
        try {
            ((ExtendedNode)node).checkPermission("add_node");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static String getPortalName() {
        PortalContainerInfo containerInfo = (PortalContainerInfo)WCMCoreUtils.getService(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public static String createWebdavURL(Node node) throws Exception {
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String workspace = node.getSession().getWorkspace().getName();
        String currentPath = node.getPath();
        String url = "/" + FCKUtils.getPortalName() + "/" + PortalContainer.getCurrentRestContextName() + "/jcr/" + repository + "/" + workspace + currentPath;
        return url;
    }
}

