/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.ecm.webui.component.admin.views.UITabContainer;
import org.exoplatform.ecm.webui.component.admin.views.UITabList;
import org.exoplatform.ecm.webui.component.admin.views.UIViewContainer;
import org.exoplatform.ecm.webui.component.admin.views.UIViewForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewList;
import org.exoplatform.ecm.webui.component.admin.views.UIViewPermissionContainer;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputBase;

@ComponentConfigs(value={@ComponentConfig(type=UIViewForm.class, lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/admin/view/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={RestoreActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIViewForm.ChangeVersionActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(template="app:/groovy/webui/component/admin/view/UIViewFormTabPane.gtmpl")})
public class UIViewFormTabPane
extends UITabPane {
    private static final Log logger = ExoLogger.getLogger((String)UIViewFormTabPane.class.getName());
    public static final String POPUP_PERMISSION = "PopupViewPermission";
    private String selectedTabId = "UITemplateContainer";
    public static final String SAVE_BUTTON = "Save";
    public static final String CANCEL_BUTTON = "Cancel";
    public static final String RESTORE_BUTTON = "Restore";
    private String[] actions_ = new String[]{"Save", "Cancel"};
    private String primaryBtn_ = "Save";
    private boolean isUpdate_ = false;

    public String getSelectedTabId() {
        return this.selectedTabId;
    }

    public void setSelectedTab(String renderTabId) {
        this.selectedTabId = renderTabId;
    }

    public void setSelectedTab(int index) {
        this.selectedTabId = this.getChild(index - 1).getId();
    }

    public String[] getActions() {
        UITabList uiTabList = (UITabList)this.findFirstComponentOfType(UITabList.class);
        String viewName = uiTabList.getViewName();
        if (StringUtils.isNotEmpty((CharSequence)viewName) && this.isUpdate()) {
            try {
                ManageViewService viewService = (ManageViewService)WCMCoreUtils.getService(ManageViewService.class);
                Node viewNode = viewService.getViewByName(viewName, WCMCoreUtils.getSystemSessionProvider());
                if (viewNode.isNodeType("mix:versionable")) {
                    this.actions_ = new String[]{SAVE_BUTTON, CANCEL_BUTTON, RESTORE_BUTTON};
                }
            }
            catch (Exception ex) {
                logger.error("View {0} does not exits", new Object[]{viewName});
            }
        }
        if (this.actions_.length == 1) {
            this.primaryBtn_ = this.actions_[0];
        }
        return this.actions_;
    }

    public void setActions(String[] actions) {
        this.actions_ = actions;
    }

    public String getPrimaryButtonAction() {
        return this.primaryBtn_;
    }

    public void setPrimaryButtonAction(String primaryBtn) {
        this.primaryBtn_ = primaryBtn;
    }

    public UIViewFormTabPane() throws Exception {
        UIViewForm uiViewForm = (UIViewForm)this.addChild(UIViewForm.class, null, null);
        this.addChild(UITabContainer.class, null, null);
        this.addChild(UIViewPermissionContainer.class, null, null);
        this.setSelectedTab(uiViewForm.getId());
    }

    public String getLabel(ResourceBundle res, String id) {
        try {
            return res.getString("UIViewForm.label." + id);
        }
        catch (MissingResourceException ex) {
            return id;
        }
    }

    public void update(boolean isUpdate) {
        this.isUpdate_ = isUpdate;
        ((UIViewPermissionContainer)this.getChild(UIViewPermissionContainer.class)).update(isUpdate);
    }

    public void view(boolean isView) {
        UITabContainer uiContainer = (UITabContainer)this.getChild(UITabContainer.class);
        ((UITabList)uiContainer.getChild(UITabList.class)).view(isView);
        ((UIViewPermissionContainer)this.getChild(UIViewPermissionContainer.class)).view(isView);
    }

    public boolean isUpdate() {
        return this.isUpdate_;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        ArrayList inputs = new ArrayList();
        this.findComponentOfType(inputs, UIFormInputBase.class);
        String action = context.getRequestParameter("formOp");
        for (UIFormInputBase input : inputs) {
            if (!input.isValid()) continue;
            String inputValue = context.getRequestParameter(input.getId());
            if (inputValue == null || inputValue.trim().length() == 0) {
                inputValue = context.getRequestParameter(input.getName());
            }
            input.decode((Object)inputValue, context);
        }
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public String event(String name) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.webui.UIForm.submitForm('").append("UIViewForm").append("','");
        b.append(name).append("',true)");
        return b.toString();
    }

    public static class SelectTabActionListener
    extends EventListener<UIViewFormTabPane> {
        public void execute(Event<UIViewFormTabPane> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            String renderTab = context.getRequestParameter("objectId");
            if (renderTab == null) {
                return;
            }
            ((UIViewFormTabPane)((Object)event.getSource())).setSelectedTab(renderTab);
            WebuiRequestContext parentContext = (WebuiRequestContext)context.getParentAppRequestContext();
            if (parentContext != null) {
                parentContext.setResponseComplete(true);
            } else {
                context.setResponseComplete(true);
            }
        }
    }

    public static class RestoreActionListener
    extends EventListener<UIViewForm> {
        public void execute(Event<UIViewForm> event) throws Exception {
            UIViewFormTabPane uiViewTabPane = (UIViewFormTabPane)((UIViewForm)((Object)event.getSource())).getParent();
            UIViewForm uiViewForm = (UIViewForm)uiViewTabPane.getChild(UIViewForm.class);
            uiViewForm.changeVersion();
            UIViewContainer uiContainer = (UIViewContainer)uiViewTabPane.getAncestorOfType(UIViewContainer.class);
            UIViewList uiViewList = (UIViewList)uiContainer.findFirstComponentOfType(UIViewList.class);
            uiViewList.refresh(uiViewList.getUIPageIterator().getCurrentPage());
            uiViewForm.refresh(true);
            uiViewTabPane.removeChildById(UIViewFormTabPane.POPUP_PERMISSION);
            UIViewContainer uiViewContainer = (UIViewContainer)uiViewTabPane.getAncestorOfType(UIViewContainer.class);
            uiViewContainer.removeChild(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }

    public static class CloseActionListener
    extends EventListener<UIViewForm> {
        public void execute(Event<UIViewForm> event) throws Exception {
            UIViewFormTabPane uiViewTabPane = (UIViewFormTabPane)((UIViewForm)((Object)event.getSource())).getParent();
            UIViewContainer uiViewContainer = (UIViewContainer)uiViewTabPane.getAncestorOfType(UIViewContainer.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiViewContainer.getChildById("ViewPopup");
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }

    public static class CancelActionListener
    extends EventListener<UIViewForm> {
        public void execute(Event<UIViewForm> event) throws Exception {
            UIViewFormTabPane uiViewTabPane = (UIViewFormTabPane)((UIViewForm)((Object)event.getSource())).getParent();
            UIViewContainer uiViewContainer = (UIViewContainer)uiViewTabPane.getAncestorOfType(UIViewContainer.class);
            UIPopupWindow uiPopup = null;
            uiPopup = uiViewTabPane.isUpdate() ? (UIPopupWindow)uiViewContainer.getChildById("EditPopup") : (UIPopupWindow)uiViewContainer.getChildById("AddPopup");
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }

    public static class SaveActionListener
    extends EventListener<UIViewForm> {
        public void execute(Event<UIViewForm> event) throws Exception {
            UIViewFormTabPane uiViewTabPane = (UIViewFormTabPane)((UIViewForm)((Object)event.getSource())).getParent();
            UIViewContainer uiViewContainer = (UIViewContainer)uiViewTabPane.getAncestorOfType(UIViewContainer.class);
            ((UIViewForm)uiViewTabPane.getChild(UIViewForm.class)).save();
            UIPopupWindow uiPopup = null;
            uiPopup = uiViewTabPane.isUpdate() ? (UIPopupWindow)uiViewContainer.getChildById("EditPopup") : (UIPopupWindow)uiViewContainer.getChildById("AddPopup");
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }
}

