/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Node;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.connector.BaseConnector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/contents/comment/")
public class CommentConnector
extends BaseConnector
implements ResourceContainer {
    CommentsService commentsService;

    public CommentConnector(CommentsService commentsService) {
        this.commentsService = commentsService;
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/add")
    public Response addComment(@FormParam(value="jcrPath") String jcrPath, @FormParam(value="comment") String comment) throws Exception {
        Node content = this.getNode(jcrPath);
        this.commentsService.addComment(content, content.getSession().getUserID(), null, null, comment, null);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/all")
    public Response getComments(@QueryParam(value="jcrPath") String jcrPath) throws Exception {
        try {
            Node content = this.getNode(jcrPath);
            List comments = this.commentsService.getComments(content, null);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element tagsElt = document.createElement("comments");
            for (Node comment : comments) {
                Element tagElt = document.createElement("comment");
                Element id = document.createElement("id");
                id.setTextContent(comment.getName());
                Element commentor = document.createElement("commentor");
                commentor.setTextContent(comment.getProperty("exo:commentor").getString());
                Element commentorEmail = document.createElement("email");
                if (comment.hasProperty("exo:commentorEmail")) {
                    commentorEmail.setTextContent(comment.getProperty("exo:commentorEmail").getString());
                }
                Element date = document.createElement("date");
                date.setTextContent(DateFormat.getDateTimeInstance().format(comment.getProperty("exo:commentDate").getDate().getTime()));
                Element commentElt = document.createElement("content");
                commentElt.setTextContent(comment.getProperty("exo:commentContent").getString());
                tagElt.appendChild(id);
                tagElt.appendChild(commentor);
                tagElt.appendChild(commentorEmail);
                tagElt.appendChild(date);
                tagElt.appendChild(commentElt);
                tagsElt.appendChild(tagElt);
            }
            document.appendChild(tagsElt);
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok((Object)new DOMSource(document), (String)"text/xml").header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
        catch (Exception e) {
            Response.serverError().build();
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/delete")
    public Response deleteComment(@QueryParam(value="jcrPath") String jcrPath, @QueryParam(value="commentId") String commentId) throws Exception {
        Node commentsNode;
        if (StringUtils.isEmpty((CharSequence)jcrPath) || StringUtils.isEmpty((CharSequence)commentId)) {
            return Response.status((int)400).entity((Object)"jcrPath and commentId query parameters are mandatory").build();
        }
        Node content = this.getNode(jcrPath);
        if (content.hasNode("comments")) {
            commentsNode = content.getNode("comments");
            if (!commentsNode.hasNode(commentId)) {
                return Response.noContent().build();
            }
        } else {
            return Response.noContent().build();
        }
        this.commentsService.deleteComment(commentsNode.getNode(commentId));
        return Response.ok().build();
    }

    protected Node getNode(@QueryParam(value="jcrPath") String jcrPath) throws Exception {
        if (jcrPath.contains("%20")) {
            jcrPath = URLDecoder.decode(jcrPath, "UTF-8");
        }
        String[] path = jcrPath.split("/");
        String repositoryName = path[1];
        String workspaceName = path[2];
        if ((jcrPath = jcrPath.substring(repositoryName.length() + workspaceName.length() + 2)).charAt(1) == '/') {
            jcrPath.substring(1);
        }
        return this.getContent(workspaceName, jcrPath, null, false);
    }

    @Override
    protected Node getRootContentStorage(Node parentNode) throws Exception {
        try {
            PortalFolderSchemaHandler folderSchemaHandler = (PortalFolderSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
            return folderSchemaHandler.getDocumentStorage(parentNode);
        }
        catch (Exception e) {
            WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
            return webContentSchemaHandler.getDocumentFolder(parentNode);
        }
    }

    @Override
    protected String getContentStorageType() throws Exception {
        return "file";
    }
}

