/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.javascript;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.javascript.WCMJavascriptResourceResolver;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.picocontainer.Startable;

public class XJavascriptService
implements Startable {
    private static String WEBCONTENT_JS_QUERY = "select * from exo:jsFile where jcr:path like '{path}/%' and exo:active='true' order by exo:priority ASC";
    private final String MODULE_NAME = "eXo.WCM.Live";
    public static final String JS_PATH_REGEXP = "/(.*)/javascript/eXo/(.*)/live";
    private final String PATH = "/javascript/eXo/{portalName}/live";
    private JavascriptConfigService jsConfigService;
    private WCMConfigurationService configurationService;
    private LivePortalManagerService livePortalManagerService_;
    private static final Log LOG = ExoLogger.getLogger((String)XJavascriptService.class.getName());
    private Set<String> loadedJSModule = new HashSet<String>();
    private Set<String> loadedSharedJSModule = new HashSet<String>();
    private ExoCache<String, Object> jsCache_;
    private long jsLastModifiedDate = System.currentTimeMillis();

    public XJavascriptService(WCMConfigurationService wcmConfigurationService, JavascriptConfigService javascriptConfigService, LivePortalManagerService livePortalService) throws Exception {
        this.livePortalManagerService_ = livePortalService;
        this.jsConfigService = javascriptConfigService;
        this.configurationService = wcmConfigurationService;
        this.jsCache_ = WCMCoreUtils.getService(CacheService.class).getCacheInstance("ecms.site.javascript.cache");
        this.jsConfigService.addResourceResolver((ResourceResolver)new WCMJavascriptResourceResolver(this.livePortalManagerService_, this.jsConfigService));
    }

    public String getActiveJavaScript(Node webcontent) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String jsQuery = StringUtils.replaceOnce((String)WEBCONTENT_JS_QUERY, (String)"{path}", (String)webcontent.getPath());
        NodeLocation webcontentLocation = NodeLocation.getNodeLocationByNode(webcontent);
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        Session session = null;
        session = webcontentLocation.getPath().startsWith("/jcr:system") ? repository.getSystemSession(repository.getConfiguration().getSystemWorkspaceName()) : repository.getSystemSession(webcontentLocation.getWorkspace());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(jsQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iterator = queryResult.getNodes();
        while (iterator.hasNext()) {
            Node registeredJSFile = iterator.nextNode();
            buffer.append(this.getActivedJSData(registeredJSFile));
        }
        session.logout();
        return buffer.toString();
    }

    public void updatePortalJSOnModify(Node portalNode, Node jsFile) throws Exception {
        String sharedPortalName = this.configurationService.getSharedPortalName();
        if (sharedPortalName.equals(portalNode.getName())) {
            this.addSharedPortalJavascript(portalNode, jsFile, false);
        } else {
            this.addPortalJavascript(portalNode, jsFile, false);
        }
    }

    public void updatePortalJSOnRemove(Node portalNode, Node jsFile) throws Exception {
        String sharedPortalName = this.configurationService.getSharedPortalName();
        if (sharedPortalName.equals(portalNode.getName())) {
            this.addSharedPortalJavascript(portalNode, jsFile, false);
        } else {
            this.addPortalJavascript(portalNode, jsFile, false);
        }
    }

    private void addPortalJavascript(Node portalNode, Node jsFile, boolean isStartup) throws Exception {
        String javascriptPath = StringUtils.replaceOnce((String)"/javascript/eXo/{portalName}/live", (String)"{portalName}", (String)portalNode.getName());
        String moduleName = "eXo.WCM.Live." + portalNode.getName();
        if (!this.loadedJSModule.contains(moduleName)) {
            this.loadedJSModule.add(moduleName);
        }
        this.jsCache_.clearCache();
        this.jsLastModifiedDate = System.currentTimeMillis();
    }

    private void addSharedPortalJavascript(Node portalNode, Node jsFile, boolean isStartup) throws Exception {
        if (portalNode != null) {
            String moduleName = "eXo.WCM.Live." + portalNode.getName();
            if (!this.loadedSharedJSModule.contains(moduleName)) {
                this.loadedSharedJSModule.add(moduleName);
            }
            this.jsCache_.clearCache();
            this.jsLastModifiedDate = System.currentTimeMillis();
        }
    }

    private String getActivedJSData(Node jsFile) throws ValueFormatException, RepositoryException, PathNotFoundException {
        if (jsFile != null && !jsFile.isNodeType("exo:restoreLocation") && jsFile.hasNode("jcr:content") && jsFile.getNode("jcr:content").hasProperty("jcr:data") && jsFile.hasProperty("exo:active") && jsFile.getProperty("exo:active").getBoolean()) {
            return jsFile.getNode("jcr:content").getProperty("jcr:data").getString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
            List<Node> livePortals = livePortalManagerService.getLivePortals(sessionProvider);
            for (Node portal : livePortals) {
                this.addPortalJavascript(portal, null, true);
            }
            Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
            this.addSharedPortalJavascript(sharedPortal, null, true);
        }
    }

    public void stop() {
    }

    public long getJsLastModifiedDate() {
        return this.jsLastModifiedDate;
    }
}

