/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.link;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLLinkExtractor {
    private Pattern patternTag = Pattern.compile("(?i)<a([^>]+)>(.+?)</a>");
    private Pattern patternLink = Pattern.compile("\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))");
    private Matcher matcherTag;
    private Matcher matcherLink;
    private static final String HTML_A_TAG_PATTERN = "(?i)<a([^>]+)>(.+?)</a>";
    private static final String HTML_A_HREF_TAG_PATTERN = "\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))";

    public List<HtmlLink> grabHTMLLinks(String html) {
        ArrayList<HtmlLink> result = new ArrayList<HtmlLink>();
        this.matcherTag = this.patternTag.matcher(html);
        while (this.matcherTag.find()) {
            String href = this.matcherTag.group(1);
            this.matcherLink = this.patternLink.matcher(href);
            while (this.matcherLink.find()) {
                String link = this.matcherLink.group(1);
                if (link.startsWith("\"") || link.startsWith("'")) {
                    link = link.substring(1, link.length() - 1);
                }
                result.add(new HtmlLink(this, link));
            }
        }
        return result;
    }

    class HtmlLink {
        String link;

        HtmlLink(HTMLLinkExtractor this$0, String link) {
            this.link = link;
        }

        public String toString() {
            return this.link;
        }
    }
}

