/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.listener;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.attachments.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;

public class ShareAttachmentsToSpaceListener
extends Listener<Map<String, Object>, Space> {
    private static final Log LOG = ExoLogger.getLogger((String)ShareAttachmentsToSpaceListener.class.getName());
    private final RepositoryService repositoryService;
    private final SessionProviderService sessionProviderService;
    public static final String NEWS_ATTACHMENTS_IDS = "attachmentsIds";
    public static final String QUARANTINE = "/Quarantine/";
    public static final String CONTENT = "content";
    public static final String SPACE = "space";
    public static final String AUDIENCE = "audience";
    private static final String IMAGE_SRC_REGEX = "src=\"/portal/rest/images/?(.+)?\"";

    public ShareAttachmentsToSpaceListener(RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    public void onEvent(Event event) throws Exception {
        Map data = (Map)event.getData();
        List attachmentsIds = (List)data.get(NEWS_ATTACHMENTS_IDS);
        String audience = (String)data.get(AUDIENCE);
        Space space = (Space)data.get(SPACE);
        String content = (String)data.get(CONTENT);
        if (content != null) {
            attachmentsIds.addAll(this.extractImageAttachmentUuidOrPath(content));
        }
        this.updateNodePermissions(attachmentsIds, audience, space);
    }

    private List<String> extractImageAttachmentUuidOrPath(String content) {
        ArrayList<String> imageNodeIds = new ArrayList<String>();
        Matcher matcher = Pattern.compile(IMAGE_SRC_REGEX).matcher(content);
        while (matcher.find()) {
            String srcStringPart = matcher.group(1);
            if (srcStringPart.contains("\"")) {
                matcher = Pattern.compile(IMAGE_SRC_REGEX).matcher(srcStringPart);
                srcStringPart = srcStringPart.substring(0, srcStringPart.indexOf("\""));
            }
            String attachmentNodeId = srcStringPart.substring(srcStringPart.lastIndexOf("/") + 1);
            imageNodeIds.add(attachmentNodeId);
        }
        StringBuilder existingUploadImagesSrcRegex = new StringBuilder();
        existingUploadImagesSrcRegex.append("src=\"");
        existingUploadImagesSrcRegex.append(CommonsUtils.getCurrentDomain());
        existingUploadImagesSrcRegex.append("/");
        existingUploadImagesSrcRegex.append(PortalContainer.getCurrentPortalContainerName());
        existingUploadImagesSrcRegex.append("/");
        existingUploadImagesSrcRegex.append(CommonsUtils.getRestContextName());
        existingUploadImagesSrcRegex.append("/jcr/?(.+)?\"");
        String repositoryAndWorkSpaceSuffix = "/repository/collaboration";
        Matcher pathMatcher = Pattern.compile(existingUploadImagesSrcRegex.toString()).matcher(content);
        while (pathMatcher.find()) {
            String srcStringPart = pathMatcher.group(1);
            if (srcStringPart.contains("\"")) {
                pathMatcher = Pattern.compile(existingUploadImagesSrcRegex.toString()).matcher(srcStringPart);
                srcStringPart = srcStringPart.substring(0, srcStringPart.indexOf("\""));
            }
            String imagePath = srcStringPart.substring(srcStringPart.indexOf(repositoryAndWorkSpaceSuffix) + repositoryAndWorkSpaceSuffix.length());
            imageNodeIds.add(imagePath);
        }
        return imageNodeIds;
    }

    private void updateNodePermissions(List<String> identifiers, String audience, Space space) throws RepositoryException {
        Session session = Utils.getSystemSession(this.sessionProviderService, this.repositoryService);
        if (!CollectionUtils.isEmpty(identifiers)) {
            for (String attachmentId : identifiers) {
                try {
                    boolean isNodeUUID = !attachmentId.contains("/");
                    Node attachmentNode = isNodeUUID ? session.getNodeByUUID(attachmentId) : (Node)session.getItem(URLDecoder.decode(attachmentId, StandardCharsets.UTF_8));
                    if (attachmentNode.getPath().startsWith(QUARANTINE)) continue;
                    if (attachmentNode.canAddMixin("exo:privilegeable")) {
                        attachmentNode.addMixin("exo:privilegeable");
                    }
                    if (audience.equals("all")) {
                        ((ExtendedNode)attachmentNode).setPermission("*:/platform/users", new String[]{"read"});
                        attachmentNode.save();
                        continue;
                    }
                    if (space == null) continue;
                    ((ExtendedNode)attachmentNode).setPermission("*:" + space.getGroupId(), new String[]{"read"});
                    attachmentNode.save();
                }
                catch (Exception e) {
                    LOG.error("Error while sharing attachment of id : {} to space: {}", new Object[]{attachmentId, space.getDisplayName(), e});
                }
            }
        }
    }
}

