/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcache;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.portletcache.FragmentCacheService;
import org.exoplatform.services.portletcache.MarkupFragment;
import org.exoplatform.services.portletcache.PortletRenderContext;
import org.exoplatform.services.portletcache.WindowKey;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class PortletCacheFilter
implements PortletFilter,
ActionFilter,
RenderFilter,
EventFilter {
    private static final String EXO_CACHE = "exo.cache";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String SHARED_CACHE = "sharedCache";
    private static final String TURN_ON_QUICK_EDIT = "turnOnQuickEdit";
    private static final String NO_CACHE = "nocache";

    public void init(FilterConfig cfg) throws PortletException {
    }

    public void destroy() {
    }

    public void doFilter(ActionRequest req, ActionResponse resp, FilterChain chain) throws IOException, PortletException {
        chain.doFilter(req, resp);
    }

    public void doFilter(EventRequest req, EventResponse resp, FilterChain chain) throws IOException, PortletException {
        chain.doFilter(req, resp);
    }

    private boolean isPortalEditMode() {
        return Util.getUIPortalApplication().getModeState() != 0;
    }

    public void doFilter(RenderRequest req, RenderResponse resp, FilterChain chain) throws IOException, PortletException {
        String exoCacheUsageRequestParam = Util.getPortalRequestContext().getRequestParameter(EXO_CACHE);
        PortalRequestContext ctx = PortalRequestContext.getCurrentInstance();
        Boolean quickEdit = (Boolean)ctx.getRequest().getSession().getAttribute(TURN_ON_QUICK_EDIT);
        if (quickEdit == null) {
            quickEdit = false;
        }
        Boolean sharedCache = TRUE.equals(req.getPreferences().getValue(SHARED_CACHE, FALSE));
        PortletMode portletMode = req.getPortletMode();
        if (!(NO_CACHE.equals(exoCacheUsageRequestParam) || !sharedCache.booleanValue() || req.getRemoteUser() != null && (quickEdit.booleanValue() || this.isPortalEditMode()) || PortletMode.EDIT.equals((Object)portletMode))) {
            HashMap<String, String[]> query = new HashMap<String, String[]>();
            query.putAll(ctx.getRequest().getParameterMap());
            query.put("VISIBILITY", new String[]{req.getRemoteUser() != null ? "PRIVATE" : "PUBLIC"});
            String referer = ctx.getRequest().getHeader("referer");
            if (referer != null) {
                query.put("REFERER", new String[]{referer});
            }
            query.put("PATH", new String[]{ctx.getRequestURI()});
            Locale locale = ctx.getLocale();
            WindowKey key = new WindowKey(req.getWindowID(), req.getWindowState(), req.getPortletMode(), locale, req.getParameterMap(), query);
            FragmentCacheService service = WCMCoreUtils.getService(FragmentCacheService.class);
            MarkupFragment value = service.getMarkupFragment(new PortletRenderContext(req, resp, chain), key);
            OutputStream out = resp.getPortletOutputStream();
            out.write(value.data);
            out.close();
        } else {
            chain.doFilter(req, resp);
        }
    }
}

