/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.action;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotRootNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionRealNodeListener;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;

@ComponentConfig(events={@EventConfig(listeners={ManageHiddenActionListener.class})})
public class ManageHiddenActionComponent
extends UIComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotRootNodeFilter(), new CanSetPropertyFilter(), new IsNotLockedFilter(), new IsCheckedOutFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static class ManageHiddenActionListener
    extends UIActionBarActionRealNodeListener<ManageHiddenActionComponent> {
        public void processEvent(Event<ManageHiddenActionComponent> event) throws Exception {
            UIActionBar uiActionBar = (UIActionBar)((ManageHiddenActionComponent)((Object)event.getSource())).getAncestorOfType(UIActionBar.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiActionBar.getAncestorOfType(UIJCRExplorer.class);
            Node selectedNode = uiExplorer.getRealCurrentNode();
            UIApplication uiApp = (UIApplication)uiActionBar.getAncestorOfType(UIApplication.class);
            if (selectedNode.isNodeType("exo:hiddenable")) {
                selectedNode.removeMixin("exo:hiddenable");
                selectedNode.save();
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.removed-hidden-mixin", null));
                uiExplorer.updateAjax(event);
            } else if (selectedNode.canAddMixin("exo:hiddenable")) {
                selectedNode.addMixin("exo:hiddenable");
                selectedNode.save();
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.added-hidden-mixin", null));
                uiExplorer.updateAjax(event);
            }
        }
    }
}

