/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.NodeSearchFilter;
import org.exoplatform.services.wcm.search.base.QueryData;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class QueryResultPageList<E>
extends AbstractPageList<E> {
    private static final Log LOG = ExoLogger.getLogger((String)QueryResultPageList.class.getName());
    private static final String ORDER_BY = "ORDER BY";
    private QueryData queryData_;
    private int bufferSize_;
    protected List<E> buffer;
    private Map<E, Integer> dataSet;

    public QueryResultPageList(int pageSize, QueryData queryData, int total, int bufferSize, NodeSearchFilter filter, SearchDataCreator creator) {
        super(pageSize);
        this.queryData_ = queryData.clone();
        this.offset_ = (int)queryData.getOffset();
        this.bufferSize_ = bufferSize;
        this.filter = filter;
        this.searchDataCreator = creator;
        this.setAvailablePage(total);
        this.removeRedundantPages(Math.min(this.bufferSize_ / pageSize, 5));
        this.dataSet = new HashMap<E, Integer>();
        this.loadedAllData_ = false;
    }

    public int getBufferSize() {
        return this.bufferSize_;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize_ = bufferSize;
    }

    public int getOffset() {
        return this.offset_;
    }

    public void setOffset(int offset) {
        this.offset_ = offset;
    }

    public QueryData getQueryData() {
        return this.queryData_;
    }

    public void setQueryData(QueryData queryData) {
        this.queryData_ = queryData;
    }

    public void setPageSize(int pageSize) {
        super.setPageSize(pageSize);
        this.offset_ = 0;
    }

    public List getAll() throws Exception {
        return null;
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (this.buffer == null || this.buffer.size() == 0) {
            this.queryDataForBuffer(page);
        }
        int firstBufferPage = this.offset_ / this.getPageSize() + 1;
        int lastBufferPage = (this.offset_ + this.buffer.size() - 1) / this.getPageSize() + 1;
        int bufferPage = this.bufferSize_ / this.getPageSize();
        int offsetPage = firstBufferPage;
        if (page < firstBufferPage || page > lastBufferPage || this.buffer.size() == 0) {
            if (page < firstBufferPage) {
                offsetPage = Math.max(1, page - bufferPage / 3 * 2);
            } else if (page > lastBufferPage) {
                offsetPage = page;
            }
            this.offset_ = (offsetPage - 1) * this.getPageSize();
            this.queryDataForBuffer(page);
        }
        this.currentListPage_ = new ArrayList();
        for (int i = this.getFrom(); i < this.getTo(); ++i) {
            if (i - this.offset_ >= this.buffer.size()) continue;
            E data = this.buffer.get(i - this.offset_);
            this.currentListPage_.add(data);
        }
        if (this.currentListPage_.size() < this.getPageSize()) {
            this.loadedAllData_ = true;
        }
    }

    private void queryDataForBuffer(int queryPage) throws Exception {
        this.buffer = new ArrayList();
        this.dataSet = new HashMap<E, Integer>();
        SessionProvider sessionProvider = this.queryData_.isSystemSession() ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
        Session session = sessionProvider.getSession(this.queryData_.getWorkSpace(), WCMCoreUtils.getRepository());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(this.queryData_.getQueryStatement(), this.queryData_.getLanguage_());
        int offset = this.offset_;
        SiteSearchService siteSearchService = (SiteSearchService)WCMCoreUtils.getService(SiteSearchService.class);
        Map<?, Integer> found = siteSearchService.getFoundNodes(ConversationState.getCurrent().getIdentity().getUserId(), this.queryData_.getQueryStatement());
        Map<Integer, Integer> drop = siteSearchService.getDropNodes(ConversationState.getCurrent().getIdentity().getUserId(), this.queryData_.getQueryStatement());
        for (int i = 0; i < queryPage; ++i) {
            if (!drop.containsKey(i)) continue;
            offset += drop.get(i).intValue();
        }
        ((QueryImpl)query).setOffset((long)offset);
        long prevSize = 0L;
        int bufSize = this.bufferSize_;
        while (true) {
            int position = this.offset_;
            int page = position / this.getPageSize() + 1;
            int prevPage = -1;
            drop.put(page, 0);
            ((QueryImpl)query).setLimit((long)bufSize);
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            RowIterator rowIter = queryResult.getRows();
            long size = iter.getSize();
            int count = 0;
            this.buffer.clear();
            this.dataSet.clear();
            while (iter.hasNext() && count < this.bufferSize_) {
                Node newNode = iter.nextNode();
                Row newRow = rowIter.nextRow();
                if (this.filter != null) {
                    newNode = this.filter.filterNodeToDisplay(newNode);
                }
                if (newNode != null && this.searchDataCreator != null) {
                    Object data = this.searchDataCreator.createData(newNode, newRow, null);
                    if (!(data == null || this.dataSet.containsKey(data) || found != null && found.containsKey(data) && found.get(data) < page)) {
                        this.buffer.add(data);
                        this.dataSet.put(data, page);
                        ++count;
                        page = (++position - 1) / this.getPageSize() + 1;
                        if (page != prevPage) {
                            prevPage = page;
                            drop.put(page, 0);
                        }
                        if (position % this.getPageSize() != 0) continue;
                        ++page;
                        continue;
                    }
                    if (!drop.containsKey(page)) continue;
                    drop.put(page, drop.get(page) + 1);
                    continue;
                }
                if (newNode != null || !drop.containsKey(page)) continue;
                drop.put(page, drop.get(page) + 1);
            }
            if (size == prevSize) {
                this.loadedAllData_ = true;
                break;
            }
            if (count == this.bufferSize_) break;
            bufSize = 2 * bufSize;
            prevSize = size;
        }
        for (Map.Entry<E, Integer> e : this.dataSet.entrySet()) {
            found.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void sortData() {
        block4: {
            if (this.sortByField != null) {
                String statement = this.queryData_.getQueryStatement().toUpperCase();
                int orderByIndex = statement.lastIndexOf(ORDER_BY);
                String[] orderStrings = orderByIndex >= 0 ? this.queryData_.getQueryStatement().substring(orderByIndex + ORDER_BY.length()).split(",") : new String[]{};
                StringBuffer newStatement = orderByIndex >= 0 ? new StringBuffer(this.queryData_.getQueryStatement().substring(0, orderByIndex + ORDER_BY.length())) : new StringBuffer(this.queryData_.getQueryStatement());
                newStatement.append(" ").append(this.getSortByField(this.sortByField, this.queryData_.getLanguage_())).append(" ").append(this.getOrderForQuery(this.order, this.queryData_.getLanguage_()));
                for (String orderString : orderStrings) {
                    if (orderString.toUpperCase().contains(this.sortByField.toUpperCase())) continue;
                    newStatement.append(", ").append(orderString);
                }
                this.queryData_.setQueryStatement(newStatement.toString());
                try {
                    this.buffer.clear();
                    this.populateCurrentPage(this.currentPage_);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
    }

    private String getSortByField(String sortField, String queryLanguage) {
        return (String)("sql".equals(queryLanguage) ? sortField : "@" + sortField) + ("jcr:score".equals(sortField.toLowerCase()) ? "()" : "");
    }

    private String getOrderForQuery(String order, String queryLanguage) {
        if ("sql".equals(queryLanguage)) {
            return order.toUpperCase().startsWith("A") ? "ASC" : "DESC";
        }
        return order.toUpperCase().startsWith("A") ? "ascending" : "descending";
    }

    @Override
    public List<E> getPageWithOffsetCare(int page) throws Exception {
        return this.getPage(this.offset_ / this.getPageSize() + page);
    }

    public int getTo() {
        int to = this.currentPage_ * this.getPageSize();
        if (to > this.available_ + this.offset_) {
            to = this.available_ + this.offset_;
        }
        return to;
    }

    @Override
    public boolean loadedAllData() {
        return this.loadedAllData_;
    }
}

